/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.bwa.java;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.sting.alignment.reference.bwt.BWT;

public class LowerBound {
    public final long loIndex;
    public final long hiIndex;
    public final long width;
    public final int value;

    private LowerBound(long loIndex, long hiIndex, int value) {
        this.loIndex = loIndex;
        this.hiIndex = hiIndex;
        this.width = hiIndex - loIndex + 1L;
        this.value = value;
    }

    public static List<LowerBound> create(Byte[] bases, BWT bwt) {
        ArrayList<LowerBound> bounds = new ArrayList<LowerBound>();
        long loIndex = 0L;
        long hiIndex = bwt.length();
        int mismatches = 0;
        for (int i = bases.length - 1; i >= 0; --i) {
            Byte base = bases[i];
            if (base != null) {
                loIndex = bwt.counts(base) + bwt.occurrences(base, loIndex - 1L) + 1L;
                hiIndex = bwt.counts(base) + bwt.occurrences(base, hiIndex);
            }
            if (base == null || loIndex > hiIndex) {
                loIndex = 0L;
                hiIndex = bwt.length();
                ++mismatches;
            }
            bounds.add(0, new LowerBound(loIndex, hiIndex, mismatches));
        }
        return bounds;
    }

    public String toString() {
        return String.format("LowerBound: w = %d, value = %d", this.width, this.value);
    }
}

