/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import net.sf.picard.reference.ReferenceSequence;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceView;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class LocusReferenceView
extends ReferenceView {
    private GenomeLoc bounds;
    private final int windowStart;
    private final int windowStop;
    private ReferenceSequence referenceSequence;

    public LocusReferenceView(LocusShardDataProvider provider) {
        super(provider);
        this.initializeBounds(provider);
        this.windowStop = 0;
        this.windowStart = 0;
        this.initializeReferenceSequence(this.bounds);
    }

    public LocusReferenceView(Walker walker, LocusShardDataProvider provider) {
        super(provider);
        this.initializeBounds(provider);
        if (walker.getClass().isAnnotationPresent(Reference.class)) {
            Window window = walker.getClass().getAnnotation(Reference.class).window();
            if (window.start() > 0) {
                throw new ReviewedStingException("Reference window starts after current locus");
            }
            if (window.stop() < 0) {
                throw new ReviewedStingException("Reference window ends before current locus");
            }
            this.windowStart = window.start();
            this.windowStop = window.stop();
        } else {
            this.windowStart = 0;
            this.windowStop = 0;
        }
        if (this.bounds != null) {
            int expandedStart = this.getWindowStart(this.bounds);
            int expandedStop = this.getWindowStop(this.bounds);
            this.initializeReferenceSequence(this.genomeLocParser.createGenomeLoc(this.bounds.getContig(), this.bounds.getContigIndex(), expandedStart, expandedStop));
        }
    }

    private void initializeBounds(LocusShardDataProvider provider) {
        if (provider.getLocus() != null) {
            int sequenceLength = this.reference.getSequenceDictionary().getSequence(provider.getLocus().getContig()).getSequenceLength();
            this.bounds = this.genomeLocParser.createGenomeLoc(provider.getLocus().getContig(), Math.max(provider.getLocus().getStart(), 1), Math.min(provider.getLocus().getStop(), sequenceLength));
        } else {
            this.bounds = null;
        }
    }

    private void initializeReferenceSequence(GenomeLoc locus) {
        this.referenceSequence = this.reference.getSubsequenceAt(locus.getContig(), locus.getStart(), locus.getStop());
    }

    protected GenomeLoc trimToBounds(GenomeLoc l) {
        int expandedStart = this.getWindowStart(this.bounds);
        int expandedStop = this.getWindowStop(this.bounds);
        if (l.getStart() < expandedStart) {
            l = this.genomeLocParser.setStart(l, expandedStart);
        }
        if (l.getStop() > expandedStop) {
            l = this.genomeLocParser.setStop(l, expandedStop);
        }
        return l;
    }

    public ReferenceContext getReferenceContext(GenomeLoc genomeLoc) {
        GenomeLoc window = this.genomeLocParser.createGenomeLoc(genomeLoc.getContig(), this.bounds.getContigIndex(), this.getWindowStart(genomeLoc), this.getWindowStop(genomeLoc));
        int refStart = -1;
        if (this.bounds != null) {
            window = this.trimToBounds(window);
            refStart = window.getStart() - this.getWindowStart(this.bounds);
        } else {
            if (this.referenceSequence == null || this.referenceSequence.getContigIndex() != genomeLoc.getContigIndex()) {
                this.referenceSequence = this.reference.getSequence(genomeLoc.getContig());
            }
            refStart = window.getStart() - 1;
        }
        int len = window.size();
        return new ReferenceContext(this.genomeLocParser, genomeLoc, window, new Provider(refStart, len));
    }

    @Override
    public byte[] getReferenceBases(GenomeLoc genomeLoc) {
        return super.getReferenceBases(genomeLoc);
    }

    private int getWindowStart(GenomeLoc locus) {
        if (locus.getStart() < 1) {
            return 1;
        }
        return Math.max(locus.getStart() + this.windowStart, 1);
    }

    private int getWindowStop(GenomeLoc locus) {
        int sequenceLength = this.reference.getSequenceDictionary().getSequence(locus.getContig()).getSequenceLength();
        if (locus.getStop() > sequenceLength) {
            return sequenceLength;
        }
        return Math.min(locus.getStop() + this.windowStop, sequenceLength);
    }

    public class Provider
    implements ReferenceContext.ReferenceContextRefProvider {
        int refStart;
        int len;

        public Provider(int refStart, int len) {
            this.refStart = refStart;
            this.len = len;
        }

        @Override
        public byte[] getBases() {
            byte[] bases = new byte[this.len];
            System.arraycopy(LocusReferenceView.this.referenceSequence.getBases(), this.refStart, bases, 0, this.len);
            return bases;
        }
    }
}

