/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.GATKChunk;
import net.sf.samtools.SAMFileSpan;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;
import org.broadinstitute.sting.utils.interval.IntervalUtils;

public class FilePointer {
    protected final SortedMap<SAMReaderID, SAMFileSpan> fileSpans = new TreeMap<SAMReaderID, SAMFileSpan>();
    protected final List<GenomeLoc> locations = new ArrayList<GenomeLoc>();
    protected final boolean isRegionUnmapped;
    private boolean isMonolithic = false;
    private Integer contigIndex = null;

    public FilePointer(List<GenomeLoc> locations) {
        this.locations.addAll(locations);
        this.isRegionUnmapped = this.checkUnmappedStatus();
        this.validateAllLocations();
        if (locations.size() > 0) {
            this.contigIndex = locations.get(0).getContigIndex();
        }
    }

    public FilePointer(GenomeLoc ... locations) {
        this(Arrays.asList(locations));
    }

    public FilePointer(Map<SAMReaderID, SAMFileSpan> fileSpans, List<GenomeLoc> locations) {
        this(locations);
        this.fileSpans.putAll(fileSpans);
    }

    private boolean checkUnmappedStatus() {
        boolean foundMapped = false;
        boolean foundUnmapped = false;
        for (GenomeLoc location : this.locations) {
            if (GenomeLoc.isUnmapped(location)) {
                foundUnmapped = true;
                continue;
            }
            foundMapped = true;
        }
        if (foundMapped && foundUnmapped) {
            throw new ReviewedStingException("BUG: File pointers cannot be mixed mapped/unmapped.");
        }
        return foundUnmapped;
    }

    private void validateAllLocations() {
        if (this.isRegionUnmapped || this.isMonolithic) {
            return;
        }
        Integer previousContigIndex = null;
        for (GenomeLoc location : this.locations) {
            if (previousContigIndex != null && previousContigIndex.intValue() != location.getContigIndex()) {
                throw new ReviewedStingException("Non-monolithic file pointers must contain intervals from at most one contig");
            }
            previousContigIndex = location.getContigIndex();
        }
    }

    private void validateLocation(GenomeLoc location) {
        if (this.isRegionUnmapped != GenomeLoc.isUnmapped(location)) {
            throw new ReviewedStingException("BUG: File pointers cannot be mixed mapped/unmapped.");
        }
        if (!this.isRegionUnmapped && !this.isMonolithic && this.contigIndex != null && this.contigIndex.intValue() != location.getContigIndex()) {
            throw new ReviewedStingException("Non-monolithic file pointers must contain intervals from at most one contig");
        }
    }

    public Map<SAMReaderID, SAMFileSpan> getFileSpans() {
        return Collections.unmodifiableMap(this.fileSpans);
    }

    public List<GenomeLoc> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    public int getContigIndex() {
        return this.locations.size() > 0 ? this.locations.get(0).getContigIndex() : -1;
    }

    public boolean isMonolithic() {
        return this.isMonolithic;
    }

    public void setIsMonolithic(boolean isMonolithic) {
        this.isMonolithic = isMonolithic;
    }

    public boolean equals(Object other) {
        if (!(other instanceof FilePointer)) {
            return false;
        }
        FilePointer otherFilePointer = (FilePointer)other;
        if (this.locations.size() != otherFilePointer.locations.size()) {
            return false;
        }
        for (int i = 0; i < this.locations.size(); ++i) {
            if (this.locations.get(i).equals(otherFilePointer.locations.get(i))) continue;
            return false;
        }
        if (this.fileSpans.size() != otherFilePointer.fileSpans.size()) {
            return false;
        }
        Iterator<Map.Entry<SAMReaderID, SAMFileSpan>> thisEntries = this.fileSpans.entrySet().iterator();
        Iterator<Map.Entry<SAMReaderID, SAMFileSpan>> otherEntries = otherFilePointer.fileSpans.entrySet().iterator();
        while (thisEntries.hasNext() || otherEntries.hasNext()) {
            if (((Object)thisEntries.next()).equals(otherEntries.next())) continue;
            return false;
        }
        return true;
    }

    public void addLocation(GenomeLoc location) {
        this.validateLocation(location);
        this.locations.add(location);
        if (this.contigIndex == null) {
            this.contigIndex = location.getContigIndex();
        }
    }

    public void addFileSpans(SAMReaderID id, SAMFileSpan fileSpan) {
        this.fileSpans.put(id, fileSpan);
    }

    public void addFileSpans(Map<SAMReaderID, GATKBAMFileSpan> fileSpans) {
        this.fileSpans.putAll(fileSpans);
    }

    public long size() {
        long size = 0L;
        for (SAMFileSpan fileSpan : this.fileSpans.values()) {
            size += ((GATKBAMFileSpan)fileSpan).size();
        }
        return size;
    }

    public long minus(FilePointer other) {
        long difference = 0L;
        PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>> thisIterator = new PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>>(this.fileSpans.entrySet().iterator());
        PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>> otherIterator = new PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>>(other.fileSpans.entrySet().iterator());
        while (thisIterator.hasNext()) {
            if (!otherIterator.hasNext()) {
                GATKBAMFileSpan nextSpan = (GATKBAMFileSpan)thisIterator.next().getValue();
                difference += nextSpan.size();
                continue;
            }
            int compareValue = thisIterator.peek().getKey().compareTo(otherIterator.peek().getKey());
            if (compareValue < 0) {
                difference += ((GATKBAMFileSpan)thisIterator.next().getValue()).size();
                continue;
            }
            if (compareValue > 0) {
                difference += ((GATKBAMFileSpan)otherIterator.next().getValue()).size();
                continue;
            }
            GATKBAMFileSpan thisRegion = (GATKBAMFileSpan)thisIterator.next().getValue();
            GATKBAMFileSpan otherRegion = (GATKBAMFileSpan)otherIterator.next().getValue();
            difference += Math.abs(thisRegion.minus(otherRegion).size());
        }
        return difference;
    }

    public FilePointer combine(GenomeLocParser parser, FilePointer other) {
        FilePointer combined = new FilePointer(new GenomeLoc[0]);
        ArrayList<GenomeLoc> intervals = new ArrayList<GenomeLoc>();
        intervals.addAll(this.locations);
        intervals.addAll(other.locations);
        for (GenomeLoc interval : IntervalUtils.sortAndMergeIntervals(parser, intervals, IntervalMergingRule.ALL)) {
            combined.addLocation(interval);
        }
        PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>> thisIterator = new PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>>(this.fileSpans.entrySet().iterator());
        PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>> otherIterator = new PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>>(other.fileSpans.entrySet().iterator());
        while (thisIterator.hasNext() || otherIterator.hasNext()) {
            int compareValue = !otherIterator.hasNext() ? -1 : (!thisIterator.hasNext() ? 1 : thisIterator.peek().getKey().compareTo(otherIterator.peek().getKey()));
            if (compareValue < 0) {
                this.mergeElementsInto(combined, thisIterator);
                continue;
            }
            if (compareValue > 0) {
                this.mergeElementsInto(combined, otherIterator);
                continue;
            }
            this.mergeElementsInto(combined, thisIterator, otherIterator);
        }
        return combined;
    }

    private void mergeElementsInto(FilePointer combined, Iterator<Map.Entry<SAMReaderID, SAMFileSpan>> ... iterators) {
        if (iterators.length == 0) {
            throw new ReviewedStingException("Tried to add zero elements to an existing file pointer.");
        }
        Map.Entry<SAMReaderID, SAMFileSpan> initialElement = iterators[0].next();
        GATKBAMFileSpan fileSpan = (GATKBAMFileSpan)initialElement.getValue();
        for (int i = 1; i < iterators.length; ++i) {
            fileSpan = fileSpan.union((GATKBAMFileSpan)iterators[i].next().getValue());
        }
        combined.addFileSpans(initialElement.getKey(), fileSpan);
    }

    public static FilePointer union(List<FilePointer> filePointers, GenomeLocParser parser) {
        if (filePointers == null || filePointers.isEmpty()) {
            return new FilePointer(new GenomeLoc[0]);
        }
        HashMap<SAMReaderID, List<GATKChunk>> fileChunks = new HashMap<SAMReaderID, List<GATKChunk>>();
        ArrayList<GenomeLoc> locations = new ArrayList<GenomeLoc>();
        for (FilePointer filePointer : filePointers) {
            locations.addAll(filePointer.getLocations());
            for (Map.Entry<SAMReaderID, SAMFileSpan> entry : filePointer.getFileSpans().entrySet()) {
                GATKBAMFileSpan fileSpan = (GATKBAMFileSpan)entry.getValue();
                if (fileChunks.containsKey(entry.getKey())) {
                    ((List)fileChunks.get(entry.getKey())).addAll(fileSpan.getGATKChunks());
                    continue;
                }
                fileChunks.put(entry.getKey(), fileSpan.getGATKChunks());
            }
        }
        ArrayList<GenomeLoc> sortedMergedLocations = new ArrayList<GenomeLoc>();
        sortedMergedLocations.addAll(IntervalUtils.sortAndMergeIntervals(parser, locations, IntervalMergingRule.ALL));
        HashMap<SAMReaderID, SAMFileSpan> mergedFileSpans = new HashMap<SAMReaderID, SAMFileSpan>(fileChunks.size());
        for (Map.Entry<SAMReaderID, SAMFileSpan> entry : fileChunks.entrySet()) {
            List unmergedChunks = (List)((Object)entry.getValue());
            mergedFileSpans.put(entry.getKey(), new GATKBAMFileSpan(unmergedChunks.toArray(new GATKChunk[unmergedChunks.size()])).union(new GATKBAMFileSpan()));
        }
        return new FilePointer(mergedFileSpans, sortedMergedLocations);
    }

    public boolean hasFileSpansOverlappingWith(FilePointer other) {
        for (Map.Entry<SAMReaderID, SAMFileSpan> thisFilePointerEntry : this.fileSpans.entrySet()) {
            GATKBAMFileSpan thisFileSpan = new GATKBAMFileSpan(thisFilePointerEntry.getValue());
            SAMFileSpan otherEntry = (SAMFileSpan)other.fileSpans.get(thisFilePointerEntry.getKey());
            if (otherEntry == null) continue;
            GATKBAMFileSpan otherFileSpan = new GATKBAMFileSpan(otherEntry);
            if (!thisFileSpan.getExtent().overlaps(otherFileSpan.getExtent())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FilePointer:%n");
        builder.append("\tlocations = {");
        builder.append(Utils.join(";", this.locations));
        builder.append("}%n\tregions = %n");
        for (Map.Entry<SAMReaderID, SAMFileSpan> entry : this.fileSpans.entrySet()) {
            builder.append(entry.getKey());
            builder.append("= {");
            builder.append(entry.getValue());
            builder.append("}");
        }
        return builder.toString();
    }
}

