/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.datasources.reads.FilePointer;
import org.broadinstitute.sting.gatk.datasources.reads.ReadShard;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.reads.ShardBalancer;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ReadShardBalancer
extends ShardBalancer {
    private static Logger logger = Logger.getLogger(ReadShardBalancer.class);

    @Override
    public Iterator<Shard> iterator() {
        return new Iterator<Shard>(){
            private Shard nextShard = null;
            private FilePointer currentContigFilePointer = null;
            private PeekableIterator<SAMRecord> currentContigReadsIterator = null;
            private int totalFilePointersConsumed = 0;
            private boolean encounteredMonolithicFilePointer = false;
            {
                this.createNextContigFilePointer();
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.nextShard != null;
            }

            @Override
            public Shard next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next read shard available");
                }
                Shard currentShard = this.nextShard;
                this.advance();
                return currentShard;
            }

            private void advance() {
                this.nextShard = null;
                while (this.nextShard == null && this.currentContigFilePointer != null) {
                    if (this.currentContigReadsIterator != null && !this.currentContigReadsIterator.hasNext()) {
                        this.currentContigReadsIterator.close();
                        this.createNextContigFilePointer();
                        this.currentContigReadsIterator = null;
                    }
                    if (this.currentContigFilePointer == null) continue;
                    ReadShard shard = new ReadShard(ReadShardBalancer.this.parser, ReadShardBalancer.this.readsDataSource, this.currentContigFilePointer.fileSpans, this.currentContigFilePointer.locations, this.currentContigFilePointer.isRegionUnmapped);
                    if (this.currentContigReadsIterator == null) {
                        this.currentContigReadsIterator = new PeekableIterator<SAMRecord>(ReadShardBalancer.this.readsDataSource.getIterator(shard));
                    }
                    if (!this.currentContigReadsIterator.hasNext()) continue;
                    ((Shard)shard).fill(this.currentContigReadsIterator);
                    this.nextShard = shard;
                }
            }

            private void createNextContigFilePointer() {
                this.currentContigFilePointer = null;
                ArrayList<FilePointer> nextContigFilePointers = new ArrayList<FilePointer>();
                logger.info("Loading BAM index data for next contig");
                while (ReadShardBalancer.this.filePointers.hasNext()) {
                    if (this.encounteredMonolithicFilePointer) {
                        throw new ReviewedStingException("Bug: encountered additional FilePointers after encountering a monolithic FilePointer");
                    }
                    if (((FilePointer)ReadShardBalancer.this.filePointers.peek()).isMonolithic()) {
                        if (this.totalFilePointersConsumed > 0) {
                            throw new ReviewedStingException("Bug: encountered additional FilePointers before encountering a monolithic FilePointer");
                        }
                        this.encounteredMonolithicFilePointer = true;
                        logger.debug(String.format("Encountered monolithic FilePointer: %s", ReadShardBalancer.this.filePointers.peek()));
                    }
                    if (!nextContigFilePointers.isEmpty() && (((FilePointer)nextContigFilePointers.get((int)0)).isRegionUnmapped || ((FilePointer)ReadShardBalancer.this.filePointers.peek()).isRegionUnmapped || ((FilePointer)nextContigFilePointers.get(0)).getContigIndex() != ((FilePointer)ReadShardBalancer.this.filePointers.peek()).getContigIndex()) && (!((FilePointer)nextContigFilePointers.get((int)0)).isRegionUnmapped || !((FilePointer)ReadShardBalancer.this.filePointers.peek()).isRegionUnmapped)) break;
                    nextContigFilePointers.add((FilePointer)ReadShardBalancer.this.filePointers.next());
                    ++this.totalFilePointersConsumed;
                }
                if (!nextContigFilePointers.isEmpty()) {
                    this.currentContigFilePointer = FilePointer.union(nextContigFilePointers, ReadShardBalancer.this.parser);
                }
                if (this.currentContigFilePointer != null) {
                    logger.info("Done loading BAM index data for next contig");
                    logger.debug(String.format("Next contig FilePointer: %s", this.currentContigFilePointer));
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove from shard balancing iterator");
            }
        };
    }
}

