/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.downsampling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.downsampling.ReadsDownsampler;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class FractionalDownsampler<T extends SAMRecord>
implements ReadsDownsampler<T> {
    private ArrayList<T> selectedReads;
    private int cutoffForInclusion;
    private int numDiscardedItems;
    private static final int RANDOM_POOL_SIZE = 10000;

    public FractionalDownsampler(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new ReviewedStingException("Fraction of reads to include must be between 0.0 and 1.0, inclusive");
        }
        this.cutoffForInclusion = (int)(fraction * 10000.0);
        this.clear();
        this.reset();
    }

    @Override
    public void submit(T newRead) {
        if (GenomeAnalysisEngine.getRandomGenerator().nextInt(10000) < this.cutoffForInclusion) {
            this.selectedReads.add(newRead);
        } else {
            ++this.numDiscardedItems;
        }
    }

    @Override
    public void submit(Collection<T> newReads) {
        for (SAMRecord read : newReads) {
            this.submit((T)read);
        }
    }

    @Override
    public boolean hasFinalizedItems() {
        return this.selectedReads.size() > 0;
    }

    @Override
    public List<T> consumeFinalizedItems() {
        ArrayList<T> downsampledItems = this.selectedReads;
        this.clear();
        return downsampledItems;
    }

    @Override
    public boolean hasPendingItems() {
        return false;
    }

    @Override
    public T peekFinalized() {
        return (T)(this.selectedReads.isEmpty() ? null : (SAMRecord)this.selectedReads.get(0));
    }

    @Override
    public T peekPending() {
        return null;
    }

    @Override
    public int getNumberOfDiscardedItems() {
        return this.numDiscardedItems;
    }

    @Override
    public void signalEndOfInput() {
    }

    @Override
    public void clear() {
        this.selectedReads = new ArrayList();
    }

    @Override
    public void reset() {
        this.numDiscardedItems = 0;
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return false;
    }

    @Override
    public void signalNoMoreReadsBefore(T read) {
    }
}

