/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.downsampling;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.downsampling.ReadsDownsampler;

public class PassThroughDownsampler<T extends SAMRecord>
implements ReadsDownsampler<T> {
    private LinkedList<T> selectedReads;

    public PassThroughDownsampler() {
        this.clear();
    }

    @Override
    public void submit(T newRead) {
        this.selectedReads.add(newRead);
    }

    @Override
    public void submit(Collection<T> newReads) {
        for (SAMRecord read : newReads) {
            this.submit((T)read);
        }
    }

    @Override
    public boolean hasFinalizedItems() {
        return !this.selectedReads.isEmpty();
    }

    @Override
    public List<T> consumeFinalizedItems() {
        LinkedList<T> downsampledItems = this.selectedReads;
        this.clear();
        return downsampledItems;
    }

    @Override
    public boolean hasPendingItems() {
        return false;
    }

    @Override
    public T peekFinalized() {
        return (T)(this.selectedReads.isEmpty() ? null : (SAMRecord)this.selectedReads.getFirst());
    }

    @Override
    public T peekPending() {
        return null;
    }

    @Override
    public int getNumberOfDiscardedItems() {
        return 0;
    }

    @Override
    public void signalEndOfInput() {
    }

    @Override
    public void clear() {
        this.selectedReads = new LinkedList();
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return false;
    }

    @Override
    public void signalNoMoreReadsBefore(T read) {
    }
}

