/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.downsampling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.downsampling.ReadsDownsampler;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ReservoirDownsampler<T extends SAMRecord>
implements ReadsDownsampler<T> {
    private final int targetSampleSize;
    private final boolean expectFewOverflows;
    private List<T> reservoir;
    private boolean isLinkedList;
    private int totalReadsSeen;
    private int numDiscardedItems;

    public ReservoirDownsampler(int targetSampleSize, boolean expectFewOverflows) {
        if (targetSampleSize <= 0) {
            throw new ReviewedStingException("Cannot do reservoir downsampling with a sample size <= 0");
        }
        this.targetSampleSize = targetSampleSize;
        this.expectFewOverflows = expectFewOverflows;
        this.clear();
        this.reset();
    }

    public ReservoirDownsampler(int targetSampleSize) {
        this(targetSampleSize, false);
    }

    @Override
    public void submit(T newRead) {
        ++this.totalReadsSeen;
        if (this.totalReadsSeen <= this.targetSampleSize) {
            this.reservoir.add(newRead);
        } else {
            int randomSlot;
            if (this.isLinkedList) {
                this.reservoir = new ArrayList<T>(this.reservoir);
                this.isLinkedList = false;
            }
            if ((randomSlot = GenomeAnalysisEngine.getRandomGenerator().nextInt(this.totalReadsSeen)) < this.targetSampleSize) {
                this.reservoir.set(randomSlot, newRead);
            }
            ++this.numDiscardedItems;
        }
    }

    @Override
    public void submit(Collection<T> newReads) {
        for (SAMRecord read : newReads) {
            this.submit((T)read);
        }
    }

    @Override
    public boolean hasFinalizedItems() {
        return this.reservoir.size() > 0;
    }

    @Override
    public List<T> consumeFinalizedItems() {
        if (this.reservoir.isEmpty()) {
            return Collections.emptyList();
        }
        List<T> downsampledItems = this.reservoir;
        this.clear();
        return downsampledItems;
    }

    @Override
    public boolean hasPendingItems() {
        return false;
    }

    @Override
    public T peekFinalized() {
        return (T)(this.reservoir.isEmpty() ? null : (SAMRecord)this.reservoir.get(0));
    }

    @Override
    public T peekPending() {
        return null;
    }

    @Override
    public int getNumberOfDiscardedItems() {
        return this.numDiscardedItems;
    }

    @Override
    public void signalEndOfInput() {
    }

    @Override
    public void clear() {
        this.reservoir = this.expectFewOverflows ? new LinkedList() : new ArrayList(this.targetSampleSize);
        this.isLinkedList = this.expectFewOverflows;
        this.totalReadsSeen = 0;
    }

    @Override
    public void reset() {
        this.numDiscardedItems = 0;
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return false;
    }

    @Override
    public void signalNoMoreReadsBefore(T read) {
    }
}

