/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.executive;

import com.google.java.contract.Ensures;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.ReadMetrics;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.executive.HierarchicalMicroScheduler;
import org.broadinstitute.sting.gatk.executive.LinearMicroScheduler;
import org.broadinstitute.sting.gatk.executive.MicroSchedulerMBean;
import org.broadinstitute.sting.gatk.io.OutputTracker;
import org.broadinstitute.sting.gatk.iterators.NullSAMIterator;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.gatk.resourcemanagement.ThreadAllocation;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.traversals.TraverseActiveRegions;
import org.broadinstitute.sting.gatk.traversals.TraverseDuplicates;
import org.broadinstitute.sting.gatk.traversals.TraverseLociNano;
import org.broadinstitute.sting.gatk.traversals.TraverseReadPairs;
import org.broadinstitute.sting.gatk.traversals.TraverseReadsNano;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionWalker;
import org.broadinstitute.sting.gatk.walkers.DuplicateWalker;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.NanoSchedulable;
import org.broadinstitute.sting.gatk.walkers.ReadPairWalker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.AutoFormattingTime;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.progressmeter.ProgressMeter;
import org.broadinstitute.sting.utils.threading.ThreadEfficiencyMonitor;

public abstract class MicroScheduler
implements MicroSchedulerMBean {
    protected static final Logger logger = Logger.getLogger(MicroScheduler.class);
    final List<TraversalEngine> allCreatedTraversalEngines = new LinkedList<TraversalEngine>();
    final LinkedList<TraversalEngine> availableTraversalEngines = new LinkedList();
    final HashMap<Object, TraversalEngine> allocatedTraversalEngines = new HashMap();
    private static int instanceNumber = 0;
    protected final GenomeAnalysisEngine engine;
    protected final IndexedFastaSequenceFile reference;
    private final SAMDataSource reads;
    protected final Collection<ReferenceOrderedDataSource> rods;
    private final MBeanServer mBeanServer;
    private final ObjectName mBeanName;
    ThreadEfficiencyMonitor threadEfficiencyMonitor = null;
    final ProgressMeter progressMeter;

    public static MicroScheduler create(GenomeAnalysisEngine engine, Walker walker, SAMDataSource reads, IndexedFastaSequenceFile reference, Collection<ReferenceOrderedDataSource> rods, ThreadAllocation threadAllocation) {
        if (threadAllocation.isRunningInParallelMode()) {
            logger.info(String.format("Running the GATK in parallel mode with %d total threads, %d CPU thread(s) for each of %d data thread(s), of %d processors available on this machine", threadAllocation.getTotalNumThreads(), threadAllocation.getNumCPUThreadsPerDataThread(), threadAllocation.getNumDataThreads(), Runtime.getRuntime().availableProcessors()));
            if (threadAllocation.getTotalNumThreads() > Runtime.getRuntime().availableProcessors()) {
                logger.warn(String.format("Number of requested GATK threads %d is more than the number of available processors on this machine %d", threadAllocation.getTotalNumThreads(), Runtime.getRuntime().availableProcessors()));
            }
        }
        if (threadAllocation.getNumDataThreads() > 1) {
            if (walker.isReduceByInterval()) {
                throw new UserException.BadArgumentValue("nt", String.format("The analysis %s aggregates results by interval.  Due to a current limitation of the GATK, analyses of this type do not currently support parallel execution.  Please run your analysis without the -nt option.", engine.getWalkerName(walker.getClass())));
            }
            if (!(walker instanceof TreeReducible)) {
                throw MicroScheduler.badNT("nt", engine, walker);
            }
        }
        if (threadAllocation.getNumCPUThreadsPerDataThread() > 1 && !(walker instanceof NanoSchedulable)) {
            throw MicroScheduler.badNT("nct", engine, walker);
        }
        if (threadAllocation.getNumDataThreads() > 1) {
            return new HierarchicalMicroScheduler(engine, walker, reads, reference, rods, threadAllocation);
        }
        return new LinearMicroScheduler(engine, walker, reads, reference, rods, threadAllocation);
    }

    private static UserException badNT(String parallelArg, GenomeAnalysisEngine engine, Walker walker) {
        throw new UserException.BadArgumentValue(parallelArg, String.format("The analysis %s currently does not support parallel execution with %s.  Please run your analysis without the %s option.", engine.getWalkerName(walker.getClass()), parallelArg, parallelArg));
    }

    protected MicroScheduler(GenomeAnalysisEngine engine, Walker walker, SAMDataSource reads, IndexedFastaSequenceFile reference, Collection<ReferenceOrderedDataSource> rods, ThreadAllocation threadAllocation) {
        this.engine = engine;
        this.reads = reads;
        this.reference = reference;
        this.rods = rods;
        File progressLogFile = engine.getArguments() == null ? null : engine.getArguments().performanceLog;
        for (int i = 0; i < threadAllocation.getNumDataThreads(); ++i) {
            TraversalEngine traversalEngine = this.createTraversalEngine(walker, threadAllocation);
            this.allCreatedTraversalEngines.add(traversalEngine);
            this.availableTraversalEngines.add(traversalEngine);
        }
        this.progressMeter = new ProgressMeter(progressLogFile, this.availableTraversalEngines.peek().getTraversalUnits(), engine.getRegionsOfGenomeBeingProcessed());
        for (TraversalEngine traversalEngine : this.allCreatedTraversalEngines) {
            traversalEngine.initialize(engine, walker, this.progressMeter);
        }
        int thisInstance = instanceNumber++;
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            this.mBeanName = new ObjectName("org.broadinstitute.sting.gatk.executive:type=MicroScheduler,instanceNumber=" + thisInstance);
            this.mBeanServer.registerMBean(this, this.mBeanName);
        }
        catch (JMException ex) {
            throw new ReviewedStingException("Unable to register microscheduler with JMX", ex);
        }
    }

    @Ensures(value={"result != null"})
    private TraversalEngine createTraversalEngine(Walker walker, ThreadAllocation threadAllocation) {
        if (walker instanceof ReadWalker) {
            return new TraverseReadsNano(threadAllocation.getNumCPUThreadsPerDataThread());
        }
        if (walker instanceof LocusWalker) {
            return new TraverseLociNano(threadAllocation.getNumCPUThreadsPerDataThread());
        }
        if (walker instanceof DuplicateWalker) {
            return new TraverseDuplicates();
        }
        if (walker instanceof ReadPairWalker) {
            return new TraverseReadPairs();
        }
        if (walker instanceof ActiveRegionWalker) {
            return new TraverseActiveRegions();
        }
        throw new UnsupportedOperationException("Unable to determine traversal type, the walker is an unknown type.");
    }

    public ThreadEfficiencyMonitor getThreadEfficiencyMonitor() {
        return this.threadEfficiencyMonitor;
    }

    public void setThreadEfficiencyMonitor(ThreadEfficiencyMonitor threadEfficiencyMonitor) {
        this.threadEfficiencyMonitor = threadEfficiencyMonitor;
    }

    protected boolean abortExecution() {
        boolean abort = this.engine.exceedsRuntimeLimit(this.progressMeter.getRuntimeInNanoseconds(), TimeUnit.NANOSECONDS);
        if (abort) {
            AutoFormattingTime aft = new AutoFormattingTime(this.engine.getRuntimeLimitInNanoseconds(), -1, 4);
            logger.info("Aborting execution (cleanly) because the runtime has exceeded the requested maximum " + aft);
        }
        return abort;
    }

    public abstract Object execute(Walker var1, Iterable<Shard> var2);

    protected void startingExecution() {
        this.progressMeter.start();
    }

    public abstract OutputTracker getOutputTracker();

    protected StingSAMIterator getReadIterator(Shard shard) {
        return !this.reads.isEmpty() ? this.reads.seek(shard) : new NullSAMIterator();
    }

    protected void executionIsDone() {
        this.progressMeter.notifyDone(this.engine.getCumulativeMetrics().getNumIterations());
        this.printReadFilteringStats();
        this.shutdownTraversalEngines();
        if (this.threadEfficiencyMonitor != null) {
            this.threadEfficiencyMonitor.threadIsDone(Thread.currentThread());
            this.threadEfficiencyMonitor.printUsageInformation(logger);
        }
    }

    public synchronized void shutdownTraversalEngines() {
        for (TraversalEngine te : this.allCreatedTraversalEngines) {
            te.shutdown();
        }
        this.allCreatedTraversalEngines.clear();
        this.availableTraversalEngines.clear();
    }

    private void printReadFilteringStats() {
        ReadMetrics cumulativeMetrics = this.engine.getCumulativeMetrics();
        if (cumulativeMetrics.getNumReadsSeen() > 0L) {
            long nSkippedReads = 0L;
            Iterator<Object> i$ = cumulativeMetrics.getCountsByFilter().values().iterator();
            while (i$.hasNext()) {
                long l = i$.next();
                nSkippedReads += l;
            }
            logger.info(String.format("%d reads were filtered out during traversal out of %d total (%.2f%%)", nSkippedReads, cumulativeMetrics.getNumReadsSeen(), 100.0 * MathUtils.ratio(nSkippedReads, cumulativeMetrics.getNumReadsSeen())));
            for (Map.Entry entry : cumulativeMetrics.getCountsByFilter().entrySet()) {
                long count = (Long)entry.getValue();
                logger.info(String.format("  -> %d reads (%.2f%% of total) failing %s", count, 100.0 * MathUtils.ratio(count, cumulativeMetrics.getNumReadsSeen()), entry.getKey()));
            }
        }
    }

    public GenomeAnalysisEngine getEngine() {
        return this.engine;
    }

    public SAMDataSource getSAMDataSource() {
        return this.reads;
    }

    public IndexedFastaSequenceFile getReference() {
        return this.reference;
    }

    protected void cleanup() {
        try {
            this.mBeanServer.unregisterMBean(this.mBeanName);
        }
        catch (JMException ex) {
            throw new ReviewedStingException("Unable to unregister microscheduler with JMX", ex);
        }
    }

    @Ensures(value={"result != null"})
    protected synchronized TraversalEngine borrowTraversalEngine(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        TraversalEngine engine = this.allocatedTraversalEngines.get(key);
        if (engine == null) {
            if (this.availableTraversalEngines.isEmpty()) {
                throw new IllegalStateException("no traversal engines were available");
            }
            this.allocatedTraversalEngines.put(key, this.availableTraversalEngines.pop());
            return this.allocatedTraversalEngines.get(key);
        }
        return engine;
    }

    protected synchronized void returnTraversalEngine(Object key, TraversalEngine traversalEngine) {
        if (traversalEngine == null) {
            throw new IllegalArgumentException("Attempting to push a null traversal engine");
        }
        if (!this.allCreatedTraversalEngines.contains(traversalEngine)) {
            throw new IllegalArgumentException("Attempting to push a traversal engine not created by this MicroScheduler" + this.engine);
        }
        if (!this.allocatedTraversalEngines.containsKey(key)) {
            throw new IllegalArgumentException("No traversal engine was never checked out with key " + key);
        }
    }
}

