/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.stubs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.broadinstitute.sting.gatk.io.OutputTracker;
import org.broadinstitute.sting.gatk.io.stubs.Stub;

public class OutputStreamStub
extends OutputStream
implements Stub<OutputStream> {
    private final File targetFile;
    private final OutputStream targetStream;
    private OutputTracker outputTracker = null;

    public OutputStreamStub(File targetFile) {
        this.targetFile = targetFile;
        this.targetStream = null;
    }

    public OutputStreamStub(OutputStream targetStream) {
        this.targetFile = null;
        this.targetStream = targetStream;
    }

    @Override
    public File getOutputFile() {
        return this.targetFile;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.targetStream;
    }

    @Override
    public void register(OutputTracker outputTracker) {
        this.outputTracker = outputTracker;
    }

    @Override
    public void flush() throws IOException {
        this.outputTracker.getStorage(this).flush();
    }

    @Override
    public void close() throws IOException {
        this.outputTracker.getStorage(this).close();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputTracker.getStorage(this).write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputTracker.getStorage(this).write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.outputTracker.getStorage(this).write(b);
    }
}

