/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.stubs;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.gatk.CommandLineExecutable;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.io.OutputTracker;
import org.broadinstitute.sting.gatk.io.stubs.Stub;
import org.broadinstitute.sting.utils.classloader.JVMUtils;
import org.broadinstitute.sting.utils.variant.GATKVCFUtils;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;

public class VariantContextWriterStub
implements Stub<VariantContextWriter>,
VariantContextWriter {
    public static final boolean UPDATE_CONTIG_HEADERS = true;
    private final GenomeAnalysisEngine engine;
    private final File genotypeFile;
    private final PrintStream genotypeStream;
    private VCFHeader vcfHeader = null;
    private boolean isCompressed = false;
    private final Collection<Object> argumentSources;
    private boolean skipWritingCommandLineHeader = false;
    private boolean doNotWriteGenotypes = false;
    private boolean forceBCF = false;
    protected OutputTracker outputTracker = null;

    public VariantContextWriterStub(GenomeAnalysisEngine engine, File genotypeFile, Collection<Object> argumentSources) {
        this.engine = engine;
        this.genotypeFile = genotypeFile;
        this.genotypeStream = null;
        this.argumentSources = argumentSources;
    }

    public VariantContextWriterStub(GenomeAnalysisEngine engine, OutputStream genotypeStream, Collection<Object> argumentSources) {
        this.engine = engine;
        this.genotypeFile = null;
        this.genotypeStream = new PrintStream(genotypeStream);
        this.argumentSources = argumentSources;
    }

    @Override
    public File getOutputFile() {
        return this.genotypeFile;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.genotypeStream;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public void setCompressed(boolean compressed) {
        this.isCompressed = compressed;
    }

    public void setSkipWritingCommandLineHeader(boolean skipWritingCommandLineHeader) {
        this.skipWritingCommandLineHeader = skipWritingCommandLineHeader;
    }

    public void setDoNotWriteGenotypes(boolean doNotWriteGenotypes) {
        this.doNotWriteGenotypes = doNotWriteGenotypes;
    }

    public void setForceBCF(boolean forceBCF) {
        this.forceBCF = forceBCF;
    }

    public SAMSequenceDictionary getMasterSequenceDictionary() {
        return this.engine.getMasterSequenceDictionary();
    }

    public EnumSet<Options> getWriterOptions() {
        return this.getWriterOptions(false);
    }

    public EnumSet<Options> getWriterOptions(boolean indexOnTheFly) {
        ArrayList<Options> options = new ArrayList<Options>();
        if (this.doNotWriteGenotypes) {
            options.add(Options.DO_NOT_WRITE_GENOTYPES);
        }
        if (this.engine.lenientVCFProcessing()) {
            options.add(Options.ALLOW_MISSING_FIELDS_IN_HEADER);
        }
        if (indexOnTheFly && !this.isCompressed()) {
            options.add(Options.INDEX_ON_THE_FLY);
        }
        if (this.forceBCF || this.getOutputFile() != null && VariantContextWriterFactory.isBCFOutput(this.getOutputFile())) {
            options.add(Options.FORCE_BCF);
        }
        return options.isEmpty() ? EnumSet.noneOf(Options.class) : EnumSet.copyOf(options);
    }

    public VCFHeader getVCFHeader() {
        return this.vcfHeader;
    }

    @Override
    public void register(OutputTracker outputTracker) {
        this.outputTracker = outputTracker;
    }

    @Override
    public void writeHeader(VCFHeader header) {
        this.vcfHeader = header;
        if (header.isWriteEngineHeaders()) {
            if (!this.skipWritingCommandLineHeader && header.isWriteCommandLine()) {
                boolean foundCommandLineHeaderLine;
                VCFHeaderLine commandLineArgHeaderLine = this.getCommandLineArgumentHeaderLine();
                boolean bl = foundCommandLineHeaderLine = this.vcfHeader.getMetaDataLine(commandLineArgHeaderLine.getKey()) != null;
                if (!foundCommandLineHeaderLine) {
                    this.vcfHeader.addMetaDataLine(commandLineArgHeaderLine);
                }
            }
            this.vcfHeader = GATKVCFUtils.withUpdatedContigs(this.vcfHeader, this.engine);
        }
        this.outputTracker.getStorage(this).writeHeader(this.vcfHeader);
    }

    @Override
    public void add(VariantContext vc) {
        this.outputTracker.getStorage(this).add(vc);
    }

    @Override
    public void close() {
        this.outputTracker.getStorage(this).close();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public boolean alsoWriteBCFForTest() {
        return this.engine.getArguments().numberOfDataThreads == 1 && !this.isCompressed() && this.getOutputFile() != null && this.engine.getArguments().generateShadowBCF;
    }

    private VCFHeaderLine getCommandLineArgumentHeaderLine() {
        CommandLineExecutable executable = JVMUtils.getObjectOfType(this.argumentSources, CommandLineExecutable.class);
        return new VCFHeaderLine(executable.getAnalysisName(), "\"" + this.engine.createApproximateCommandLineArgumentString(this.argumentSources.toArray()) + "\"");
    }
}

