/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.phonehome;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.phonehome.GATKRunReportException;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.crypt.CryptUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.io.IOUtils;
import org.broadinstitute.sting.utils.io.Resource;
import org.broadinstitute.sting.utils.threading.ThreadEfficiencyMonitor;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.Mimetypes;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Persister;

public class GATKRunReport {
    protected static final String REPORT_BUCKET_NAME = "GATK_Run_Reports";
    protected static final String TEST_REPORT_BUCKET_NAME = "GATK_Run_Reports_Test";
    protected static final String AWS_ACCESS_KEY_MD5 = "43433e5488d60788042ed5de3dcf9b0a";
    protected static final String AWS_SECRET_KEY_MD5 = "0aa28b227ecacbdc9d2d5e8d82b10d32";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH.mm.ss");
    private static final long S3_PUT_TIME_OUT = 30000L;
    private static final File REPORT_DIR = new File("/humgen/gsa-hpprojects/GATK/reports");
    private static final File REPORT_SUBMIT_DIR = new File(REPORT_DIR.getAbsolutePath() + "/submitted");
    private static final File REPORT_SENTINEL = new File(REPORT_DIR.getAbsolutePath() + "/ENABLE");
    protected static final Logger logger = Logger.getLogger(GATKRunReport.class);
    @Element(required=false, name="id")
    private String id;
    @Element(required=false, name="exception")
    private GATKRunReportException mException;
    @Element(required=true, name="start-time")
    private String startTime = "ND";
    @Element(required=true, name="end-time")
    private String endTime;
    @Element(required=true, name="run-time")
    private long runTime = 0L;
    @Element(required=true, name="walker-name")
    private String walkerName;
    @Element(required=true, name="svn-version")
    private String svnVersion;
    @Element(required=true, name="total-memory")
    private long totalMemory;
    @Element(required=true, name="max-memory")
    private long maxMemory;
    @Element(required=true, name="user-name")
    private String userName;
    @Element(required=true, name="host-name")
    private String hostName;
    @Element(required=true, name="java")
    private String javaVersion;
    @Element(required=true, name="machine")
    private String machine;
    @Element(required=true, name="iterations")
    private long nIterations;
    @Element(required=true, name="tag")
    private String tag;
    @Element(required=true, name="num-threads")
    private int numThreads;
    @Element(required=true, name="percent-time-running")
    private String percentTimeRunning;
    @Element(required=true, name="percent-time-waiting")
    private String percentTimeWaiting;
    @Element(required=true, name="percent-time-blocking")
    private String percentTimeBlocking;
    @Element(required=true, name="percent-time-waiting-for-io")
    private String percentTimeWaitingForIO;
    public String errorMessage = null;
    public Throwable errorThrown = null;
    private AWSMode awsMode = AWSMode.NORMAL;
    private String s3ReportBucket = "GATK_Run_Reports";
    private boolean wentToAWS = false;

    private GATKRunReport() {
    }

    @Ensures(value={"result != null"})
    protected static GATKRunReport deserializeReport(InputStream stream) throws Exception {
        Persister serializer = new Persister();
        return (GATKRunReport)((Object)serializer.read(GATKRunReport.class, stream));
    }

    @Ensures(value={"result != null"})
    protected static GATKRunReport deserializeReport(String downloaderAccessKey, String downloaderSecretKey, String bucketName, S3Object s3Object) throws Exception {
        S3Service s3Service = GATKRunReport.initializeAWSService(downloaderAccessKey, downloaderSecretKey);
        S3Object objectComplete = s3Service.getObject(bucketName, s3Object.getName());
        return GATKRunReport.deserializeReport(new GZIPInputStream(objectComplete.getDataInputStream()));
    }

    public GATKRunReport(Walker<?, ?> walker, Exception e, GenomeAnalysisEngine engine, PhoneHomeOption type) {
        if (type == PhoneHomeOption.NO_ET) {
            throw new ReviewedStingException("Trying to create a run report when type is NO_ET!");
        }
        logger.debug("Aggregating data for run report");
        this.id = RandomStringUtils.randomAlphanumeric(32);
        this.walkerName = engine.getWalkerName(walker.getClass());
        this.svnVersion = CommandLineGATK.getVersionNumber();
        Date end = new Date();
        this.endTime = DATE_FORMAT.format(end);
        if (engine.getStartTime() != null) {
            this.startTime = DATE_FORMAT.format(engine.getStartTime());
            this.runTime = (end.getTime() - engine.getStartTime().getTime()) / 1000L;
        }
        Runtime.getRuntime().gc();
        this.maxMemory = Runtime.getRuntime().maxMemory();
        this.totalMemory = Runtime.getRuntime().totalMemory();
        if (engine.getCumulativeMetrics() != null) {
            this.nIterations = engine.getCumulativeMetrics().getNumIterations();
        }
        this.tag = engine.getArguments().tag;
        this.userName = System.getProperty("user.name");
        this.hostName = Utils.resolveHostname();
        this.javaVersion = Utils.join("-", Arrays.asList(System.getProperty("java.vendor"), System.getProperty("java.version")));
        this.machine = Utils.join("-", Arrays.asList(System.getProperty("os.name"), System.getProperty("os.arch")));
        this.mException = e == null ? null : new GATKRunReportException(e);
        this.numThreads = engine.getTotalNumberOfThreads();
        this.percentTimeRunning = this.getThreadEfficiencyPercent(engine, ThreadEfficiencyMonitor.State.USER_CPU);
        this.percentTimeBlocking = this.getThreadEfficiencyPercent(engine, ThreadEfficiencyMonitor.State.BLOCKING);
        this.percentTimeWaiting = this.getThreadEfficiencyPercent(engine, ThreadEfficiencyMonitor.State.WAITING);
        this.percentTimeWaitingForIO = this.getThreadEfficiencyPercent(engine, ThreadEfficiencyMonitor.State.WAITING_FOR_IO);
    }

    @Ensures(value={"result != null"})
    public String getID() {
        return this.id;
    }

    @Requires(value={"engine != null", "state != null"})
    @Ensures(value={"result != null"})
    private String getThreadEfficiencyPercent(GenomeAnalysisEngine engine, ThreadEfficiencyMonitor.State state) {
        ThreadEfficiencyMonitor tem = engine.getThreadEfficiencyMonitor();
        return tem == null ? "NA" : String.format("%.2f", tem.getStatePercent(state));
    }

    @Ensures(value={"result != null"})
    protected String getReportFileName() {
        return this.getID() + ".report.xml.gz";
    }

    public boolean postReport(PhoneHomeOption type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        logger.debug("Posting report of type " + (Object)((Object)type));
        switch (type) {
            case NO_ET: {
                return false;
            }
            case STANDARD: 
            case AWS: {
                if (type == PhoneHomeOption.STANDARD && this.repositoryIsOnline()) {
                    return this.postReportToLocalDisk(this.getLocalReportFullPath()) != null;
                }
                this.wentToAWS = true;
                return this.postReportToAWSS3() != null;
            }
            case STDOUT: {
                return this.postReportToStream(System.out);
            }
        }
        this.exceptDuringRunReport("BUG: unexpected PhoneHomeOption ");
        return false;
    }

    @Requires(value={"stream != null"})
    protected boolean postReportToStream(OutputStream stream) {
        Persister serializer = new Persister();
        try {
            serializer.write((Object)this, stream);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Ensures(value={"result != null"})
    protected File getLocalReportFullPath() {
        return new File(REPORT_SUBMIT_DIR, this.getReportFileName());
    }

    private boolean repositoryIsOnline() {
        return REPORT_SENTINEL.exists();
    }

    @Requires(value={"destination != null"})
    private File postReportToLocalDisk(File destination) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(destination)));
            this.postReportToStream(out);
            out.close();
            logger.debug("Wrote report to " + destination);
            return destination;
        }
        catch (Exception e) {
            this.exceptDuringRunReport("Couldn't read report file", e);
            destination.delete();
            return null;
        }
    }

    @Ensures(value={"result != null"})
    protected String getS3ReportBucket() {
        return this.s3ReportBucket;
    }

    @Ensures(value={"result != null"})
    public static String decryptAWSKey(File encryptedKeySource) throws FileNotFoundException {
        if (encryptedKeySource == null) {
            throw new IllegalArgumentException("encryptedKeySource cannot be null");
        }
        return GATKRunReport.decryptAWSKey(new FileInputStream(encryptedKeySource));
    }

    @Requires(value={"encryptedKeySource != null"})
    @Ensures(value={"result != null"})
    private static String decryptAWSKey(InputStream encryptedKeySource) {
        PublicKey key = CryptUtils.loadGATKDistributedPublicKey();
        byte[] fromDisk = IOUtils.readStreamIntoByteArray(encryptedKeySource);
        byte[] decrypted = CryptUtils.decryptData(fromDisk, key);
        return new String(decrypted);
    }

    @Requires(value={"name != null"})
    @Ensures(value={"result != null"})
    private static String getAWSKey(String name) {
        Resource resource = new Resource(name, GATKRunReport.class);
        return GATKRunReport.decryptAWSKey(resource.getResourceContentsAsStream());
    }

    @Ensures(value={"result != null"})
    protected static String getAWSUploadAccessKey() {
        return GATKRunReport.getAWSKey("resources/GATK_AWS_access.key");
    }

    @Ensures(value={"result != null"})
    protected static String getAWSUploadSecretKey() {
        return GATKRunReport.getAWSKey("resources/GATK_AWS_secret.key");
    }

    public static void checkAWSAreValid() {
        try {
            String accessKeyMD5 = Utils.calcMD5(GATKRunReport.getAWSUploadAccessKey());
            String secretKeyMD5 = Utils.calcMD5(GATKRunReport.getAWSUploadSecretKey());
            if (!AWS_ACCESS_KEY_MD5.equals(accessKeyMD5)) {
                throw new ReviewedStingException("Invalid AWS access key found, expected MD5 43433e5488d60788042ed5de3dcf9b0a but got " + accessKeyMD5);
            }
            if (!AWS_SECRET_KEY_MD5.equals(secretKeyMD5)) {
                throw new ReviewedStingException("Invalid AWS secret key found, expected MD5 0aa28b227ecacbdc9d2d5e8d82b10d32 but got " + secretKeyMD5);
            }
        }
        catch (Exception e) {
            throw new ReviewedStingException("Couldn't decrypt AWS keys, something is wrong with the GATK distribution");
        }
    }

    @Requires(value={"awsAccessKey != null", "awsSecretKey != null"})
    @Ensures(value={"result != null"})
    protected static S3Service initializeAWSService(String awsAccessKey, String awsSecretKey) throws S3ServiceException {
        AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
        return new RestS3Service(awsCredentials);
    }

    protected S3Object postReportToAWSS3() {
        this.hostName = Utils.resolveHostname();
        String key = this.getReportFileName();
        logger.debug("Generating GATK report to AWS S3 with key " + key);
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(8096);
            GZIPOutputStream outputStream = new GZIPOutputStream(byteStream);
            this.postReportToStream(outputStream);
            ((OutputStream)outputStream).close();
            byte[] report = byteStream.toByteArray();
            Logger mimeTypeLogger = Logger.getLogger(Mimetypes.class);
            mimeTypeLogger.setLevel(Level.FATAL);
            S3PutRunnable s3run = new S3PutRunnable(key, report);
            Thread s3thread = new Thread(s3run);
            s3thread.setDaemon(true);
            s3thread.setName("S3Put-Thread");
            s3thread.start();
            s3thread.join(30000L);
            if (s3thread.isAlive()) {
                s3thread.interrupt();
                this.exceptDuringRunReport("Run statistics report upload to AWS S3 timed-out");
            } else if (s3run.isSuccess.get()) {
                logger.info("Uploaded run statistics report to AWS S3");
                logger.debug("Uploaded to AWS: " + s3run.s3Object);
                return s3run.s3Object;
            }
        }
        catch (IOException e) {
            this.exceptDuringRunReport("Couldn't read report file", e);
        }
        catch (InterruptedException e) {
            this.exceptDuringRunReport("Run statistics report upload interrupted", e);
        }
        return null;
    }

    @Ensures(value={"exceptionOccurredDuringPost()"})
    private void exceptDuringRunReport(String msg, Throwable e) {
        this.errorMessage = msg;
        this.errorThrown = e;
        logger.debug("A problem occurred during GATK run reporting [*** everything is fine, but no report could be generated; please do not post this to the support forum ***].  Message is: " + msg + ".  Error message is: " + e.getMessage());
    }

    @Ensures(value={"exceptionOccurredDuringPost()"})
    private void exceptDuringRunReport(String msg) {
        this.errorMessage = msg;
        logger.debug("A problem occurred during GATK run reporting [*** everything is fine, but no report could be generated; please do not post this to the support forum ***].  Message is " + msg);
    }

    public boolean exceptionOccurredDuringPost() {
        return this.getErrorMessage() != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Throwable getErrorThrown() {
        return this.errorThrown;
    }

    @Ensures(value={"result != null"})
    protected String formatError() {
        return this.exceptionOccurredDuringPost() ? String.format("Exception message=%s with cause=%s", this.getErrorMessage(), this.getErrorThrown()) : "No exception occurred";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GATKRunReport that = (GATKRunReport)o;
        if (this.maxMemory != that.maxMemory) {
            return false;
        }
        if (this.nIterations != that.nIterations) {
            return false;
        }
        if (this.numThreads != that.numThreads) {
            return false;
        }
        if (this.runTime != that.runTime) {
            return false;
        }
        if (this.totalMemory != that.totalMemory) {
            return false;
        }
        if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) {
            return false;
        }
        if (this.hostName != null ? !this.hostName.equals(that.hostName) : that.hostName != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.javaVersion != null ? !this.javaVersion.equals(that.javaVersion) : that.javaVersion != null) {
            return false;
        }
        if (this.mException != null ? !this.mException.equals(that.mException) : that.mException != null) {
            return false;
        }
        if (this.machine != null ? !this.machine.equals(that.machine) : that.machine != null) {
            return false;
        }
        if (this.percentTimeBlocking != null ? !this.percentTimeBlocking.equals(that.percentTimeBlocking) : that.percentTimeBlocking != null) {
            return false;
        }
        if (this.percentTimeRunning != null ? !this.percentTimeRunning.equals(that.percentTimeRunning) : that.percentTimeRunning != null) {
            return false;
        }
        if (this.percentTimeWaiting != null ? !this.percentTimeWaiting.equals(that.percentTimeWaiting) : that.percentTimeWaiting != null) {
            return false;
        }
        if (this.percentTimeWaitingForIO != null ? !this.percentTimeWaitingForIO.equals(that.percentTimeWaitingForIO) : that.percentTimeWaitingForIO != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        if (this.svnVersion != null ? !this.svnVersion.equals(that.svnVersion) : that.svnVersion != null) {
            return false;
        }
        if (this.tag != null ? !this.tag.equals(that.tag) : that.tag != null) {
            return false;
        }
        if (this.userName != null ? !this.userName.equals(that.userName) : that.userName != null) {
            return false;
        }
        return !(this.walkerName != null ? !this.walkerName.equals(that.walkerName) : that.walkerName != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.mException != null ? this.mException.hashCode() : 0);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        result = 31 * result + (int)(this.runTime ^ this.runTime >>> 32);
        result = 31 * result + (this.walkerName != null ? this.walkerName.hashCode() : 0);
        result = 31 * result + (this.svnVersion != null ? this.svnVersion.hashCode() : 0);
        result = 31 * result + (int)(this.totalMemory ^ this.totalMemory >>> 32);
        result = 31 * result + (int)(this.maxMemory ^ this.maxMemory >>> 32);
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
        result = 31 * result + (this.javaVersion != null ? this.javaVersion.hashCode() : 0);
        result = 31 * result + (this.machine != null ? this.machine.hashCode() : 0);
        result = 31 * result + (int)(this.nIterations ^ this.nIterations >>> 32);
        result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
        result = 31 * result + this.numThreads;
        result = 31 * result + (this.percentTimeRunning != null ? this.percentTimeRunning.hashCode() : 0);
        result = 31 * result + (this.percentTimeWaiting != null ? this.percentTimeWaiting.hashCode() : 0);
        result = 31 * result + (this.percentTimeBlocking != null ? this.percentTimeBlocking.hashCode() : 0);
        result = 31 * result + (this.percentTimeWaitingForIO != null ? this.percentTimeWaitingForIO.hashCode() : 0);
        return result;
    }

    protected void sendAWSToTestBucket() {
        this.s3ReportBucket = TEST_REPORT_BUCKET_NAME;
    }

    protected boolean wentToAWS() {
        return this.wentToAWS;
    }

    @Requires(value={"mode != null"})
    protected void setAwsMode(AWSMode mode) {
        this.awsMode = mode;
    }

    protected static enum AWSMode {
        NORMAL,
        FAIL_WITH_EXCEPTION,
        TIMEOUT;

    }

    private class S3PutRunnable
    implements Runnable {
        public final AtomicBoolean isSuccess = new AtomicBoolean();
        private final String filename;
        private final byte[] contents;
        public S3Object s3Object = null;

        @Requires(value={"filename != null", "contents != null"})
        public S3PutRunnable(String filename, byte[] contents) {
            this.filename = filename;
            this.contents = contents;
        }

        @Override
        public void run() {
            try {
                switch (GATKRunReport.this.awsMode) {
                    case FAIL_WITH_EXCEPTION: {
                        throw new IllegalStateException("We are throwing an exception for testing purposes");
                    }
                    case TIMEOUT: {
                        try {
                            Thread.sleep(3000000L);
                        }
                        catch (InterruptedException e) {}
                        break;
                    }
                    case NORMAL: {
                        S3Service s3Service = GATKRunReport.initializeAWSService(GATKRunReport.getAWSUploadAccessKey(), GATKRunReport.getAWSUploadSecretKey());
                        S3Object fileObject = new S3Object(this.filename, this.contents);
                        this.s3Object = s3Service.putObject(GATKRunReport.this.getS3ReportBucket(), fileObject);
                        this.isSuccess.set(true);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected AWS exception");
                    }
                }
            }
            catch (S3ServiceException e) {
                GATKRunReport.this.exceptDuringRunReport("S3 exception occurred", e);
            }
            catch (NoSuchAlgorithmException e) {
                GATKRunReport.this.exceptDuringRunReport("Couldn't calculate MD5", e);
            }
            catch (IOException e) {
                GATKRunReport.this.exceptDuringRunReport("Couldn't read report file", e);
            }
            catch (Exception e) {
                GATKRunReport.this.exceptDuringRunReport("An unexpected exception occurred during posting", e);
            }
        }
    }

    public static enum PhoneHomeOption {
        NO_ET,
        STANDARD,
        AWS,
        STDOUT;

    }
}

