/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.phonehome;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

class GATKRunReportException {
    @Element(required=false, name="message")
    String message = null;
    @ElementList(required=false, name="stacktrace")
    final List<String> stackTrace = new ArrayList<String>();
    @Element(required=false, name="cause")
    GATKRunReportException cause = null;
    @Element(required=false, name="is-user-exception")
    Boolean isUserException;
    @Element(required=false, name="exception-class")
    Class exceptionClass;

    public GATKRunReportException() {
    }

    public GATKRunReportException(Throwable e) {
        this.message = e.getMessage();
        this.exceptionClass = e.getClass();
        this.isUserException = e instanceof UserException;
        for (StackTraceElement element : e.getStackTrace()) {
            this.stackTrace.add(element.toString());
        }
        if (e.getCause() != null) {
            this.cause = new GATKRunReportException(e.getCause());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GATKRunReportException that = (GATKRunReportException)o;
        if (this.cause != null ? !this.cause.equals(that.cause) : that.cause != null) {
            return false;
        }
        if (this.exceptionClass != null ? !this.exceptionClass.equals(that.exceptionClass) : that.exceptionClass != null) {
            return false;
        }
        if (this.isUserException != null ? !this.isUserException.equals(that.isUserException) : that.isUserException != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return !(this.stackTrace != null ? !((Object)this.stackTrace).equals(that.stackTrace) : that.stackTrace != null);
    }

    public int hashCode() {
        int result = this.message != null ? this.message.hashCode() : 0;
        result = 31 * result + (this.stackTrace != null ? ((Object)this.stackTrace).hashCode() : 0);
        result = 31 * result + (this.cause != null ? this.cause.hashCode() : 0);
        result = 31 * result + (this.isUserException != null ? this.isUserException.hashCode() : 0);
        result = 31 * result + (this.exceptionClass != null ? this.exceptionClass.hashCode() : 0);
        return result;
    }
}

