/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.refdata;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.refdata.RODRecordListImpl;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class RefMetaDataTracker {
    private static final RODRecordList EMPTY_ROD_RECORD_LIST = new RODRecordListImpl("EMPTY");
    final Map<String, RODRecordList> bindings;
    protected static final Logger logger = Logger.getLogger(RefMetaDataTracker.class);
    public static final RefMetaDataTracker EMPTY_TRACKER = new RefMetaDataTracker();

    public RefMetaDataTracker() {
        this.bindings = Collections.emptyMap();
    }

    public RefMetaDataTracker(Collection<RODRecordList> allBindings) {
        if (allBindings.isEmpty()) {
            this.bindings = Collections.emptyMap();
        } else {
            HashMap<String, RODRecordList> tmap = new HashMap<String, RODRecordList>(allBindings.size());
            for (RODRecordList rod : allBindings) {
                if (rod == null || rod.isEmpty()) continue;
                tmap.put(this.canonicalName(rod.getName()), rod);
            }
            this.bindings = Collections.unmodifiableMap(tmap);
        }
    }

    @Requires(value={"type != null"})
    @Ensures(value={"result != null"})
    public <T extends Feature> List<T> getValues(Class<T> type) {
        return this.addValues(this.bindings.keySet(), type, new ArrayList(), null, false, false);
    }

    @Requires(value={"type != null", "onlyAtThisLoc != null"})
    @Ensures(value={"result != null"})
    public <T extends Feature> List<T> getValues(Class<T> type, GenomeLoc onlyAtThisLoc) {
        return this.addValues(this.bindings.keySet(), type, new ArrayList(), onlyAtThisLoc, true, false);
    }

    @Requires(value={"type != null"})
    public <T extends Feature> T getFirstValue(Class<T> type) {
        return this.safeGetFirst(this.getValues(type));
    }

    @Requires(value={"type != null", "onlyAtThisLoc != null"})
    public <T extends Feature> T getFirstValue(Class<T> type, GenomeLoc onlyAtThisLoc) {
        return this.safeGetFirst(this.getValues(type, onlyAtThisLoc));
    }

    @Requires(value={"rodBinding != null"})
    @Ensures(value={"result != null"})
    public <T extends Feature> List<T> getValues(RodBinding<T> rodBinding) {
        return this.addValues(rodBinding.getName(), rodBinding.getType(), new ArrayList(1), this.getTrackDataByName(rodBinding), null, false, false);
    }

    @Requires(value={"rodBindings != null"})
    @Ensures(value={"result != null"})
    public <T extends Feature> List<T> getValues(Collection<RodBinding<T>> rodBindings) {
        ArrayList<T> results = new ArrayList<T>(1);
        for (RodBinding<T> rodBinding : rodBindings) {
            results.addAll(this.getValues(rodBinding));
        }
        return results;
    }

    @Requires(value={"rodBinding != null", "onlyAtThisLoc != null"})
    @Ensures(value={"result != null"})
    public <T extends Feature> List<T> getValues(RodBinding<T> rodBinding, GenomeLoc onlyAtThisLoc) {
        return this.addValues(rodBinding.getName(), rodBinding.getType(), new ArrayList(1), this.getTrackDataByName(rodBinding), onlyAtThisLoc, true, false);
    }

    @Requires(value={"rodBindings != null", "onlyAtThisLoc != null"})
    @Ensures(value={"result != null"})
    public <T extends Feature> List<T> getValues(Collection<RodBinding<T>> rodBindings, GenomeLoc onlyAtThisLoc) {
        ArrayList<T> results = new ArrayList<T>(1);
        for (RodBinding<T> rodBinding : rodBindings) {
            results.addAll(this.getValues(rodBinding, onlyAtThisLoc));
        }
        return results;
    }

    @Requires(value={"rodBinding != null"})
    public <T extends Feature> T getFirstValue(RodBinding<T> rodBinding) {
        return this.safeGetFirst(this.addValues(rodBinding.getName(), rodBinding.getType(), null, this.getTrackDataByName(rodBinding), null, false, true));
    }

    @Requires(value={"rodBinding != null", "onlyAtThisLoc != null"})
    public <T extends Feature> T getFirstValue(RodBinding<T> rodBinding, GenomeLoc onlyAtThisLoc) {
        return this.safeGetFirst(this.addValues(rodBinding.getName(), rodBinding.getType(), null, this.getTrackDataByName(rodBinding), onlyAtThisLoc, true, true));
    }

    @Requires(value={"rodBindings != null"})
    public <T extends Feature> T getFirstValue(Collection<RodBinding<T>> rodBindings) {
        for (RodBinding<T> rodBinding : rodBindings) {
            T val = this.getFirstValue(rodBinding);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Requires(value={"rodBindings != null", "onlyAtThisLoc != null"})
    public <T extends Feature> T getFirstValue(Collection<RodBinding<T>> rodBindings, GenomeLoc onlyAtThisLoc) {
        for (RodBinding<T> rodBinding : rodBindings) {
            T val = this.getFirstValue(rodBinding, onlyAtThisLoc);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Requires(value={"rodBinding != null"})
    public boolean hasValues(RodBinding rodBinding) {
        return this.bindings.containsKey(this.canonicalName(rodBinding.getName()));
    }

    public List<RODRecordList> getBoundRodTracks() {
        return new ArrayList<RODRecordList>(this.bindings.values());
    }

    public int getNTracksWithBoundFeatures() {
        return this.bindings.size();
    }

    protected boolean hasValues(String name) {
        return this.bindings.containsKey(this.canonicalName(name));
    }

    protected <T extends Feature> List<T> getValues(Class<T> type, String name) {
        return this.addValues(name, type, new ArrayList(), this.getTrackDataByName(name), null, false, false);
    }

    protected <T extends Feature> List<T> getValues(Class<T> type, String name, GenomeLoc onlyAtThisLoc) {
        return this.addValues(name, type, new ArrayList(), this.getTrackDataByName(name), onlyAtThisLoc, true, false);
    }

    protected <T extends Feature> T getFirstValue(Class<T> type, String name) {
        return this.safeGetFirst(this.getValues(type, name));
    }

    protected <T extends Feature> T getFirstValue(Class<T> type, String name, GenomeLoc onlyAtThisLoc) {
        return this.safeGetFirst(this.getValues(type, name, onlyAtThisLoc));
    }

    @Requires(value={"l != null"})
    private <T extends Feature> T safeGetFirst(List<T> l) {
        return (T)(l.isEmpty() ? null : (Feature)l.get(0));
    }

    private <T extends Feature> List<T> addValues(Collection<String> names, Class<T> type, List<T> values, GenomeLoc curLocation, boolean requireStartHere, boolean takeFirstOnly) {
        for (String name : names) {
            RODRecordList rodList = this.getTrackDataByName(name);
            values = this.addValues(name, type, values, rodList, curLocation, requireStartHere, takeFirstOnly);
            if (!takeFirstOnly || values.isEmpty()) continue;
            break;
        }
        return values;
    }

    private <T extends Feature> List<T> addValues(String name, Class<T> type, List<T> values, RODRecordList rodList, GenomeLoc curLocation, boolean requireStartHere, boolean takeFirstOnly) {
        for (GATKFeature rec : rodList) {
            if (requireStartHere && rec.getLocation().getStart() != curLocation.getStart()) continue;
            Object obj = rec.getUnderlyingObject();
            if (!type.isAssignableFrom(obj.getClass())) {
                throw new UserException.CommandLineException("Unable to cast track named " + name + " to type of " + type.toString() + " it's of type " + obj.getClass());
            }
            Feature objT = (Feature)obj;
            if (takeFirstOnly) {
                if (values == null) {
                    values = Arrays.asList(objT);
                    break;
                }
                values.add(objT);
                break;
            }
            if (values == null) {
                values = new ArrayList<T>();
            }
            values.add(objT);
        }
        return values == null ? Collections.emptyList() : values;
    }

    private RODRecordList getTrackDataByName(String name) {
        String luName = this.canonicalName(name);
        RODRecordList l = this.bindings.get(luName);
        return l == null ? EMPTY_ROD_RECORD_LIST : l;
    }

    private RODRecordList getTrackDataByName(RodBinding binding) {
        return this.getTrackDataByName(binding.getName());
    }

    private String canonicalName(String name) {
        return name.toLowerCase();
    }
}

