/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.refdata.tracks;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.NameAwareCodec;
import org.broadinstitute.sting.gatk.refdata.ReferenceDependentFeatureCodec;
import org.broadinstitute.sting.gatk.refdata.utils.RMDTriplet;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.help.GATKDocUtils;
import org.broadinstitute.variant.vcf.AbstractVCFCodec;

public class FeatureManager {
    private final PluginManager<FeatureCodec> pluginManager;
    private final Collection<FeatureDescriptor> featureDescriptors = new TreeSet<FeatureDescriptor>();
    private final boolean lenientVCFProcessing;

    public FeatureManager() {
        this(false);
    }

    public FeatureManager(boolean lenientVCFProcessing) {
        this.lenientVCFProcessing = lenientVCFProcessing;
        this.pluginManager = new PluginManager(FeatureCodec.class, "Codecs", "Codec");
        for (String rawName : this.pluginManager.getPluginsByName().keySet()) {
            FeatureCodec codec = this.pluginManager.createByName(rawName);
            String name = rawName.toUpperCase();
            FeatureDescriptor featureDescriptor = new FeatureDescriptor(name, codec);
            this.featureDescriptors.add(featureDescriptor);
        }
    }

    @Requires(value={"codecClass != null"})
    public FeatureDescriptor getByCodec(Class codecClass) {
        for (FeatureDescriptor descriptor : this.featureDescriptors) {
            if (!descriptor.getCodecClass().equals(codecClass)) continue;
            return descriptor;
        }
        return null;
    }

    @Requires(value={"featureClass != null"})
    public <T extends Feature> Collection<FeatureDescriptor> getByFeature(Class<T> featureClass) {
        TreeSet<FeatureDescriptor> consistentDescriptors = new TreeSet<FeatureDescriptor>();
        if (featureClass == null) {
            throw new IllegalArgumentException("trackRecordType value is null, please pass in an actual class object");
        }
        for (FeatureDescriptor descriptor : this.featureDescriptors) {
            if (!featureClass.isAssignableFrom(descriptor.getFeatureClass())) continue;
            consistentDescriptors.add(descriptor);
        }
        return consistentDescriptors;
    }

    @Requires(value={"name != null"})
    public FeatureDescriptor getByName(String name) {
        for (FeatureDescriptor descriptor : this.featureDescriptors) {
            if (!descriptor.getName().equalsIgnoreCase(name)) continue;
            return descriptor;
        }
        return null;
    }

    @Requires(value={"file != null", "file.isFile()", "file.canRead()"})
    public FeatureDescriptor getByFiletype(File file) {
        ArrayList<FeatureDescriptor> canParse = new ArrayList<FeatureDescriptor>();
        for (FeatureDescriptor descriptor : this.featureDescriptors) {
            if (!descriptor.getCodec().canDecode(file.getPath())) continue;
            canParse.add(descriptor);
        }
        if (canParse.size() == 0) {
            return null;
        }
        if (canParse.size() > 1) {
            throw new ReviewedStingException("BUG: multiple feature descriptors can read file " + file + ": " + canParse);
        }
        return (FeatureDescriptor)canParse.get(0);
    }

    @Requires(value={"triplet != null"})
    public FeatureDescriptor getByTriplet(RMDTriplet triplet) {
        return this.getByName(triplet.getType());
    }

    @Ensures(value={"result != null"})
    public Collection<FeatureDescriptor> getFeatureDescriptors() {
        return Collections.unmodifiableCollection(this.featureDescriptors);
    }

    @Ensures(value={"result != null"})
    public String userFriendlyListOfAvailableFeatures() {
        return this.userFriendlyListOfAvailableFeatures(Feature.class);
    }

    @Ensures(value={"result != null"})
    public String userFriendlyListOfAvailableFeatures(Class<? extends Feature> requiredFeatureType) {
        String nameHeader = "Name";
        String featureHeader = "FeatureType";
        String docHeader = "Documentation";
        int maxNameLen = "Name".length();
        int maxFeatureNameLen = "FeatureType".length();
        for (FeatureDescriptor descriptor : this.featureDescriptors) {
            if (!requiredFeatureType.isAssignableFrom(descriptor.getFeatureClass())) continue;
            maxNameLen = Math.max(maxNameLen, descriptor.getName().length());
            maxFeatureNameLen = Math.max(maxFeatureNameLen, descriptor.getSimpleFeatureName().length());
        }
        StringBuilder docs = new StringBuilder();
        String format = "%" + maxNameLen + "s   %" + maxFeatureNameLen + "s   %s%n";
        docs.append(String.format(format, "Name", "FeatureType", "Documentation"));
        for (FeatureDescriptor descriptor : this.featureDescriptors) {
            if (!requiredFeatureType.isAssignableFrom(descriptor.getFeatureClass())) continue;
            String oneDoc = String.format(format, descriptor.getName(), descriptor.getSimpleFeatureName(), GATKDocUtils.helpLinksToGATKDocs(descriptor.getCodecClass()));
            docs.append(oneDoc);
        }
        return docs.toString();
    }

    @Requires(value={"descriptor != null", "name != null", "genomeLocParser != null"})
    @Ensures(value={"result != null"})
    public FeatureCodec createCodec(FeatureDescriptor descriptor, String name, GenomeLocParser genomeLocParser) {
        FeatureCodec codex = this.pluginManager.createByType(descriptor.getCodecClass());
        if (codex instanceof NameAwareCodec) {
            ((NameAwareCodec)((Object)codex)).setName(name);
        }
        if (codex instanceof ReferenceDependentFeatureCodec) {
            ((ReferenceDependentFeatureCodec)((Object)codex)).setGenomeLocParser(genomeLocParser);
        }
        if (codex instanceof AbstractVCFCodec && this.lenientVCFProcessing) {
            ((AbstractVCFCodec)codex).disableOnTheFlyModifications();
        }
        return codex;
    }

    public static class FeatureDescriptor
    implements Comparable<FeatureDescriptor> {
        final String name;
        final FeatureCodec codec;

        public FeatureDescriptor(String name, FeatureCodec codec) {
            this.name = name;
            this.codec = codec;
        }

        public String getName() {
            return this.name;
        }

        public String getSimpleFeatureName() {
            return this.getFeatureClass().getSimpleName();
        }

        public FeatureCodec getCodec() {
            return this.codec;
        }

        public Class getCodecClass() {
            return this.codec.getClass();
        }

        public Class getFeatureClass() {
            return this.codec.getFeatureType();
        }

        public String toString() {
            return String.format("FeatureDescriptor name=%s codec=%s feature=%s", this.getName(), this.getCodecClass().getName(), this.getFeatureClass().getName());
        }

        @Override
        public int compareTo(FeatureDescriptor o) {
            return this.getName().compareTo(o.getName());
        }
    }
}

