/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.ReadMetrics;
import org.broadinstitute.sting.gatk.datasources.providers.ShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.progressmeter.ProgressMeter;

public abstract class TraversalEngine<M, T, WalkerType extends Walker<M, T>, ProviderType extends ShardDataProvider> {
    protected static final Logger logger = Logger.getLogger(TraversalEngine.class);
    protected GenomeAnalysisEngine engine;
    private ProgressMeter progressMeter;

    public abstract String getTraversalUnits();

    public abstract T traverse(WalkerType var1, ProviderType var2, T var3);

    public void initialize(GenomeAnalysisEngine engine, Walker walker, ProgressMeter progressMeter) {
        if (engine == null) {
            throw new ReviewedStingException("BUG: GenomeAnalysisEngine cannot be null!");
        }
        this.engine = engine;
        this.progressMeter = progressMeter;
    }

    protected void initialize(GenomeAnalysisEngine engine, Walker walker) {
        this.initialize(engine, walker, null);
    }

    public void shutdown() {
    }

    public void updateCumulativeMetrics(Shard shard) {
        this.updateCumulativeMetrics(shard.getReadMetrics());
    }

    public void updateCumulativeMetrics(ReadMetrics singleTraverseMetrics) {
        this.engine.getCumulativeMetrics().incrementMetrics(singleTraverseMetrics);
    }

    public void printProgress(GenomeLoc loc) {
        if (this.progressMeter != null) {
            this.progressMeter.notifyOfProgress(loc, this.engine.getCumulativeMetrics().getNumIterations());
        }
    }
}

