/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.AllLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusReferenceView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.LocusView;
import org.broadinstitute.sting.gatk.datasources.providers.ManagingReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.RodLocusView;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionTraversalParameters;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionWalker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.activeregion.ActiveRegion;
import org.broadinstitute.sting.utils.activeregion.ActivityProfile;
import org.broadinstitute.sting.utils.activeregion.ActivityProfileState;
import org.broadinstitute.sting.utils.activeregion.BandPassActivityProfile;
import org.broadinstitute.sting.utils.progressmeter.ProgressMeter;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class TraverseActiveRegions<M, T>
extends TraversalEngine<M, T, ActiveRegionWalker<M, T>, LocusShardDataProvider> {
    protected static final Logger logger = Logger.getLogger(TraversalEngine.class);
    protected static final boolean LOG_READ_CARRYING = false;
    private boolean walkerHasPresetRegions = false;
    private int activeRegionExtension = -1;
    private int maxRegionSize = -1;
    private int minRegionSize = -1;
    private final LinkedList<ActiveRegion> workQueue = new LinkedList();
    private LinkedList<GATKSAMRecord> myReads = new LinkedList();
    private GenomeLoc spanOfLastReadSeen = null;
    private ActivityProfile activityProfile = null;
    int maxReadsInMemory = 0;
    ActiveRegionWalker walker;
    private boolean streamsInitialized = false;

    @Override
    public void initialize(GenomeAnalysisEngine engine, Walker walker, ProgressMeter progressMeter) {
        super.initialize(engine, walker, progressMeter);
        this.walker = (ActiveRegionWalker)walker;
        if (this.walker.wantsExtendedReads() && !this.walker.wantsNonPrimaryReads()) {
            throw new IllegalArgumentException("Active region walker " + this.walker + " requested extended events but not " + "non-primary reads, an inconsistent state.  Please modify the walker");
        }
        ActiveRegionTraversalParameters annotation = walker.getClass().getAnnotation(ActiveRegionTraversalParameters.class);
        this.activeRegionExtension = this.walker.activeRegionExtension == null ? annotation.extension() : this.walker.activeRegionExtension.intValue();
        this.maxRegionSize = this.walker.activeRegionMaxSize == null ? annotation.maxRegion() : this.walker.activeRegionMaxSize.intValue();
        this.minRegionSize = annotation.minRegion();
        double bandPassSigma = this.walker.bandPassSigma == null ? annotation.bandPassSigma() : this.walker.bandPassSigma.doubleValue();
        this.walkerHasPresetRegions = this.walker.hasPresetActiveRegions();
        this.activityProfile = new BandPassActivityProfile(engine.getGenomeLocParser(), engine.getIntervals(), 50, bandPassSigma);
        if (this.walkerHasPresetRegions) {
            for (GenomeLoc loc : this.walker.getPresetActiveRegions()) {
                this.workQueue.add(new ActiveRegion(loc, null, true, engine.getGenomeLocParser(), this.getActiveRegionExtension()));
            }
        }
    }

    protected int getActiveRegionExtension() {
        return this.activeRegionExtension;
    }

    protected int getMaxRegionSize() {
        return this.maxRegionSize;
    }

    protected int getMinRegionSize() {
        return this.minRegionSize;
    }

    @Override
    public String getTraversalUnits() {
        return "active regions";
    }

    public String toString() {
        return "TraverseActiveRegions";
    }

    protected boolean outsideEngineIntervals(GenomeLoc loc) {
        return this.engine.getIntervals() != null && !this.engine.getIntervals().overlaps(loc);
    }

    protected ReferenceOrderedView getReferenceOrderedView(ActiveRegionWalker<M, T> walker, LocusShardDataProvider dataProvider, LocusView locusView) {
        if (WalkerManager.getWalkerDataSource(walker) != DataSource.REFERENCE_ORDERED_DATA) {
            return new ManagingReferenceOrderedView(dataProvider);
        }
        return (RodLocusView)locusView;
    }

    private boolean appearedInLastShard(GenomeLoc locOfLastReadAtTraversalStart, GATKSAMRecord read) {
        if (locOfLastReadAtTraversalStart == null) {
            return false;
        }
        return read.getAlignmentStart() <= locOfLastReadAtTraversalStart.getStart() && read.getReferenceIndex().intValue() == locOfLastReadAtTraversalStart.getContigIndex();
    }

    @Override
    public T traverse(ActiveRegionWalker<M, T> walker, LocusShardDataProvider dataProvider, T sum) {
        if (logger.isDebugEnabled()) {
            logger.info(String.format("TraverseActiveRegions.traverse: Shard is %s", dataProvider));
        }
        AllLocusView locusView = new AllLocusView(dataProvider);
        LocusReferenceView referenceView = new LocusReferenceView(walker, dataProvider);
        ReferenceOrderedView referenceOrderedDataView = this.getReferenceOrderedView(walker, dataProvider, locusView);
        GenomeLoc locOfLastReadAtTraversalStart = this.spanOfLastSeenRead();
        while (((LocusView)locusView).hasNext()) {
            AlignmentContext locus = ((LocusView)locusView).next();
            GenomeLoc location = locus.getLocation();
            this.rememberLastLocusLocation(location);
            List<GATKSAMRecord> reads = locusView.getLIBS().transferReadsFromAllPreviousPileups();
            for (GATKSAMRecord read : reads) {
                if (this.appearedInLastShard(locOfLastReadAtTraversalStart, read)) continue;
                this.rememberLastReadLocation(read);
                this.myReads.add(read);
            }
            if (this.outsideEngineIntervals(location)) continue;
            boolean flushProfile = !this.activityProfile.isEmpty() && (this.activityProfile.getContigIndex() != location.getContigIndex() || location.getStart() != this.activityProfile.getStop() + 1);
            sum = this.processActiveRegions(walker, sum, flushProfile, false);
            dataProvider.getShard().getReadMetrics().incrementNumIterations();
            ReferenceContext refContext = referenceView.getReferenceContext(location);
            RefMetaDataTracker tracker = referenceOrderedDataView.getReferenceOrderedDataAtLocus(locus.getLocation(), refContext);
            this.addIsActiveResult(walker, tracker, refContext, locus);
            this.maxReadsInMemory = Math.max(this.myReads.size(), this.maxReadsInMemory);
            this.printProgress(locus.getLocation());
        }
        this.updateCumulativeMetrics(dataProvider.getShard());
        return sum;
    }

    public T endTraversal(Walker<M, T> walker, T sum) {
        return this.processActiveRegions((ActiveRegionWalker)walker, sum, true, true);
    }

    protected void rememberLastReadLocation(GATKSAMRecord read) {
        GenomeLoc currentLocation = this.engine.getGenomeLocParser().createGenomeLoc(read);
        if (this.spanOfLastReadSeen == null) {
            this.spanOfLastReadSeen = currentLocation;
        } else {
            if (currentLocation.isBefore(this.spanOfLastReadSeen)) {
                throw new IllegalStateException("Updating last read seen in the traversal with read " + read + " with span " + currentLocation + " but this occurs before the previously seen read " + this.spanOfLastReadSeen);
            }
            this.spanOfLastReadSeen = currentLocation;
        }
    }

    protected void rememberLastLocusLocation(GenomeLoc currentLocation) {
        if (this.spanOfLastReadSeen == null) {
            this.spanOfLastReadSeen = currentLocation;
        } else if (currentLocation.isPast(this.spanOfLastReadSeen)) {
            this.spanOfLastReadSeen = currentLocation;
        }
    }

    protected GenomeLoc spanOfLastSeenRead() {
        return this.spanOfLastReadSeen;
    }

    protected boolean regionCompletelyWithinDeadZone(ActiveRegion region) {
        if (this.spanOfLastSeenRead() == null) {
            return false;
        }
        int contigCmp = region.getExtendedLoc().compareContigs(this.spanOfLastSeenRead());
        if (contigCmp > 0) {
            throw new IllegalStateException("Active region " + region + " on a contig after last seen read " + this.spanOfLastSeenRead());
        }
        return contigCmp < 0 || region.getExtendedLoc().getStop() < this.spanOfLastSeenRead().getStart();
    }

    @Requires(value={"read != null", "activeRegion != null"})
    private boolean readCannotOccurInAnyMoreActiveRegions(GATKSAMRecord read, ActiveRegion activeRegion) {
        return read.getReferenceIndex() < activeRegion.getLocation().getContigIndex() || read.getReferenceIndex().intValue() == activeRegion.getLocation().getContigIndex() && read.getAlignmentEnd() + this.getActiveRegionExtension() < activeRegion.getLocation().getStop();
    }

    @Ensures(value={"streamsInitialized == true"})
    private void initializeOutputStreamsIfNecessary() {
        if (!this.streamsInitialized) {
            this.streamsInitialized = true;
            if (this.walker.activityProfileOutStream != null) {
                this.printIGVFormatHeader(this.walker.activityProfileOutStream, "line", "ActivityProfile");
            }
            if (this.walker.activeRegionOutStream != null) {
                this.printIGVFormatHeader(this.walker.activeRegionOutStream, "line", "ActiveRegions");
            }
        }
    }

    @Requires(value={"out != null", "graphType != null", "columns.length > 0"})
    private void printIGVFormatHeader(PrintStream out, String graphType, String ... columns) {
        out.printf("#track graphType=%s%n", graphType);
        out.printf("Chromosome\tStart\tEnd\tFeature\t%s%n", Utils.join("\t", columns));
    }

    @Requires(value={"out != null", "loc != null", "values.length > 0"})
    private void printIGVFormatRow(PrintStream out, GenomeLoc loc, String featureName, double ... values) {
        out.printf("%s\t%d\t%d\t%s", loc.getContig(), loc.getStart() - 1, loc.getStop(), featureName);
        for (double value : values) {
            out.print(String.format("\t%.3f", value));
        }
        out.println();
    }

    @Requires(value={"states != null"})
    private void writeActivityProfile(List<ActivityProfileState> states) {
        if (this.walker.activityProfileOutStream != null) {
            this.initializeOutputStreamsIfNecessary();
            for (ActivityProfileState state : states) {
                this.printIGVFormatRow(this.walker.activityProfileOutStream, state.getLoc(), "state", Math.min(state.isActiveProb, 1.0));
            }
        }
    }

    @Requires(value={"region != null"})
    private void writeActiveRegion(ActiveRegion region) {
        if (this.walker.activeRegionOutStream != null) {
            this.initializeOutputStreamsIfNecessary();
            this.printIGVFormatRow(this.walker.activeRegionOutStream, region.getLocation().getStartLocation(), "end-marker", 0.0);
            this.printIGVFormatRow(this.walker.activeRegionOutStream, region.getLocation(), "size=" + region.getLocation().size(), region.isActive() ? 1.0 : -1.0);
        }
    }

    private void addIsActiveResult(ActiveRegionWalker<M, T> walker, RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext locus) {
        ActivityProfileState state = walker.isActive(tracker, refContext, locus);
        if (!this.walkerHasPresetRegions) {
            this.activityProfile.add(state);
        }
    }

    private T processActiveRegions(ActiveRegionWalker<M, T> walker, T sum, boolean flushActivityProfile, boolean forceAllRegionsToBeActive) {
        if (!this.walkerHasPresetRegions) {
            List<ActiveRegion> activeRegions = this.activityProfile.popReadyActiveRegions(this.getActiveRegionExtension(), this.getMinRegionSize(), this.getMaxRegionSize(), flushActivityProfile);
            this.workQueue.addAll(activeRegions);
            if (!activeRegions.isEmpty() && logger.isDebugEnabled()) {
                logger.debug("Integrated " + this.activityProfile.size() + " isActive calls into " + activeRegions.size() + " regions.");
            }
        }
        while (this.workQueue.peek() != null) {
            ActiveRegion activeRegion = this.workQueue.peek();
            if (!forceAllRegionsToBeActive && !this.regionCompletelyWithinDeadZone(activeRegion)) break;
            this.writeActivityProfile(activeRegion.getSupportingStates());
            this.writeActiveRegion(activeRegion);
            sum = this.processActiveRegion(this.workQueue.remove(), sum, walker);
        }
        return sum;
    }

    private T processActiveRegion(ActiveRegion activeRegion, T sum, ActiveRegionWalker<M, T> walker) {
        Iterator liveReads = this.myReads.iterator();
        while (liveReads.hasNext()) {
            boolean killed = false;
            GATKSAMRecord read = (GATKSAMRecord)liveReads.next();
            GenomeLoc readLoc = this.engine.getGenomeLocParser().createGenomeLoc(read);
            if (activeRegion.getLocation().overlapsP(readLoc)) {
                activeRegion.add(read);
                if (!walker.wantsNonPrimaryReads()) {
                    liveReads.remove();
                    killed = true;
                }
            } else if (walker.wantsExtendedReads() && activeRegion.getExtendedLoc().overlapsP(readLoc)) {
                activeRegion.add(read);
            }
            if (killed || !this.readCannotOccurInAnyMoreActiveRegions(read, activeRegion)) continue;
            liveReads.remove();
        }
        if (logger.isDebugEnabled()) {
            logger.debug(">> Map call with " + activeRegion.getReads().size() + " " + (activeRegion.isActive() ? "active" : "inactive") + " reads @ " + activeRegion.getLocation() + " with full extent: " + activeRegion.getReadSpanLoc());
        }
        M x = walker.map(activeRegion, null);
        return walker.reduce(x, sum);
    }
}

