/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.datasources.providers.ReadShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.ReadView;
import org.broadinstitute.sting.gatk.iterators.PushbackIterator;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.DuplicateWalker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class TraverseDuplicates<M, T>
extends TraversalEngine<M, T, DuplicateWalker<M, T>, ReadShardDataProvider> {
    protected static Logger logger = Logger.getLogger(TraverseDuplicates.class);
    private final boolean DEBUG = false;

    @Override
    public String getTraversalUnits() {
        return "dups";
    }

    private List<GATKSAMRecord> readsAtLoc(GATKSAMRecord read, PushbackIterator<SAMRecord> iter) {
        GenomeLoc site = this.engine.getGenomeLocParser().createGenomeLoc(read);
        ArrayList<GATKSAMRecord> l = new ArrayList<GATKSAMRecord>();
        l.add(read);
        for (SAMRecord read2 : iter) {
            GenomeLoc site2 = this.engine.getGenomeLocParser().createGenomeLoc(read2);
            if (site2.getStart() != site.getStart()) {
                iter.pushback(read2);
                break;
            }
            l.add((GATKSAMRecord)read2);
        }
        return l;
    }

    protected Set<List<GATKSAMRecord>> uniqueReadSets(List<GATKSAMRecord> reads) {
        LinkedHashSet<List<GATKSAMRecord>> readSets = new LinkedHashSet<List<GATKSAMRecord>>();
        for (GATKSAMRecord read : reads) {
            List<GATKSAMRecord> readSet = this.findDuplicateReads(read, readSets);
            if (readSet == null) {
                readSets.add(new ArrayList<GATKSAMRecord>(Arrays.asList(read)));
                continue;
            }
            readSet.add(read);
        }
        return readSets;
    }

    protected List<GATKSAMRecord> findDuplicateReads(GATKSAMRecord read, Set<List<GATKSAMRecord>> readSets) {
        if (read.getReadPairedFlag()) {
            GenomeLoc readMateLoc = this.engine.getGenomeLocParser().createGenomeLoc(read.getMateReferenceName(), read.getMateAlignmentStart(), read.getMateAlignmentStart());
            for (List<GATKSAMRecord> reads : readSets) {
                GenomeLoc keyMateLoc;
                GATKSAMRecord key = reads.get(0);
                if (read.getAlignmentStart() != key.getAlignmentStart() || !key.getReadPairedFlag() || !key.getDuplicateReadFlag() && !read.getDuplicateReadFlag() || readMateLoc.compareTo(keyMateLoc = this.engine.getGenomeLocParser().createGenomeLoc(key.getMateReferenceName(), key.getMateAlignmentStart(), key.getMateAlignmentStart())) != 0) continue;
                return reads;
            }
        } else {
            for (List<GATKSAMRecord> reads : readSets) {
                GATKSAMRecord key = reads.get(0);
                boolean v = !key.getReadPairedFlag() && read.getAlignmentStart() == key.getAlignmentStart() && (key.getDuplicateReadFlag() || read.getDuplicateReadFlag()) && read.getReadLength() == key.getReadLength();
                if (!v) continue;
                return reads;
            }
        }
        return null;
    }

    @Override
    public T traverse(DuplicateWalker<M, T> walker, ReadShardDataProvider dataProvider, T sum) {
        PushbackIterator<SAMRecord> iter = new PushbackIterator<SAMRecord>(new ReadView(dataProvider).iterator());
        boolean done = walker.isDone();
        for (SAMRecord read : iter) {
            if (done) break;
            GenomeLoc site = this.engine.getGenomeLocParser().createGenomeLoc(read);
            Set<List<GATKSAMRecord>> readSets = this.uniqueReadSets(this.readsAtLoc((GATKSAMRecord)read, iter));
            AlignmentContext locus = new AlignmentContext(site, new ReadBackedPileupImpl(site));
            dataProvider.getShard().getReadMetrics().incrementNumIterations();
            boolean keepMeP = walker.filter(site, locus, readSets);
            if (keepMeP) {
                M x = walker.map(site, locus, readSets);
                sum = walker.reduce(x, sum);
            }
            this.updateCumulativeMetrics(dataProvider.getShard());
            this.printProgress(site.getStopLocation());
            done = walker.isDone();
        }
        return sum;
    }
}

