/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import java.util.Iterator;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.AllLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.CoveredLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusReferenceView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.LocusView;
import org.broadinstitute.sting.gatk.datasources.providers.ManagingReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.RodLocusView;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.nanoScheduler.NSMapFunction;
import org.broadinstitute.sting.utils.nanoScheduler.NSProgressFunction;
import org.broadinstitute.sting.utils.nanoScheduler.NSReduceFunction;
import org.broadinstitute.sting.utils.nanoScheduler.NanoScheduler;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;

public class TraverseLociNano<M, T>
extends TraversalEngine<M, T, LocusWalker<M, T>, LocusShardDataProvider> {
    private static final boolean DEBUG = false;
    final NanoScheduler<MapData, MapResult, T> nanoScheduler;
    private final MapResult SKIP_REDUCE = new MapResult();

    public TraverseLociNano(int nThreads) {
        this.nanoScheduler = new NanoScheduler(nThreads);
        this.nanoScheduler.setProgressFunction(new TraverseLociProgress());
    }

    @Override
    public final String getTraversalUnits() {
        return "sites";
    }

    @Override
    public T traverse(LocusWalker<M, T> walker, LocusShardDataProvider dataProvider, T sum) {
        RodLocusView rodLocusView;
        long nSkipped;
        logger.debug(String.format("TraverseLoci.traverse: Shard is %s", dataProvider));
        LocusView locusView = this.getLocusView(walker, dataProvider);
        if (locusView.hasNext()) {
            ReferenceOrderedView referenceOrderedDataView = null;
            referenceOrderedDataView = WalkerManager.getWalkerDataSource(walker) != DataSource.REFERENCE_ORDERED_DATA ? new ManagingReferenceOrderedView(dataProvider) : (RodLocusView)locusView;
            LocusReferenceView referenceView = new LocusReferenceView(walker, dataProvider);
            TraverseResults<T> result = this.traverse(walker, locusView, referenceView, referenceOrderedDataView, sum);
            sum = result.reduceResult;
            dataProvider.getShard().getReadMetrics().incrementNumIterations(result.numIterations);
            this.updateCumulativeMetrics(dataProvider.getShard());
        }
        if (WalkerManager.getWalkerDataSource(walker) == DataSource.REFERENCE_ORDERED_DATA && !walker.isDone() && (nSkipped = (rodLocusView = (RodLocusView)locusView).getLastSkippedBases()) > 0L) {
            GenomeLoc site = rodLocusView.getLocOneBeyondShard();
            AlignmentContext ac = new AlignmentContext(site, (ReadBackedPileup)new ReadBackedPileupImpl(site), nSkipped);
            M x = walker.map(null, null, ac);
            sum = walker.reduce(x, sum);
        }
        return sum;
    }

    private LocusView getLocusView(Walker<M, T> walker, LocusShardDataProvider dataProvider) {
        DataSource dataSource = WalkerManager.getWalkerDataSource(walker);
        if (dataSource == DataSource.READS) {
            return new CoveredLocusView(dataProvider);
        }
        if (dataSource == DataSource.REFERENCE) {
            return new AllLocusView(dataProvider);
        }
        if (dataSource == DataSource.REFERENCE_ORDERED_DATA) {
            return new RodLocusView(dataProvider);
        }
        throw new UnsupportedOperationException("Unsupported traversal type: " + (Object)((Object)dataSource));
    }

    protected TraverseResults<T> traverse(LocusWalker<M, T> walker, LocusView locusView, LocusReferenceView referenceView, ReferenceOrderedView referenceOrderedDataView, T sum) {
        this.nanoScheduler.setDebug(false);
        TraverseLociMap myMap = new TraverseLociMap(walker);
        TraverseLociReduce myReduce = new TraverseLociReduce(walker);
        MapDataIterator inputIterator = new MapDataIterator(locusView, referenceView, referenceOrderedDataView);
        T result = this.nanoScheduler.execute(inputIterator, myMap, sum, myReduce);
        return new TraverseResults<T>(inputIterator.numIterations, result);
    }

    @Override
    public void shutdown() {
        this.nanoScheduler.shutdown();
    }

    private class TraverseLociProgress
    implements NSProgressFunction<MapData> {
        private TraverseLociProgress() {
        }

        @Override
        public void progress(MapData lastProcessedMap) {
            if (lastProcessedMap.alignmentContext != null) {
                TraverseLociNano.this.printProgress(lastProcessedMap.alignmentContext.getLocation());
            }
        }
    }

    private class TraverseLociReduce
    implements NSReduceFunction<MapResult, T> {
        final LocusWalker<M, T> walker;

        private TraverseLociReduce(LocusWalker<M, T> walker) {
            this.walker = walker;
        }

        @Override
        public T apply(MapResult one, T sum) {
            if (one.reduceMe) {
                return this.walker.reduce(one.value, sum);
            }
            return sum;
        }
    }

    private class TraverseLociMap
    implements NSMapFunction<MapData, MapResult> {
        final LocusWalker<M, T> walker;

        private TraverseLociMap(LocusWalker<M, T> walker) {
            this.walker = walker;
        }

        @Override
        public MapResult apply(MapData data) {
            boolean keepMeP;
            if (!this.walker.isDone() && (keepMeP = this.walker.filter(data.tracker, data.refContext, data.alignmentContext))) {
                Object x = this.walker.map(data.tracker, data.refContext, data.alignmentContext);
                return new MapResult(x);
            }
            return TraverseLociNano.this.SKIP_REDUCE;
        }
    }

    private class MapResult {
        final M value;
        final boolean reduceMe;

        private MapResult(M value) {
            this.value = value;
            this.reduceMe = true;
        }

        private MapResult() {
            this.value = null;
            this.reduceMe = false;
        }
    }

    private class MapData {
        final AlignmentContext alignmentContext;
        final ReferenceContext refContext;
        final RefMetaDataTracker tracker;

        private MapData(AlignmentContext alignmentContext, ReferenceContext refContext, RefMetaDataTracker tracker) {
            this.alignmentContext = alignmentContext;
            this.refContext = refContext;
            this.tracker = tracker;
        }

        public String toString() {
            return "MapData " + this.alignmentContext.getLocation();
        }
    }

    private class MapDataIterator
    implements Iterator<MapData> {
        final LocusView locusView;
        final LocusReferenceView referenceView;
        final ReferenceOrderedView referenceOrderedDataView;
        int numIterations = 0;

        private MapDataIterator(LocusView locusView, LocusReferenceView referenceView, ReferenceOrderedView referenceOrderedDataView) {
            this.locusView = locusView;
            this.referenceView = referenceView;
            this.referenceOrderedDataView = referenceOrderedDataView;
        }

        @Override
        public boolean hasNext() {
            return this.locusView.hasNext();
        }

        @Override
        public MapData next() {
            AlignmentContext locus = this.locusView.next();
            GenomeLoc location = locus.getLocation();
            ReferenceContext refContext = this.referenceView.getReferenceContext(location);
            RefMetaDataTracker tracker = this.referenceOrderedDataView.getReferenceOrderedDataAtLocus(location, refContext);
            ++this.numIterations;
            return new MapData(locus, refContext, tracker);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements from MapDataIterator");
        }
    }

    protected static class TraverseResults<T> {
        final int numIterations;
        final T reduceResult;

        public TraverseResults(int numIterations, T reduceResult) {
            this.numIterations = numIterations;
            this.reduceResult = reduceResult;
        }
    }
}

