/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ExperimentalAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.GenotypeAnnotation;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFFormatHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;

public class AlleleBalanceBySample
extends GenotypeAnnotation
implements ExperimentalAnnotation {
    @Override
    public void annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, AlignmentContext stratifiedContext, VariantContext vc, Genotype g, GenotypeBuilder gb, PerReadAlleleLikelihoodMap alleleLikelihoodMap) {
        if (stratifiedContext == null) {
            return;
        }
        Double ratio = this.annotateSNP(stratifiedContext, vc, g);
        if (ratio == null) {
            return;
        }
        gb.attribute(this.getKeyNames().get(0), Double.valueOf(String.format("%.2f", (double)ratio)));
    }

    private Double annotateSNP(AlignmentContext stratifiedContext, VariantContext vc, Genotype g) {
        int altCount;
        double ratio = -1.0;
        if (!vc.isSNP()) {
            return null;
        }
        if (!vc.isBiallelic()) {
            return null;
        }
        if (g == null || !g.isCalled()) {
            return null;
        }
        if (!g.isHet()) {
            return null;
        }
        List<Allele> altAlleles = vc.getAlternateAlleles();
        if (altAlleles.size() == 0) {
            return null;
        }
        String bases = new String(stratifiedContext.getBasePileup().getBases());
        if (bases.length() == 0) {
            return null;
        }
        char refChr = vc.getReference().toString().charAt(0);
        char altChr = vc.getAlternateAllele(0).toString().charAt(0);
        int refCount = MathUtils.countOccurrences(refChr, bases);
        if (refCount + (altCount = MathUtils.countOccurrences(altChr, bases)) == 0) {
            return null;
        }
        ratio = (double)refCount / (double)(refCount + altCount);
        return ratio;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("AB");
    }

    @Override
    public List<VCFFormatHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFFormatHeaderLine(this.getKeyNames().get(0), 1, VCFHeaderLineType.Float, "Allele balance for each het genotype"));
    }
}

