/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.annotator.RankSumTest;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class BaseQualityRankSumTest
extends RankSumTest
implements StandardAnnotation {
    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("BaseQRankSum");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("BaseQRankSum", 1, VCFHeaderLineType.Float, "Z-score from Wilcoxon rank sum test of Alt Vs. Ref base qualities"));
    }

    @Override
    protected void fillQualsFromPileup(List<Allele> allAlleles, int refLoc, ReadBackedPileup pileup, PerReadAlleleLikelihoodMap alleleLikelihoodMap, List<Double> refQuals, List<Double> altQuals) {
        if (alleleLikelihoodMap == null) {
            for (PileupElement p : pileup) {
                if (!BaseQualityRankSumTest.isUsableBase(p)) continue;
                if (allAlleles.get(0).equals(Allele.create(p.getBase(), true))) {
                    refQuals.add(Double.valueOf(p.getQual()));
                    continue;
                }
                if (!allAlleles.contains(Allele.create(p.getBase()))) continue;
                altQuals.add(Double.valueOf(p.getQual()));
            }
            return;
        }
        for (Map<Allele, Double> el : alleleLikelihoodMap.getLikelihoodMapValues()) {
            Allele a = PerReadAlleleLikelihoodMap.getMostLikelyAllele(el);
            if (a.isNoCall()) continue;
            if (a.isReference()) {
                refQuals.add(-10.0 * el.get(a));
                continue;
            }
            if (!allAlleles.contains(a)) continue;
            altQuals.add(-10.0 * el.get(a));
        }
    }
}

