/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import cern.jet.math.Arithmetic;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.RankSumTest;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class FisherStrand
extends InfoFieldAnnotation
implements StandardAnnotation,
ActiveRegionBasedAnnotation {
    private static final String FS = "FS";
    private static final double MIN_PVALUE = 1.0E-320;
    private static final int MIN_QUAL_FOR_FILTERED_TEST = 17;

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, Map<String, PerReadAlleleLikelihoodMap> stratifiedPerReadAlleleLikelihoodMap) {
        if (!vc.isVariant()) {
            return null;
        }
        if (vc.isSNP() && stratifiedContexts != null) {
            int[][] tableNoFiltering = FisherStrand.getSNPContingencyTable(stratifiedContexts, vc.getReference(), vc.getAltAlleleWithHighestAlleleCount(), -1);
            int[][] tableFiltering = FisherStrand.getSNPContingencyTable(stratifiedContexts, vc.getReference(), vc.getAltAlleleWithHighestAlleleCount(), 17);
            return this.pValueForBestTable(tableFiltering, tableNoFiltering);
        }
        if (stratifiedPerReadAlleleLikelihoodMap != null) {
            int[][] table = FisherStrand.getContingencyTable(stratifiedPerReadAlleleLikelihoodMap, vc);
            return this.pValueForBestTable(table, null);
        }
        return null;
    }

    private Map<String, Object> pValueForBestTable(int[][] table1, int[][] table2) {
        if (table2 == null) {
            return table1 == null ? null : this.annotationForOneTable(this.pValueForContingencyTable(table1));
        }
        if (table1 == null) {
            return this.annotationForOneTable(this.pValueForContingencyTable(table2));
        }
        double pvalue1 = this.pValueForContingencyTable(table1);
        double pvalue2 = this.pValueForContingencyTable(table2);
        return this.annotationForOneTable(Math.max(pvalue1, pvalue2));
    }

    private Map<String, Object> annotationForOneTable(double pValue) {
        String value = String.format("%.3f", QualityUtils.phredScaleErrorRate(Math.max(pValue, 1.0E-320)));
        return Collections.singletonMap(FS, value);
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList(FS);
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(FS, 1, VCFHeaderLineType.Float, "Phred-scaled p-value using Fisher's exact test to detect strand bias"));
    }

    private Double pValueForContingencyTable(int[][] originalTable) {
        double pValuePiece;
        double pCutoff;
        int[][] table = FisherStrand.copyContingencyTable(originalTable);
        double pValue = pCutoff = FisherStrand.computePValue(table);
        while (FisherStrand.rotateTable(table)) {
            pValuePiece = FisherStrand.computePValue(table);
            if (!(pValuePiece <= pCutoff)) continue;
            pValue += pValuePiece;
        }
        table = FisherStrand.copyContingencyTable(originalTable);
        while (FisherStrand.unrotateTable(table)) {
            pValuePiece = FisherStrand.computePValue(table);
            if (!(pValuePiece <= pCutoff)) continue;
            pValue += pValuePiece;
        }
        return Math.min(pValue, 1.0);
    }

    private static int[][] copyContingencyTable(int[][] t) {
        int[][] c = new int[2][2];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                c[i][j] = t[i][j];
            }
        }
        return c;
    }

    private static void printTable(int[][] table, double pValue) {
        System.out.printf("%d %d; %d %d : %f\n", table[0][0], table[0][1], table[1][0], table[1][1], pValue);
    }

    private static boolean rotateTable(int[][] table) {
        int[] nArray = table[0];
        nArray[0] = nArray[0] - 1;
        int[] nArray2 = table[1];
        nArray2[0] = nArray2[0] + 1;
        int[] nArray3 = table[0];
        nArray3[1] = nArray3[1] + 1;
        int[] nArray4 = table[1];
        nArray4[1] = nArray4[1] - 1;
        return table[0][0] >= 0 && table[1][1] >= 0;
    }

    private static boolean unrotateTable(int[][] table) {
        int[] nArray = table[0];
        nArray[0] = nArray[0] + 1;
        int[] nArray2 = table[1];
        nArray2[0] = nArray2[0] - 1;
        int[] nArray3 = table[0];
        nArray3[1] = nArray3[1] - 1;
        int[] nArray4 = table[1];
        nArray4[1] = nArray4[1] + 1;
        return table[0][1] >= 0 && table[1][0] >= 0;
    }

    private static double computePValue(int[][] table) {
        int[] rowSums = new int[]{FisherStrand.sumRow(table, 0), FisherStrand.sumRow(table, 1)};
        int[] colSums = new int[]{FisherStrand.sumColumn(table, 0), FisherStrand.sumColumn(table, 1)};
        int N = rowSums[0] + rowSums[1];
        double pCutoff = Arithmetic.logFactorial(rowSums[0]) + Arithmetic.logFactorial(rowSums[1]) + Arithmetic.logFactorial(colSums[0]) + Arithmetic.logFactorial(colSums[1]) - Arithmetic.logFactorial(table[0][0]) - Arithmetic.logFactorial(table[0][1]) - Arithmetic.logFactorial(table[1][0]) - Arithmetic.logFactorial(table[1][1]) - Arithmetic.logFactorial(N);
        return Math.exp(pCutoff);
    }

    private static int sumRow(int[][] table, int column) {
        int sum = 0;
        for (int r = 0; r < table.length; ++r) {
            sum += table[r][column];
        }
        return sum;
    }

    private static int sumColumn(int[][] table, int row) {
        int sum = 0;
        for (int c = 0; c < table[row].length; ++c) {
            sum += table[row][c];
        }
        return sum;
    }

    private static int[][] getContingencyTable(Map<String, PerReadAlleleLikelihoodMap> stratifiedPerReadAlleleLikelihoodMap, VariantContext vc) {
        Allele ref = vc.getReference();
        Allele alt = vc.getAltAlleleWithHighestAlleleCount();
        int[][] table = new int[2][2];
        for (PerReadAlleleLikelihoodMap maps : stratifiedPerReadAlleleLikelihoodMap.values()) {
            for (Map.Entry<GATKSAMRecord, Map<Allele, Double>> el : maps.getLikelihoodReadMap().entrySet()) {
                Allele mostLikelyAllele = PerReadAlleleLikelihoodMap.getMostLikelyAllele(el.getValue());
                GATKSAMRecord read = el.getKey();
                byte representativeCount = read.isReducedRead() ? read.getReducedCount(ReadUtils.getReadCoordinateForReferenceCoordinateUpToEndOfRead(read, vc.getStart(), ReadUtils.ClippingTail.RIGHT_TAIL)) : (byte)1;
                FisherStrand.updateTable(table, mostLikelyAllele, read, ref, alt, representativeCount);
            }
        }
        return table;
    }

    private static int[][] getSNPContingencyTable(Map<String, AlignmentContext> stratifiedContexts, Allele ref, Allele alt, int minQScoreToConsider) {
        int[][] table = new int[2][2];
        for (Map.Entry<String, AlignmentContext> sample : stratifiedContexts.entrySet()) {
            for (PileupElement p : sample.getValue().getBasePileup()) {
                if (!RankSumTest.isUsableBase(p, false) || p.getQual() < minQScoreToConsider || p.getMappingQual() < minQScoreToConsider) continue;
                FisherStrand.updateTable(table, Allele.create(p.getBase(), false), p.getRead(), ref, alt, p.getRepresentativeCount());
            }
        }
        return table;
    }

    private static void updateTable(int[][] table, Allele allele, GATKSAMRecord read, Allele ref, Allele alt, int representativeCount) {
        if (read.isReducedRead()) {
            return;
        }
        boolean matchesRef = allele.equals(ref, true);
        boolean matchesAlt = allele.equals(alt, true);
        if (matchesRef || matchesAlt) {
            boolean isFW = !read.getReadNegativeStrandFlag();
            int row = matchesRef ? 0 : 1;
            int column = isFW ? 0 : 1;
            int[] nArray = table[row];
            int n = column;
            nArray[n] = nArray[n] + representativeCount;
        }
    }
}

