/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class HaplotypeScore
extends InfoFieldAnnotation
implements StandardAnnotation,
ActiveRegionBasedAnnotation {
    private static final boolean DEBUG = false;
    private static final int MIN_CONTEXT_WING_SIZE = 10;
    private static final int MAX_CONSENSUS_HAPLOTYPES_TO_CONSIDER = 50;
    private static final char REGEXP_WILDCARD = '.';

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, Map<String, PerReadAlleleLikelihoodMap> stratifiedPerReadAlleleLikelihoodMap) {
        if (vc.isSNP() && stratifiedContexts != null) {
            return this.annotatePileup(ref, stratifiedContexts, vc);
        }
        return null;
    }

    private Map<String, Object> annotatePileup(ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        AlignmentContext context = AlignmentContextUtils.joinContexts(stratifiedContexts.values());
        int contextWingSize = Math.min((ref.getWindow().size() - 1) / 2, 10);
        int contextSize = contextWingSize * 2 + 1;
        int locus = ref.getLocus().getStart() + (ref.getLocus().getStop() - ref.getLocus().getStart()) / 2;
        ReadBackedPileup pileup = context.getBasePileup();
        List<Haplotype> haplotypes = this.computeHaplotypes(pileup, contextSize, locus, vc);
        MathUtils.RunningAverage scoreRA = new MathUtils.RunningAverage();
        if (haplotypes != null) {
            for (Genotype genotype : vc.getGenotypes()) {
                AlignmentContext thisContext = stratifiedContexts.get(genotype.getSampleName());
                if (thisContext == null) continue;
                ReadBackedPileup thisPileup = thisContext.getBasePileup();
                scoreRA.add(this.scoreReadsAgainstHaplotypes(haplotypes, thisPileup, contextSize, locus));
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%.4f", scoreRA.mean()));
        return map;
    }

    private List<Haplotype> computeHaplotypes(ReadBackedPileup pileup, int contextSize, int locus, VariantContext vc) {
        Haplotype elem;
        int haplotypesToCompute = vc.getAlternateAlleles().size() + 1;
        PriorityQueue<Haplotype> candidateHaplotypeQueue = new PriorityQueue<Haplotype>(100, new HaplotypeComparator());
        PriorityQueue<Haplotype> consensusHaplotypeQueue = new PriorityQueue<Haplotype>(50, new HaplotypeComparator());
        for (PileupElement p : pileup) {
            Haplotype haplotypeFromRead = this.getHaplotypeFromRead(p, contextSize, locus);
            if (haplotypeFromRead == null) continue;
            candidateHaplotypeQueue.add(haplotypeFromRead);
        }
        while ((elem = candidateHaplotypeQueue.poll()) != null) {
            boolean foundHaplotypeMatch = false;
            Haplotype lastCheckedHaplotype = null;
            for (Haplotype haplotypeFromList : consensusHaplotypeQueue) {
                Haplotype consensusHaplotype = this.getConsensusHaplotype(elem, haplotypeFromList);
                if (consensusHaplotype != null) {
                    foundHaplotypeMatch = true;
                    if (!(consensusHaplotype.getQualitySum() > haplotypeFromList.getQualitySum())) break;
                    consensusHaplotypeQueue.remove(haplotypeFromList);
                    consensusHaplotypeQueue.add(consensusHaplotype);
                    break;
                }
                lastCheckedHaplotype = haplotypeFromList;
            }
            if (!foundHaplotypeMatch && consensusHaplotypeQueue.size() < 50) {
                consensusHaplotypeQueue.add(elem);
                continue;
            }
            if (foundHaplotypeMatch || lastCheckedHaplotype == null || !(elem.getQualitySum() > lastCheckedHaplotype.getQualitySum())) continue;
            consensusHaplotypeQueue.remove(lastCheckedHaplotype);
            consensusHaplotypeQueue.add(elem);
        }
        if (consensusHaplotypeQueue.size() > 0) {
            Haplotype haplotype1 = consensusHaplotypeQueue.poll();
            ArrayList<Haplotype> hlist = new ArrayList<Haplotype>();
            hlist.add(new Haplotype(haplotype1.getBases(), 60));
            for (int k = 1; k < haplotypesToCompute; ++k) {
                Haplotype haplotype2 = consensusHaplotypeQueue.poll();
                if (haplotype2 == null) {
                    haplotype2 = haplotype1;
                }
                hlist.add(new Haplotype(haplotype2.getBases(), 20));
            }
            return hlist;
        }
        return null;
    }

    private Haplotype getHaplotypeFromRead(PileupElement p, int contextSize, int locus) {
        GATKSAMRecord read = p.getRead();
        if (read.getCigar() == null) {
            return null;
        }
        byte[] haplotypeBases = new byte[contextSize];
        Arrays.fill(haplotypeBases, (byte)46);
        byte[] baseQualities = new byte[contextSize];
        Arrays.fill(baseQualities, (byte)0);
        byte[] readBases = read.getReadBases();
        readBases = AlignmentUtils.readToAlignmentByteArray(read.getCigar(), readBases);
        byte[] readQuals = read.getBaseQualities();
        readQuals = AlignmentUtils.readToAlignmentByteArray(read.getCigar(), readQuals);
        int readOffsetFromPileup = AlignmentUtils.calcAlignmentByteArrayOffset(read.getCigar(), p, read.getAlignmentStart(), locus);
        int baseOffsetStart = readOffsetFromPileup - (contextSize - 1) / 2;
        for (int i = 0; i < contextSize; ++i) {
            int baseOffset = i + baseOffsetStart;
            if (baseOffset < 0) continue;
            if (baseOffset >= readBases.length) break;
            if (readQuals[baseOffset] == PileupElement.DELETION_BASE) {
                readQuals[baseOffset] = 16;
            }
            if (!BaseUtils.isRegularBase(readBases[baseOffset])) {
                readBases[baseOffset] = 46;
                readQuals[baseOffset] = 0;
            }
            readQuals[baseOffset] = (byte)Math.min(readQuals[baseOffset], p.getMappingQual());
            if (readQuals[baseOffset] < 5) {
                readQuals[baseOffset] = 0;
            }
            haplotypeBases[i] = readBases[baseOffset];
            baseQualities[i] = readQuals[baseOffset];
        }
        return new Haplotype(haplotypeBases, baseQualities);
    }

    private Haplotype getConsensusHaplotype(Haplotype haplotypeA, Haplotype haplotypeB) {
        byte[] b;
        byte[] a = haplotypeA.getBases();
        if (a.length != (b = haplotypeB.getBases()).length) {
            throw new ReviewedStingException("Haplotypes a and b must be of same length");
        }
        int wc = 46;
        int length = a.length;
        byte[] consensusChars = new byte[length];
        int[] consensusQuals = new int[length];
        int[] qualsA = haplotypeA.getQuals();
        int[] qualsB = haplotypeB.getQuals();
        for (int i = 0; i < length; ++i) {
            byte chA = a[i];
            byte chB = b[i];
            if (chA != chB && chA != 46 && chB != 46) {
                return null;
            }
            if (chA == 46 && chB == 46) {
                consensusChars[i] = 46;
                consensusQuals[i] = 0;
                continue;
            }
            if (chA == 46) {
                consensusChars[i] = chB;
                consensusQuals[i] = qualsB[i];
                continue;
            }
            if (chB == 46) {
                consensusChars[i] = chA;
                consensusQuals[i] = qualsA[i];
                continue;
            }
            consensusChars[i] = chA;
            consensusQuals[i] = qualsA[i] + qualsB[i];
        }
        return new Haplotype(consensusChars, consensusQuals);
    }

    private double scoreReadsAgainstHaplotypes(List<Haplotype> haplotypes, ReadBackedPileup pileup, int contextSize, int locus) {
        ArrayList<double[]> haplotypeScores = new ArrayList<double[]>();
        for (PileupElement p : pileup) {
            double[] scores = new double[haplotypes.size()];
            for (int i = 0; i < haplotypes.size(); ++i) {
                double score;
                Haplotype haplotype = haplotypes.get(i);
                scores[i] = score = this.scoreReadAgainstHaplotype(p, contextSize, haplotype, locus);
            }
            haplotypeScores.add(scores);
        }
        double overallScore = 0.0;
        for (double[] readHaplotypeScores : haplotypeScores) {
            overallScore += MathUtils.arrayMin(readHaplotypeScores);
        }
        return overallScore;
    }

    private double scoreReadAgainstHaplotype(PileupElement p, int contextSize, Haplotype haplotype, int locus) {
        double expected = 0.0;
        double mismatches = 0.0;
        GATKSAMRecord read = p.getRead();
        if (read.getCigar() == null) {
            return 0.0;
        }
        byte[] haplotypeBases = haplotype.getBases();
        byte[] readBases = read.getReadBases();
        readBases = AlignmentUtils.readToAlignmentByteArray(p.getRead().getCigar(), readBases);
        byte[] readQuals = read.getBaseQualities();
        readQuals = AlignmentUtils.readToAlignmentByteArray(p.getRead().getCigar(), readQuals);
        int readOffsetFromPileup = AlignmentUtils.calcAlignmentByteArrayOffset(p.getRead().getCigar(), p, read.getAlignmentStart(), locus);
        int baseOffsetStart = readOffsetFromPileup - (contextSize - 1) / 2;
        for (int i = 0; i < contextSize; ++i) {
            int baseOffset = i + baseOffsetStart;
            if (baseOffset < 0) continue;
            if (baseOffset >= readBases.length) break;
            byte readBase = readBases[baseOffset];
            byte haplotypeBase = haplotypeBases[i];
            boolean matched = readBase == haplotypeBase || haplotypeBase == 46;
            byte qual = readQuals[baseOffset];
            if (qual == PileupElement.DELETION_BASE) {
                qual = 16;
            }
            if ((qual = (byte)((byte)Math.min(qual, p.getMappingQual()))) < 5) continue;
            double e = QualityUtils.qualToErrorProb(qual);
            expected += e;
            mismatches += matched ? e : 1.0 - e / 3.0;
        }
        return mismatches - expected;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("HaplotypeScore");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("HaplotypeScore", 1, VCFHeaderLineType.Float, "Consistency of the site with at most two segregating haplotypes"));
    }

    private static class Haplotype {
        private final byte[] bases;
        private final int[] quals;
        private int qualitySum = -1;

        public Haplotype(byte[] bases, int[] quals) {
            this.bases = bases;
            this.quals = quals;
        }

        public Haplotype(byte[] bases, int qual) {
            this.bases = bases;
            this.quals = new int[bases.length];
            Arrays.fill(this.quals, qual);
        }

        public Haplotype(byte[] bases, byte[] quals) {
            this.bases = bases;
            this.quals = new int[quals.length];
            for (int i = 0; i < quals.length; ++i) {
                this.quals[i] = quals[i];
            }
        }

        public double getQualitySum() {
            if (this.qualitySum == -1) {
                this.qualitySum = 0;
                for (int qual : this.quals) {
                    this.qualitySum += qual;
                }
            }
            return this.qualitySum;
        }

        public int[] getQuals() {
            return (int[])this.quals.clone();
        }

        public byte[] getBases() {
            return (byte[])this.bases.clone();
        }
    }

    private static class HaplotypeComparator
    implements Comparator<Haplotype>,
    Serializable {
        private HaplotypeComparator() {
        }

        @Override
        public int compare(Haplotype a, Haplotype b) {
            if (a.getQualitySum() < b.getQualitySum()) {
                return 1;
            }
            if (a.getQualitySum() > b.getQualitySum()) {
                return -1;
            }
            return 0;
        }
    }
}

