/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class HomopolymerRun
extends InfoFieldAnnotation {
    private boolean ANNOTATE_INDELS = true;

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, Map<String, PerReadAlleleLikelihoodMap> stratifiedPerReadAlleleLikelihoodMap) {
        int run;
        if (!vc.isBiallelic()) {
            return null;
        }
        if (vc.isSNP()) {
            run = HomopolymerRun.computeHomopolymerRun(vc.getAlternateAllele(0).getBases()[0], ref);
        } else if (vc.isIndel() && this.ANNOTATE_INDELS) {
            run = HomopolymerRun.computeIndelHomopolymerRun(vc, ref);
        } else {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%d", run));
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("HRun");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("HRun", 1, VCFHeaderLineType.Integer, "Largest Contiguous Homopolymer Run of Variant Allele In Either Direction"));
    }

    public boolean useZeroQualityReads() {
        return false;
    }

    private static int computeHomopolymerRun(byte altAllele, ReferenceContext ref) {
        byte[] bases = ref.getBases();
        GenomeLoc window = ref.getWindow();
        GenomeLoc locus = ref.getLocus();
        int refBasePos = locus.getStart() - window.getStart();
        int leftRun = 0;
        for (int i = refBasePos - 1; i >= 0 && bases[i] == altAllele; --i) {
            ++leftRun;
        }
        int rightRun = 0;
        for (int i = refBasePos + 1; i < bases.length && bases[i] == altAllele; ++i) {
            ++rightRun;
        }
        return Math.max(leftRun, rightRun);
    }

    private static int computeIndelHomopolymerRun(VariantContext vc, ReferenceContext ref) {
        byte[] bases = ref.getBases();
        GenomeLoc locus = ref.getLocus();
        GenomeLoc window = ref.getWindow();
        int refBasePos = locus.getStart() - window.getStart() + 1;
        if (vc.isSimpleDeletion()) {
            byte dBase = bases[refBasePos];
            for (int i = 0; i < vc.getReference().length(); ++i) {
                if (bases[refBasePos + i] == dBase) continue;
                return 0;
            }
            return HomopolymerRun.computeHomopolymerRun(dBase, ref);
        }
        byte insBase = vc.getAlternateAllele(0).getBases()[0];
        for (byte b : vc.getAlternateAllele(0).getBases()) {
            if (insBase == (char)b) continue;
            return 0;
        }
        return HomopolymerRun.computeHomopolymerRun(insBase, ref);
    }
}

