/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.samples.Trio;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.gatk.walkers.annotator.VariantAnnotator;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ExperimentalAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.RodRequiringAnnotation;
import org.broadinstitute.sting.utils.MendelianViolation;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class MVLikelihoodRatio
extends InfoFieldAnnotation
implements ExperimentalAnnotation,
RodRequiringAnnotation {
    private MendelianViolation mendelianViolation = null;
    public static final String MVLR_KEY = "MVLR";
    private Set<Trio> trios;

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, Map<String, PerReadAlleleLikelihoodMap> stratifiedPerReadAlleleLikelihoodMap) {
        if (this.mendelianViolation == null) {
            this.trios = ((Walker)((Object)walker)).getSampleDB().getTrios();
            if (this.trios.size() > 0) {
                this.mendelianViolation = new MendelianViolation(((VariantAnnotator)walker).minGenotypeQualityP);
            } else {
                throw new UserException("Mendelian violation annotation can only be used from the Variant Annotator, and must be provided a valid PED file (-ped) from the command line.");
            }
        }
        HashMap<String, Object> attributeMap = new HashMap<String, Object>(1);
        double maxMVLR = Double.MIN_VALUE;
        for (Trio trio : this.trios) {
            if (!this.contextHasTrioLikelihoods(vc, trio)) continue;
            Double likR = this.mendelianViolation.violationLikelihoodRatio(vc, trio.getMaternalID(), trio.getPaternalID(), trio.getChildID());
            maxMVLR = likR > maxMVLR ? likR : maxMVLR;
        }
        if (Double.compare(maxMVLR, Double.MIN_VALUE) != 0) {
            attributeMap.put(MVLR_KEY, maxMVLR);
        }
        return attributeMap;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList(MVLR_KEY);
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(MVLR_KEY, 1, VCFHeaderLineType.Float, "Mendelian violation likelihood ratio: L[MV] - L[No MV]"));
    }

    private boolean contextHasTrioLikelihoods(VariantContext context, Trio trio) {
        for (String sample : Arrays.asList(trio.getMaternalID(), trio.getPaternalID(), trio.getChildID())) {
            if (!context.hasGenotype(sample)) {
                return false;
            }
            if (context.getGenotype(sample).hasLikelihoods()) continue;
            return false;
        }
        return true;
    }
}

