/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.annotator.RankSumTest;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class MappingQualityRankSumTest
extends RankSumTest
implements StandardAnnotation {
    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("MQRankSum");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("MQRankSum", 1, VCFHeaderLineType.Float, "Z-score From Wilcoxon rank sum test of Alt vs. Ref read mapping qualities"));
    }

    @Override
    protected void fillQualsFromPileup(List<Allele> allAlleles, int refLoc, ReadBackedPileup pileup, PerReadAlleleLikelihoodMap likelihoodMap, List<Double> refQuals, List<Double> altQuals) {
        if (pileup != null && likelihoodMap == null) {
            for (PileupElement p : pileup) {
                if (!MappingQualityRankSumTest.isUsableBase(p)) continue;
                if (allAlleles.get(0).equals(Allele.create(p.getBase(), true))) {
                    refQuals.add(Double.valueOf(p.getMappingQual()));
                    continue;
                }
                if (!allAlleles.contains(Allele.create(p.getBase()))) continue;
                altQuals.add(Double.valueOf(p.getMappingQual()));
            }
            return;
        }
        for (Map.Entry<GATKSAMRecord, Map<Allele, Double>> el : likelihoodMap.getLikelihoodReadMap().entrySet()) {
            Allele a = PerReadAlleleLikelihoodMap.getMostLikelyAllele(el.getValue());
            if (a.isNoCall()) continue;
            if (a.isReference()) {
                refQuals.add(Double.valueOf(el.getKey().getMappingQuality()));
                continue;
            }
            if (!allAlleles.contains(a)) continue;
            altQuals.add(Double.valueOf(el.getKey().getMappingQuality()));
        }
    }
}

