/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;
import org.broadinstitute.variant.vcf.VCFStandardHeaderLines;

public class MappingQualityZero
extends InfoFieldAnnotation
implements StandardAnnotation,
ActiveRegionBasedAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, Map<String, PerReadAlleleLikelihoodMap> stratifiedPerReadAlleleLikelihoodMap) {
        if ((vc.isSNP() || !vc.isVariant()) && stratifiedContexts != null) {
            return this.annotatePileup(ref, stratifiedContexts, vc);
        }
        if (stratifiedPerReadAlleleLikelihoodMap != null && vc.isVariant()) {
            return this.annotateWithLikelihoods(stratifiedPerReadAlleleLikelihoodMap, vc);
        }
        return null;
    }

    private Map<String, Object> annotatePileup(ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        int mq0 = 0;
        for (Map.Entry<String, AlignmentContext> sample : stratifiedContexts.entrySet()) {
            AlignmentContext context = sample.getValue();
            ReadBackedPileup pileup = context.getBasePileup();
            for (PileupElement p : pileup) {
                if (p.getMappingQual() != 0) continue;
                ++mq0;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%d", mq0));
        return map;
    }

    private Map<String, Object> annotateWithLikelihoods(Map<String, PerReadAlleleLikelihoodMap> stratifiedPerReadAlleleLikelihoodMap, VariantContext vc) {
        if (stratifiedPerReadAlleleLikelihoodMap == null) {
            return null;
        }
        int mq0 = 0;
        for (PerReadAlleleLikelihoodMap likelihoodMap : stratifiedPerReadAlleleLikelihoodMap.values()) {
            for (GATKSAMRecord read : likelihoodMap.getLikelihoodReadMap().keySet()) {
                if (read.getMappingQuality() != 0) continue;
                ++mq0;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%d", mq0));
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("MQ0");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(VCFStandardHeaderLines.getInfoLine(this.getKeyNames().get(0)));
    }
}

