/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.GenotypeAnnotation;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFFormatHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;

public class MappingQualityZeroBySample
extends GenotypeAnnotation {
    @Override
    public void annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, AlignmentContext stratifiedContext, VariantContext vc, Genotype g, GenotypeBuilder gb, PerReadAlleleLikelihoodMap alleleLikelihoodMap) {
        if (g == null || !g.isCalled() || stratifiedContext == null) {
            return;
        }
        int mq0 = 0;
        ReadBackedPileup pileup = stratifiedContext.getBasePileup();
        for (PileupElement p : pileup) {
            if (p.getMappingQual() != 0) continue;
            ++mq0;
        }
        gb.attribute(this.getKeyNames().get(0), mq0);
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("MQ0");
    }

    @Override
    public List<VCFFormatHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFFormatHeaderLine(this.getKeyNames().get(0), 1, VCFHeaderLineType.Integer, "Number of Mapping Quality Zero Reads per sample"));
    }
}

