/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.AverageAltAlleleLength;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class QualByDepth
extends InfoFieldAnnotation
implements StandardAnnotation,
ActiveRegionBasedAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, Map<String, PerReadAlleleLikelihoodMap> perReadAlleleLikelihoodMap) {
        if (!vc.hasLog10PError()) {
            return null;
        }
        GenotypesContext genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.size() == 0) {
            return null;
        }
        int depth = 0;
        for (Genotype genotype : genotypes) {
            PerReadAlleleLikelihoodMap perReadAlleleLikelihoods;
            if (!genotype.isHet() && !genotype.isHomVar()) continue;
            if (stratifiedContexts != null) {
                AlignmentContext context = stratifiedContexts.get(genotype.getSampleName());
                if (context == null) continue;
                depth += context.getBasePileup().depthOfCoverage();
                continue;
            }
            if (perReadAlleleLikelihoodMap == null || (perReadAlleleLikelihoods = perReadAlleleLikelihoodMap.get(genotype.getSampleName())) == null || perReadAlleleLikelihoods.isEmpty()) continue;
            depth += perReadAlleleLikelihoods.getNumberOfStoredElements();
        }
        if (depth == 0) {
            return null;
        }
        double altAlleleLength = AverageAltAlleleLength.getMeanAltAlleleLength(vc);
        double QD = -10.0 * vc.getLog10PError() / ((double)depth * altAlleleLength);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%.2f", QD));
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("QD");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(this.getKeyNames().get(0), 1, VCFHeaderLineType.Float, "Variant Confidence/Quality by Depth"));
    }
}

