/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.MannWhitneyU;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFHeaderLine;

public abstract class RankSumTest
extends InfoFieldAnnotation
implements ActiveRegionBasedAnnotation {
    static final boolean DEBUG = false;
    private boolean useDithering = true;

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, Map<String, PerReadAlleleLikelihoodMap> stratifiedPerReadAlleleLikelihoodMap) {
        GenotypesContext genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.size() == 0) {
            return null;
        }
        ArrayList<Double> refQuals = new ArrayList<Double>();
        ArrayList<Double> altQuals = new ArrayList<Double>();
        for (Genotype genotype : genotypes.iterateInSampleNameOrder()) {
            AlignmentContext context;
            PerReadAlleleLikelihoodMap indelLikelihoodMap = null;
            ReadBackedPileup pileup = null;
            if (stratifiedContexts != null && (context = stratifiedContexts.get(genotype.getSampleName())) != null) {
                pileup = context.getBasePileup();
            }
            if (stratifiedPerReadAlleleLikelihoodMap != null) {
                indelLikelihoodMap = stratifiedPerReadAlleleLikelihoodMap.get(genotype.getSampleName());
            }
            if (indelLikelihoodMap != null && indelLikelihoodMap.isEmpty()) {
                indelLikelihoodMap = null;
            }
            if (indelLikelihoodMap == null && pileup == null) continue;
            this.fillQualsFromPileup(vc.getAlleles(), vc.getStart(), pileup, indelLikelihoodMap, refQuals, altQuals);
        }
        if (refQuals.isEmpty() && altQuals.isEmpty()) {
            return null;
        }
        MannWhitneyU mannWhitneyU = new MannWhitneyU(this.useDithering);
        for (Double qual : altQuals) {
            mannWhitneyU.add(qual, MannWhitneyU.USet.SET1);
        }
        for (Double qual : refQuals) {
            mannWhitneyU.add(qual, MannWhitneyU.USet.SET2);
        }
        Pair<Double, Double> testResults = mannWhitneyU.runOneSidedTest(MannWhitneyU.USet.SET1);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!Double.isNaN((Double)testResults.first)) {
            map.put(this.getKeyNames().get(0), String.format("%.3f", testResults.first));
        }
        return map;
    }

    protected abstract void fillQualsFromPileup(List<Allele> var1, int var2, ReadBackedPileup var3, PerReadAlleleLikelihoodMap var4, List<Double> var5, List<Double> var6);

    public static boolean isUsableBase(PileupElement p) {
        return RankSumTest.isUsableBase(p, false);
    }

    public static boolean isUsableBase(PileupElement p, boolean allowDeletions) {
        return (allowDeletions || !p.isDeletion()) && p.getMappingQual() != 0 && p.getMappingQual() != 255 && p.getQual() >= 6;
    }

    @Override
    public void initialize(AnnotatorCompatible walker, GenomeAnalysisEngine toolkit, Set<VCFHeaderLine> headerLines) {
        this.useDithering = !toolkit.getArguments().disableRandomization;
    }
}

