/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.recalibration.ReadCovariates;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public final class ReadRecalibrationInfo {
    private final GATKSAMRecord read;
    private final int length;
    private final ReadCovariates covariates;
    private final boolean[] skips;
    private final byte[] baseQuals;
    private final byte[] insertionQuals;
    private final byte[] deletionQuals;
    private final double[] snpErrors;
    private final double[] insertionErrors;
    private final double[] deletionErrors;

    public ReadRecalibrationInfo(GATKSAMRecord read, ReadCovariates covariates, boolean[] skips, double[] snpErrors, double[] insertionErrors, double[] deletionErrors) {
        if (read == null) {
            throw new IllegalArgumentException("read cannot be null");
        }
        if (covariates == null) {
            throw new IllegalArgumentException("covariates cannot be null");
        }
        if (skips == null) {
            throw new IllegalArgumentException("skips cannot be null");
        }
        if (snpErrors == null) {
            throw new IllegalArgumentException("snpErrors cannot be null");
        }
        if (insertionErrors == null) {
            throw new IllegalArgumentException("insertionErrors cannot be null");
        }
        if (deletionErrors == null) {
            throw new IllegalArgumentException("deletionErrors cannot be null");
        }
        this.read = read;
        this.baseQuals = read.getBaseQualities();
        this.length = this.baseQuals.length;
        this.covariates = covariates;
        this.skips = skips;
        this.insertionQuals = read.getExistingBaseInsertionQualities();
        this.deletionQuals = read.getExistingBaseDeletionQualities();
        this.snpErrors = snpErrors;
        this.insertionErrors = insertionErrors;
        this.deletionErrors = deletionErrors;
        if (skips.length != this.length) {
            throw new IllegalArgumentException("skips.length " + snpErrors.length + " != length " + this.length);
        }
        if (snpErrors.length != this.length) {
            throw new IllegalArgumentException("snpErrors.length " + snpErrors.length + " != length " + this.length);
        }
        if (insertionErrors.length != this.length) {
            throw new IllegalArgumentException("insertionErrors.length " + snpErrors.length + " != length " + this.length);
        }
        if (deletionErrors.length != this.length) {
            throw new IllegalArgumentException("deletionErrors.length " + snpErrors.length + " != length " + this.length);
        }
    }

    @Requires(value={"validOffset(offset)"})
    @Ensures(value={"validQual(result)"})
    public byte getQual(EventType eventType, int offset) {
        switch (eventType) {
            case BASE_SUBSTITUTION: {
                return this.baseQuals[offset];
            }
            case BASE_INSERTION: {
                return this.insertionQuals == null ? (byte)45 : this.insertionQuals[offset];
            }
            case BASE_DELETION: {
                return this.deletionQuals == null ? (byte)45 : this.deletionQuals[offset];
            }
        }
        throw new IllegalStateException("Unknown event type " + (Object)((Object)eventType));
    }

    @Requires(value={"validOffset(offset)"})
    @Ensures(value={"result >= 0.0 && result <= 1.0"})
    public double getErrorFraction(EventType eventType, int offset) {
        switch (eventType) {
            case BASE_SUBSTITUTION: {
                return this.snpErrors[offset];
            }
            case BASE_INSERTION: {
                return this.insertionErrors[offset];
            }
            case BASE_DELETION: {
                return this.deletionErrors[offset];
            }
        }
        throw new IllegalStateException("Unknown event type " + (Object)((Object)eventType));
    }

    @Ensures(value={"result != null"})
    public GATKSAMRecord getRead() {
        return this.read;
    }

    @Requires(value={"validOffset(offset)"})
    public boolean skip(int offset) {
        return this.skips[offset];
    }

    @Ensures(value={"result != null"})
    public ReadCovariates getCovariatesValues() {
        return this.covariates;
    }

    private boolean validOffset(int offset) {
        return offset >= 0 && offset < this.baseQuals.length;
    }

    private boolean validQual(byte result) {
        return result >= 0 && result <= 93;
    }
}

