/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import com.google.java.contract.Requires;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.sting.gatk.walkers.bqsr.ReadRecalibrationInfo;
import org.broadinstitute.sting.utils.collections.NestedIntegerArray;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.recalibration.ReadCovariates;
import org.broadinstitute.sting.utils.recalibration.RecalDatum;
import org.broadinstitute.sting.utils.recalibration.RecalUtils;
import org.broadinstitute.sting.utils.recalibration.RecalibrationTables;
import org.broadinstitute.sting.utils.recalibration.covariates.Covariate;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class RecalibrationEngine {
    protected final Covariate[] covariates;
    private final int numReadGroups;
    private final PrintStream maybeLogStream;
    private final boolean lowMemoryMode;
    private boolean finalized = false;
    private RecalibrationTables finalRecalibrationTables = null;
    private final List<RecalibrationTables> recalibrationTablesList = new LinkedList<RecalibrationTables>();
    private final ThreadLocal<RecalibrationTables> threadLocalTables = new ThreadLocal<RecalibrationTables>(){

        private synchronized RecalibrationTables makeAndCaptureTable() {
            RecalibrationTables newTable = new RecalibrationTables(RecalibrationEngine.this.covariates, RecalibrationEngine.this.numReadGroups, RecalibrationEngine.this.maybeLogStream);
            RecalibrationEngine.this.recalibrationTablesList.add(newTable);
            return newTable;
        }

        @Override
        protected synchronized RecalibrationTables initialValue() {
            if (RecalibrationEngine.this.lowMemoryMode) {
                return RecalibrationEngine.this.recalibrationTablesList.isEmpty() ? this.makeAndCaptureTable() : (RecalibrationTables)RecalibrationEngine.this.recalibrationTablesList.get(0);
            }
            return this.makeAndCaptureTable();
        }
    };

    protected RecalibrationTables getUpdatableRecalibrationTables() {
        return this.threadLocalTables.get();
    }

    public RecalibrationEngine(Covariate[] covariates, int numReadGroups, PrintStream maybeLogStream, boolean enableLowMemoryMode) {
        if (covariates == null) {
            throw new IllegalArgumentException("Covariates cannot be null");
        }
        if (numReadGroups < 1) {
            throw new IllegalArgumentException("numReadGroups must be >= 1 but got " + numReadGroups);
        }
        this.covariates = (Covariate[])covariates.clone();
        this.numReadGroups = numReadGroups;
        this.maybeLogStream = maybeLogStream;
        this.lowMemoryMode = enableLowMemoryMode;
    }

    @Requires(value={"recalInfo != null"})
    public void updateDataForRead(ReadRecalibrationInfo recalInfo) {
        GATKSAMRecord read = recalInfo.getRead();
        ReadCovariates readCovariates = recalInfo.getCovariatesValues();
        RecalibrationTables tables = this.getUpdatableRecalibrationTables();
        NestedIntegerArray<RecalDatum> qualityScoreTable = tables.getQualityScoreTable();
        for (int offset = 0; offset < read.getReadBases().length; ++offset) {
            if (recalInfo.skip(offset)) continue;
            for (EventType eventType : EventType.values()) {
                int[] keys = readCovariates.getKeySet(offset, eventType);
                int eventIndex = eventType.ordinal();
                byte qual = recalInfo.getQual(eventType, offset);
                double isError = recalInfo.getErrorFraction(eventType, offset);
                RecalUtils.incrementDatumOrPutIfNecessary(qualityScoreTable, qual, isError, keys[0], keys[1], eventIndex);
                for (int i = 2; i < this.covariates.length; ++i) {
                    if (keys[i] < 0) continue;
                    RecalUtils.incrementDatumOrPutIfNecessary(tables.getTable(i), qual, isError, keys[0], keys[1], keys[i], eventIndex);
                }
            }
        }
    }

    public void finalizeData() {
        if (this.finalized) {
            throw new IllegalStateException("FinalizeData() has already been called");
        }
        this.finalRecalibrationTables = this.mergeThreadLocalRecalibrationTables();
        NestedIntegerArray<RecalDatum> byReadGroupTable = this.finalRecalibrationTables.getReadGroupTable();
        NestedIntegerArray<RecalDatum> byQualTable = this.finalRecalibrationTables.getQualityScoreTable();
        for (NestedIntegerArray.Leaf<RecalDatum> leaf : byQualTable.getAllLeaves()) {
            int rgKey = leaf.keys[0];
            int eventIndex = leaf.keys[2];
            RecalDatum rgDatum = byReadGroupTable.get(rgKey, eventIndex);
            RecalDatum qualDatum = (RecalDatum)leaf.value;
            if (rgDatum == null) {
                byReadGroupTable.put(new RecalDatum(qualDatum), rgKey, eventIndex);
                continue;
            }
            rgDatum.combine(qualDatum);
        }
        this.finalized = true;
    }

    @Requires(value={"! finalized"})
    private RecalibrationTables mergeThreadLocalRecalibrationTables() {
        if (this.recalibrationTablesList.isEmpty()) {
            throw new IllegalStateException("recalibration tables list is empty");
        }
        RecalibrationTables merged = null;
        for (RecalibrationTables table : this.recalibrationTablesList) {
            if (merged == null) {
                merged = table;
                continue;
            }
            merged.combine(table);
        }
        return merged;
    }

    public RecalibrationTables getFinalRecalibrationTables() {
        if (!this.finalized) {
            throw new IllegalStateException("Cannot get final recalibration tables until finalizeData() has been called");
        }
        return this.finalRecalibrationTables;
    }
}

