/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.compression.reducereads;

import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public enum BaseIndex {
    A('A', 0),
    C('C', 1),
    G('G', 2),
    T('T', 3),
    D('D', 4),
    I('I', 5),
    N('N', 6);

    final byte b;
    final int index;

    public byte getByte() {
        return this.b;
    }

    public byte getOrdinalByte() {
        return (byte)this.ordinal();
    }

    private BaseIndex(char base, int index) {
        this.b = (byte)base;
        this.index = index;
    }

    public static BaseIndex byteToBase(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return A;
            }
            case 67: 
            case 99: {
                return C;
            }
            case 71: 
            case 103: {
                return G;
            }
            case 84: 
            case 116: {
                return T;
            }
            case 45: 
            case 68: 
            case 100: {
                return D;
            }
            case 73: 
            case 105: {
                return I;
            }
            case 78: 
            case 110: {
                return N;
            }
        }
        throw new ReviewedStingException("Tried to create a byte index for an impossible base " + base);
    }

    public boolean isNucleotide() {
        return !this.isIndel();
    }

    public boolean isIndel() {
        return this == D || this == I;
    }
}

