/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics.targets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.picard.util.PeekableIterator;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.CallableStatus;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.IntervalStatistics;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.SampleStatistics;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.ThresHolder;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.vcf.VCFHeader;

@DocumentedGATKFeature(groupName="Diagnostics and Quality Control Tools", extraDocs={CommandLineGATK.class})
@By(value=DataSource.READS)
@PartitionBy(value=PartitionType.INTERVAL)
public class DiagnoseTargets
extends LocusWalker<Long, Long> {
    @Output(doc="File to which variants should be written", required=true)
    private VariantContextWriter vcfWriter = null;
    @Argument(fullName="minimum_base_quality", shortName="BQ", doc="The minimum Base Quality that is considered for calls", required=false)
    private int minimumBaseQuality = 20;
    @Argument(fullName="minimum_mapping_quality", shortName="MQ", doc="The minimum read mapping quality considered for calls", required=false)
    private int minimumMappingQuality = 20;
    @Argument(fullName="minimum_coverage", shortName="min", doc="The minimum allowable coverage, used for calling LOW_COVERAGE", required=false)
    private int minimumCoverage = 5;
    @Argument(fullName="maximum_coverage", shortName="max", doc="The maximum allowable coverage, used for calling EXCESSIVE_COVERAGE", required=false)
    private int maximumCoverage = 700;
    @Argument(fullName="minimum_median_depth", shortName="med", doc="The minimum allowable median coverage, used for calling LOW_MEDIAN_DEPTH", required=false)
    private int minMedianDepth = 10;
    @Argument(fullName="maximum_insert_size", shortName="ins", doc="The maximum allowed distance between a read and its mate", required=false)
    private int maxInsertSize = 500;
    @Argument(fullName="voting_status_threshold", shortName="stV", doc="The needed percentage of samples containing a call for the interval to adopt the call ", required=false)
    private double votePercentage = 0.5;
    @Argument(fullName="low_median_depth_status_threshold", shortName="stMED", doc="The percentage of the loci needed for calling LOW_MEDIAN_DEPTH", required=false)
    private double lowMedianDepthPercentage = 0.2;
    @Argument(fullName="bad_mate_status_threshold", shortName="stBM", doc="The percentage of the loci needed for calling BAD_MATE", required=false)
    private double badMateStatusThreshold = 0.5;
    @Argument(fullName="coverage_status_threshold", shortName="stC", doc="The percentage of the loci needed for calling LOW_COVERAGE and COVERAGE_GAPS", required=false)
    private double coverageStatusThreshold = 0.2;
    @Argument(fullName="excessive_coverage_status_threshold", shortName="stXC", doc="The percentage of the loci needed for calling EXCESSIVE_COVERAGE", required=false)
    private double excessiveCoverageThreshold = 0.2;
    @Argument(fullName="quality_status_threshold", shortName="stQ", doc="The percentage of the loci needed for calling POOR_QUALITY", required=false)
    private double qualityStatusThreshold = 0.5;
    @Argument(fullName="print_debug_log", shortName="dl", doc="Used only for debugging the walker. Prints extra info to screen", required=false)
    private boolean debug = false;
    private HashMap<GenomeLoc, IntervalStatistics> intervalMap = null;
    private PeekableIterator<GenomeLoc> intervalListIterator;
    private Set<String> samples = null;
    private final Allele SYMBOLIC_ALLELE = Allele.create("<DT>", false);
    private ThresHolder thresholds = null;

    @Override
    public void initialize() {
        super.initialize();
        if (this.getToolkit().getIntervals() == null) {
            throw new UserException("This tool only works if you provide one or more intervals. ( Use the -L argument )");
        }
        this.thresholds = new ThresHolder(this.minimumBaseQuality, this.minimumMappingQuality, this.minimumCoverage, this.maximumCoverage, this.minMedianDepth, this.maxInsertSize, this.votePercentage, this.lowMedianDepthPercentage, this.badMateStatusThreshold, this.coverageStatusThreshold, this.excessiveCoverageThreshold, this.qualityStatusThreshold);
        this.intervalMap = new HashMap();
        this.intervalListIterator = new PeekableIterator<GenomeLoc>(this.getToolkit().getIntervals().iterator());
        this.samples = SampleUtils.getSAMFileSamples(this.getToolkit().getSAMFileHeader());
        this.vcfWriter.writeHeader(new VCFHeader(ThresHolder.getHeaderInfo(), this.samples));
    }

    @Override
    public Long map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        GenomeLoc refLocus = ref.getLocus();
        this.removePastIntervals(refLocus, ref.getBase());
        this.addNewOverlappingIntervals(refLocus);
        for (IntervalStatistics intervalStatistics : this.intervalMap.values()) {
            intervalStatistics.addLocus(context, ref, this.thresholds);
        }
        return 1L;
    }

    @Override
    public Long reduceInit() {
        return 0L;
    }

    @Override
    public Long reduce(Long value, Long sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Long result) {
        for (GenomeLoc interval : this.intervalMap.keySet()) {
            this.outputStatsToVCF(this.intervalMap.get(interval), Allele.create("A", true));
        }
    }

    private GenomeLoc getIntervalMapSpan() {
        GenomeLoc loc = null;
        for (GenomeLoc interval : this.intervalMap.keySet()) {
            if (loc == null) {
                loc = interval;
                continue;
            }
            loc = interval.union(loc);
        }
        return loc;
    }

    private GenomeLoc getFinishedIntervalSpan(GenomeLoc pos) {
        GenomeLoc loc = null;
        for (GenomeLoc interval : this.intervalMap.keySet()) {
            if (!interval.isBefore(pos)) continue;
            if (loc == null) {
                loc = interval;
                continue;
            }
            loc = interval.union(loc);
        }
        return loc;
    }

    private void removePastIntervals(GenomeLoc refLocus, byte refBase) {
        if (this.getFinishedIntervalSpan(refLocus) != null && this.getIntervalMapSpan().getStart() == this.getFinishedIntervalSpan(refLocus).getStart()) {
            for (GenomeLoc interval : this.intervalMap.keySet()) {
                if (!interval.isBefore(refLocus)) continue;
                this.outputStatsToVCF(this.intervalMap.get(interval), Allele.create(refBase, true));
                this.intervalMap.remove(interval);
            }
        }
    }

    private void addNewOverlappingIntervals(GenomeLoc refLocus) {
        GenomeLoc interval = this.intervalListIterator.peek();
        while (interval != null && interval.isBefore(refLocus)) {
            this.intervalListIterator.next();
            interval = this.intervalListIterator.peek();
        }
        while (interval != null && !interval.isPast(refLocus)) {
            this.intervalMap.put(interval, this.createIntervalStatistic(interval));
            this.intervalListIterator.next();
            interval = this.intervalListIterator.peek();
        }
    }

    private void outputStatsToVCF(IntervalStatistics stats, Allele refAllele) {
        GenomeLoc interval = stats.getInterval();
        ArrayList<Allele> alleles = new ArrayList<Allele>();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        ArrayList<Genotype> genotypes = new ArrayList<Genotype>();
        alleles.add(refAllele);
        alleles.add(this.SYMBOLIC_ALLELE);
        VariantContextBuilder vcb = new VariantContextBuilder("DiagnoseTargets", interval.getContig(), interval.getStart(), interval.getStop(), alleles);
        vcb = vcb.log10PError(1.0);
        vcb.filters(new HashSet<String>(this.statusesToStrings(stats.callableStatuses(this.thresholds), true)));
        attributes.put("END", interval.getStop());
        attributes.put("AVG_INTERVAL_DP", stats.averageCoverage());
        vcb = vcb.attributes(attributes);
        if (this.debug) {
            System.out.printf("Output -- Interval: %s, Coverage: %.2f%n", stats.getInterval(), stats.averageCoverage());
        }
        for (String sample : this.samples) {
            GenotypeBuilder gb = new GenotypeBuilder(sample);
            SampleStatistics sampleStat = stats.getSample(sample);
            gb.attribute("AVG_INTERVAL_DP", sampleStat.averageCoverage());
            gb.attribute("Q1", sampleStat.getQuantileDepth(0.25));
            gb.attribute("MED", sampleStat.getQuantileDepth(0.5));
            gb.attribute("Q3", sampleStat.getQuantileDepth(0.75));
            if (this.debug) {
                System.out.printf("Found %d bad mates out of %d reads %n", sampleStat.getnBadMates(), sampleStat.getnReads());
            }
            gb.filters(this.statusesToStrings(stats.getSample(sample).getCallableStatuses(this.thresholds), false));
            genotypes.add(gb.make());
        }
        vcb = vcb.genotypes(genotypes);
        this.vcfWriter.add(vcb.make());
    }

    private List<String> statusesToStrings(Set<CallableStatus> statuses, boolean includePASS) {
        ArrayList<String> output = new ArrayList<String>(statuses.size());
        for (CallableStatus status : statuses) {
            if (!includePASS && status == CallableStatus.PASS) continue;
            output.add(status.name());
        }
        return output;
    }

    private IntervalStatistics createIntervalStatistic(GenomeLoc interval) {
        return new IntervalStatistics(this.samples, interval);
    }
}

