/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics.targets;

import java.io.PrintStream;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionTraversalParameters;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionWalker;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.ThresHolder;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.activeregion.ActiveRegion;
import org.broadinstitute.sting.utils.activeregion.ActivityProfileState;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;

@DocumentedGATKFeature(groupName="Diagnostics and Quality Control Tools", extraDocs={CommandLineGATK.class})
@PartitionBy(value=PartitionType.CONTIG)
@ActiveRegionTraversalParameters(extension=0, maxRegion=50000)
public class FindCoveredIntervals
extends ActiveRegionWalker<GenomeLoc, Long> {
    @Output(required=true)
    private PrintStream out;
    @Argument(fullName="uncovered", shortName="u", required=false, doc="output intervals that fail the coverage threshold instead")
    private boolean outputUncovered = false;
    @Argument(fullName="coverage_threshold", shortName="cov", doc="The minimum allowable coverage to be considered covered", required=false)
    private int coverageThreshold = 20;

    @Override
    public ActivityProfileState isActive(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        int depth = ThresHolder.DEFAULTS.getFilteredCoverage(context.getBasePileup());
        return new ActivityProfileState(ref.getLocus(), Math.min(depth / this.coverageThreshold, 1));
    }

    @Override
    public GenomeLoc map(ActiveRegion activeRegion, RefMetaDataTracker tracker) {
        if (!this.outputUncovered && activeRegion.isActive() || this.outputUncovered && !activeRegion.isActive()) {
            return activeRegion.getLocation();
        }
        return null;
    }

    @Override
    public Long reduceInit() {
        return 0L;
    }

    @Override
    public Long reduce(GenomeLoc value, Long reduce) {
        if (value != null) {
            this.out.println(value.toString());
            Long l = reduce;
            Long l2 = reduce = Long.valueOf(reduce + 1L);
        }
        return reduce;
    }

    @Override
    public void onTraversalDone(Long reduce) {
        logger.info(String.format("Found %d intervals", reduce));
    }
}

