/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diffengine;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportColumn;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffElement;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffNode;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffableReader;

public class GATKReportDiffableReader
implements DiffableReader {
    @Override
    public String getName() {
        return "GATKReport";
    }

    @Override
    public DiffElement readFromFile(File file, int maxElementsToRead) {
        DiffNode root = DiffNode.rooted(file.getName());
        try {
            GATKReport report = new GATKReport(file);
            for (GATKReportTable table : report.getTables()) {
                root.add(this.tableToNode(table, root));
            }
            return root.getBinding();
        }
        catch (Exception e) {
            return null;
        }
    }

    private DiffNode tableToNode(GATKReportTable table, DiffNode root) {
        DiffNode tableRoot = DiffNode.empty(table.getTableName(), root);
        tableRoot.add("Description", table.getTableDescription());
        tableRoot.add("NumberOfRows", table.getNumRows());
        for (GATKReportColumn column : table.getColumnInfo()) {
            DiffNode columnRoot = DiffNode.empty(column.getColumnName(), tableRoot);
            columnRoot.add("Width", column.getColumnFormat().getWidth());
            columnRoot.add("Displayable", true);
            for (int i = 0; i < table.getNumRows(); ++i) {
                String name = column.getColumnName() + (i + 1);
                columnRoot.add(name, table.get(i, column.getColumnName()).toString());
            }
            tableRoot.add(columnRoot);
        }
        return tableRoot;
    }

    @Override
    public boolean canRead(File file) {
        try {
            String HEADER = "#:GATKReport.";
            char[] buff = new char["#:GATKReport.".length()];
            FileReader FR = new FileReader(file);
            FR.read(buff, 0, "#:GATKReport.".length());
            FR.close();
            String firstLine = new String(buff);
            return firstLine.startsWith("#:GATKReport.");
        }
        catch (IOException e) {
            return false;
        }
    }
}

