/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import com.google.java.contract.Requires;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.walkers.genotyper.IndelGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.ProbabilityVector;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.indels.PairHMMIndelErrorModel;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class ErrorModel {
    private byte maxQualityScore;
    private byte minQualityScore;
    private byte phredScaledPrior;
    private double log10minPower;
    private int refDepth;
    private boolean hasData = false;
    private ProbabilityVector probabilityVector;
    private static final boolean compressRange = false;
    private static final double log10MinusE = Math.log10(Math.exp(1.0));
    private static final boolean DEBUG = false;

    public ErrorModel(UnifiedArgumentCollection UAC, ReadBackedPileup refSamplePileup, VariantContext refSampleVC, ReferenceContext refContext) {
        this.maxQualityScore = UAC.maxQualityScore;
        this.minQualityScore = UAC.minQualityScore;
        this.phredScaledPrior = UAC.phredScaledPrior;
        this.log10minPower = Math.log10(UAC.minPower);
        PairHMMIndelErrorModel pairModel = null;
        LinkedHashMap<Allele, Haplotype> haplotypeMap = null;
        double[][] perReadLikelihoods = null;
        double[] model = new double[this.maxQualityScore + 1];
        Arrays.fill(model, Double.NEGATIVE_INFINITY);
        boolean hasCalledAlleles = false;
        PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap = new PerReadAlleleLikelihoodMap();
        if (refSampleVC != null) {
            for (Allele allele : refSampleVC.getAlleles()) {
                if (!allele.isCalled()) continue;
                hasCalledAlleles = true;
                break;
            }
            haplotypeMap = new LinkedHashMap<Allele, Haplotype>();
            if (refSampleVC.isIndel()) {
                pairModel = new PairHMMIndelErrorModel(UAC.INDEL_GAP_OPEN_PENALTY, UAC.INDEL_GAP_CONTINUATION_PENALTY, UAC.OUTPUT_DEBUG_INDEL_INFO, UAC.pairHMM);
                IndelGenotypeLikelihoodsCalculationModel.getHaplotypeMapFromAlleles(refSampleVC.getAlleles(), refContext, refContext.getLocus(), haplotypeMap);
            }
        }
        double p = QualityUtils.qualToErrorProbLog10((byte)(this.maxQualityScore - this.minQualityScore));
        if (refSamplePileup == null || refSampleVC == null || !hasCalledAlleles) {
            for (byte q = this.minQualityScore; q <= this.maxQualityScore; q = (byte)(q + 1)) {
                model[q] = p;
            }
            this.refDepth = 0;
        } else {
            this.hasData = true;
            int matches = 0;
            int coverage = 0;
            Allele refAllele = refSampleVC.getReference();
            if (refSampleVC.isIndel()) {
                int[] readCounts = new int[refSamplePileup.getNumberOfElements()];
                int eventLength = IndelGenotypeLikelihoodsCalculationModel.getEventLength(refSampleVC.getAlleles());
                if (!haplotypeMap.isEmpty()) {
                    perReadLikelihoods = pairModel.computeGeneralReadHaplotypeLikelihoods(refSamplePileup, haplotypeMap, refContext, eventLength, perReadAlleleLikelihoodMap, readCounts);
                }
            }
            int idx = 0;
            for (PileupElement refPileupElement : refSamplePileup) {
                double[] perAlleleLikelihoods;
                boolean isMatch = false;
                for (Allele allele : refSampleVC.getAlleles()) {
                    boolean m = ErrorModel.pileupElementMatches(refPileupElement, allele, refAllele, refContext.getBase());
                    isMatch |= m;
                }
                matches = refSampleVC.isIndel() && !haplotypeMap.isEmpty() ? (!this.isInformativeElement(perAlleleLikelihoods = perReadLikelihoods[idx++]) ? ++matches : (matches += isMatch ? 1 : 0)) : (matches += isMatch ? 1 : 0);
                ++coverage;
            }
            int mismatches = coverage - matches;
            for (byte q = this.minQualityScore; q <= this.maxQualityScore; q = (byte)(q + 1)) {
                model[q] = coverage == 0 ? p : this.log10PoissonProbabilitySiteGivenQual(q, coverage, mismatches);
            }
            this.refDepth = coverage;
        }
        this.probabilityVector = new ProbabilityVector(model, false);
    }

    @Requires(value={"likelihoods.length>0"})
    private boolean isInformativeElement(double[] likelihoods) {
        int minIdx;
        double thresh = 0.1;
        int maxIdx = MathUtils.maxElementIndex(likelihoods);
        return !(likelihoods[maxIdx] - likelihoods[minIdx = MathUtils.minElementIndex(likelihoods)] < 0.1);
    }

    public ErrorModel(double[] pvector) {
        this.maxQualityScore = (byte)(pvector.length - 1);
        this.minQualityScore = 0;
        this.probabilityVector = new ProbabilityVector(pvector, false);
        this.hasData = true;
    }

    public static boolean pileupElementMatches(PileupElement pileupElement, Allele allele, Allele refAllele, byte refBase) {
        if (allele.isReference()) {
            if (allele.getBases().length > 0) {
                return pileupElement.getBase() == refBase && !pileupElement.isBeforeInsertion() && !pileupElement.isBeforeDeletionStart();
            }
            return !pileupElement.isBeforeInsertion() && !pileupElement.isBeforeDeletionStart();
        }
        if (refAllele.getBases().length == allele.getBases().length) {
            return pileupElement.getBase() == allele.getBases()[0];
        }
        byte[] alleleBases = allele.getBases();
        int eventLength = alleleBases.length - refAllele.getBases().length;
        if (eventLength < 0 && pileupElement.isBeforeDeletionStart() && pileupElement.getLengthOfImmediatelyFollowingIndel() == -eventLength) {
            return true;
        }
        return eventLength > 0 && pileupElement.isBeforeInsertion() && Arrays.equals(pileupElement.getBasesOfImmediatelyFollowingInsertion().getBytes(), Arrays.copyOfRange(alleleBases, 1, alleleBases.length));
    }

    @Requires(value={"q >= minQualityScore", "q <= maxQualityScore", "coverage >= 0", "mismatches >= 0", "mismatches <= coverage"})
    private double log10PoissonProbabilitySiteGivenQual(byte q, int coverage, int mismatches) {
        double lambda = QualityUtils.qualToErrorProb(q) * (double)coverage;
        return Math.log10(lambda) * (double)mismatches - lambda * log10MinusE - MathUtils.log10Factorial(mismatches);
    }

    @Requires(value={"qual-minQualityScore <= maxQualityScore"})
    public double getSiteLogErrorProbabilityGivenQual(int qual) {
        return this.probabilityVector.getLogProbabilityForIndex(qual);
    }

    public byte getMaxQualityScore() {
        return this.maxQualityScore;
    }

    public byte getMinQualityScore() {
        return this.minQualityScore;
    }

    public int getMinSignificantQualityScore() {
        return new ProbabilityVector(this.probabilityVector, true).getMinVal();
    }

    public int getMaxSignificantQualityScore() {
        return new ProbabilityVector(this.probabilityVector, true).getMaxVal();
    }

    public int getReferenceDepth() {
        return this.refDepth;
    }

    public boolean hasData() {
        return this.hasData;
    }

    public ProbabilityVector getErrorModelVector() {
        return this.probabilityVector;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("(");
        boolean skipComma = true;
        for (double v : this.probabilityVector.getProbabilityVector()) {
            if (skipComma) {
                skipComma = false;
            } else {
                result.append(",");
            }
            result.append(String.format("%.4f", v));
        }
        result.append(")");
        return result.toString();
    }

    public static int getTotalReferenceDepth(HashMap<String, ErrorModel> perLaneErrorModels) {
        int n = 0;
        for (ErrorModel e : perLaneErrorModels.values()) {
            n += e.getReferenceDepth();
        }
        return n;
    }
}

