/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.genotyper.ErrorModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactACcounts;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactACset;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;

public abstract class GeneralPloidyGenotypeLikelihoods {
    protected final int numChromosomes;
    private static final double MAX_LOG10_ERROR_TO_STOP_EARLY = 6.0;
    protected static final boolean VERBOSE = false;
    protected static final double[] qualVec = new double[94];
    protected double[] log10Likelihoods;
    protected double[][] logMismatchProbabilityArray;
    protected final int nSamplesPerPool;
    protected final HashMap<String, ErrorModel> perLaneErrorModels;
    protected final int likelihoodDim;
    protected final boolean ignoreLaneInformation;
    protected final double LOG10_PLOIDY;
    protected boolean hasReferenceSampleData;
    protected final int nAlleles;
    protected final List<Allele> alleles;
    private static final double MIN_LIKELIHOOD = Double.NEGATIVE_INFINITY;
    private static final int MAX_NUM_ALLELES_TO_CACHE = 20;
    private static final int MAX_NUM_SAMPLES_PER_POOL = 1000;
    private static final boolean FAST_GL_COMPUTATION = true;
    private static final int[][] GenotypeLikelihoodVectorSizes = GeneralPloidyGenotypeLikelihoods.fillGLVectorSizeCache(20, 2000);

    public GeneralPloidyGenotypeLikelihoods(List<Allele> alleles, double[] logLikelihoods, int ploidy, HashMap<String, ErrorModel> perLaneErrorModels, boolean ignoreLaneInformation) {
        this.alleles = alleles;
        this.nAlleles = alleles.size();
        this.numChromosomes = ploidy;
        this.nSamplesPerPool = this.numChromosomes / 2;
        this.perLaneErrorModels = perLaneErrorModels;
        this.ignoreLaneInformation = ignoreLaneInformation;
        if (perLaneErrorModels == null || perLaneErrorModels.isEmpty()) {
            this.hasReferenceSampleData = false;
        } else {
            for (Map.Entry<String, ErrorModel> elt : perLaneErrorModels.entrySet()) {
                if (!elt.getValue().hasData()) continue;
                this.hasReferenceSampleData = true;
                break;
            }
        }
        if (this.nAlleles > 20) {
            throw new UserException("No support for this number of alleles");
        }
        if (this.nSamplesPerPool > 1000) {
            throw new UserException("No support for such large number of samples per pool");
        }
        this.likelihoodDim = GenotypeLikelihoods.numLikelihoods(this.nAlleles, this.numChromosomes);
        if (logLikelihoods == null) {
            this.log10Likelihoods = new double[this.likelihoodDim];
            Arrays.fill(this.log10Likelihoods, Double.NEGATIVE_INFINITY);
        } else {
            if (logLikelihoods.length != this.likelihoodDim) {
                throw new ReviewedStingException("BUG: inconsistent parameters when creating GeneralPloidyGenotypeLikelihoods object");
            }
            this.log10Likelihoods = logLikelihoods;
        }
        this.fillCache();
        this.LOG10_PLOIDY = Math.log10(this.numChromosomes);
    }

    public List<Allele> getAlleles() {
        return this.alleles;
    }

    public double[] getLikelihoods() {
        return this.log10Likelihoods;
    }

    public void setLogPLs(int idx, double pl) {
        this.log10Likelihoods[idx] = pl;
    }

    public void renormalize() {
        this.log10Likelihoods = MathUtils.normalizeFromLog10(this.log10Likelihoods, false, true);
    }

    public Pair<int[], Double> getMostLikelyACCount() {
        int[] mlInd = null;
        double maxVal = Double.NEGATIVE_INFINITY;
        SumIterator iterator = new SumIterator(this.alleles.size(), this.numChromosomes);
        int idx = 0;
        while (iterator.hasNext()) {
            int n = idx++;
            double pl = this.log10Likelihoods[n];
            if (pl > maxVal) {
                maxVal = pl;
                mlInd = (int[])iterator.getCurrentVector().clone();
            }
            iterator.next();
        }
        return new Pair<Object, Double>(mlInd, maxVal);
    }

    public static double[] subsetToAlleles(double[] oldLikelihoods, int numChromosomes, List<Allele> originalAlleles, List<Allele> allelesToSubset) {
        int newPLSize = GeneralPloidyGenotypeLikelihoods.getNumLikelihoodElements(allelesToSubset.size(), numChromosomes);
        double[] newPLs = new double[newPLSize];
        int idx = 0;
        boolean[] allelePresent = new boolean[originalAlleles.size()];
        for (Allele allele : originalAlleles) {
            allelePresent[idx++] = allelesToSubset.contains(allele);
        }
        int[] permutationKey = new int[allelesToSubset.size()];
        for (int k = 0; k < allelesToSubset.size(); ++k) {
            permutationKey[k] = originalAlleles.indexOf(allelesToSubset.get(k));
        }
        SumIterator iterator = new SumIterator(originalAlleles.size(), numChromosomes);
        while (iterator.hasNext()) {
            int[] pVec = iterator.getCurrentVector();
            double pl = oldLikelihoods[iterator.getLinearIndex()];
            boolean keyPresent = true;
            for (int k = 0; k < allelePresent.length; ++k) {
                if (pVec[k] <= 0 || allelePresent[k]) continue;
                keyPresent = false;
            }
            if (keyPresent) {
                int[] newCount = new int[allelesToSubset.size()];
                for (idx = 0; idx < newCount.length; ++idx) {
                    newCount[idx] = pVec[permutationKey[idx]];
                }
                int outputIdx = GeneralPloidyGenotypeLikelihoods.getLinearIndex(newCount, allelesToSubset.size(), numChromosomes);
                newPLs[outputIdx] = pl;
            }
            iterator.next();
        }
        return newPLs;
    }

    public static int getLinearIndex(int[] vectorIdx, int numAlleles, int ploidy) {
        if (ploidy <= 0) {
            return 0;
        }
        int linearIdx = 0;
        int cumSum = ploidy;
        for (int k = numAlleles - 1; k >= 1; --k) {
            int idx = vectorIdx[k];
            if (idx == 0) continue;
            for (int p = 0; p < idx; ++p) {
                linearIdx += GeneralPloidyGenotypeLikelihoods.getNumLikelihoodElements(k, cumSum - p);
            }
            cumSum -= idx;
        }
        return linearIdx;
    }

    public static int[] getAlleleCountFromPLIndex(int nAlleles, int numChromosomes, int PLindex) {
        SumIterator iterator = new SumIterator(nAlleles, numChromosomes);
        while (iterator.hasNext()) {
            int[] plVec = iterator.getCurrentVector();
            if (iterator.getLinearIndex() == PLindex) {
                return plVec;
            }
            iterator.next();
        }
        return null;
    }

    public static int getNumLikelihoodElements(int numAlleles, int ploidy) {
        return GenotypeLikelihoodVectorSizes[numAlleles][ploidy];
    }

    private static int[][] fillGLVectorSizeCache(int maxAlleles, int maxPloidy) {
        int[][] cache = new int[maxAlleles][maxPloidy];
        for (int numAlleles = 1; numAlleles < maxAlleles; ++numAlleles) {
            for (int ploidy = 0; ploidy < maxPloidy; ++ploidy) {
                if (numAlleles == 1) {
                    cache[numAlleles][ploidy] = 1;
                    continue;
                }
                if (ploidy == 1) {
                    cache[numAlleles][ploidy] = numAlleles;
                    continue;
                }
                int acc = 0;
                for (int k = 0; k <= ploidy; ++k) {
                    acc += cache[numAlleles - 1][ploidy - k];
                }
                cache[numAlleles][ploidy] = acc;
            }
        }
        return cache;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(1000);
        s.append("Alleles:");
        for (Allele a : this.alleles) {
            s.append(a.getDisplayString());
            s.append(",");
        }
        s.append("\nGLs:\n");
        SumIterator iterator = new SumIterator(this.nAlleles, this.numChromosomes);
        while (iterator.hasNext()) {
            if (!Double.isInfinite(this.getLikelihoods()[iterator.getLinearIndex()])) {
                s.append("Count [");
                StringBuilder b = new StringBuilder(iterator.getCurrentVector().length * 2);
                for (int it : iterator.getCurrentVector()) {
                    b.append(it);
                    b.append(",");
                }
                s.append(b.toString());
                s.append(String.format("] GL=%4.3f\n", this.getLikelihoods()[iterator.getLinearIndex()]));
            }
            iterator.next();
        }
        return s.toString();
    }

    public void computeLikelihoods(ErrorModel errorModel, List<Allele> alleleList, List<Integer> numObservations, ReadBackedPileup pileup) {
        LinkedList<ExactACset> ACqueue = new LinkedList<ExactACset>();
        HashMap<ExactACcounts, ExactACset> indexesToACset = new HashMap<ExactACcounts, ExactACset>(this.likelihoodDim);
        int[] zeroCounts = new int[this.nAlleles];
        zeroCounts[0] = this.numChromosomes;
        ExactACset zeroSet = new ExactACset(1, new ExactACcounts(zeroCounts));
        ACqueue.add(zeroSet);
        indexesToACset.put(zeroSet.getACcounts(), zeroSet);
        double maxLog10L = Double.NEGATIVE_INFINITY;
        while (!ACqueue.isEmpty()) {
            ExactACset ACset = (ExactACset)ACqueue.remove();
            double log10LofKs = this.calculateACConformationAndUpdateQueue(ACset, errorModel, alleleList, numObservations, maxLog10L, ACqueue, indexesToACset, pileup);
            maxLog10L = Math.max(maxLog10L, log10LofKs);
            indexesToACset.remove(ACset.getACcounts());
        }
        this.renormalize();
    }

    private double calculateACConformationAndUpdateQueue(ExactACset set, ErrorModel errorModel, List<Allele> alleleList, List<Integer> numObservations, double maxLog10L, LinkedList<ExactACset> ACqueue, HashMap<ExactACcounts, ExactACset> indexesToACset, ReadBackedPileup pileup) {
        this.getLikelihoodOfConformation(set, errorModel, alleleList, numObservations, pileup);
        double log10LofK = set.getLog10Likelihoods()[0];
        int idx = GeneralPloidyGenotypeLikelihoods.getLinearIndex(set.getACcounts().getCounts(), this.nAlleles, this.numChromosomes);
        this.setLogPLs(idx, log10LofK);
        if (log10LofK < maxLog10L - 6.0) {
            return log10LofK;
        }
        int ACwiggle = this.numChromosomes - set.getACsum() + set.getACcounts().getCounts()[0];
        if (ACwiggle == 0) {
            return log10LofK;
        }
        for (int allele = 1; allele < this.nAlleles; ++allele) {
            int[] ACcountsClone = (int[])set.getACcounts().getCounts().clone();
            int n = allele;
            ACcountsClone[n] = ACcountsClone[n] + 1;
            int altSum = (int)MathUtils.sum(ACcountsClone) - ACcountsClone[0];
            ACcountsClone[0] = this.numChromosomes - altSum;
            if (ACcountsClone[0] < 0) continue;
            GeneralPloidyGenotypeLikelihoods.updateACset(ACcountsClone, ACqueue, indexesToACset);
        }
        return log10LofK;
    }

    public abstract void getLikelihoodOfConformation(ExactACset var1, ErrorModel var2, List<Allele> var3, List<Integer> var4, ReadBackedPileup var5);

    public abstract int add(ReadBackedPileup var1, UnifiedArgumentCollection var2);

    public static void updateACset(int[] newSetCounts, LinkedList<ExactACset> ACqueue, HashMap<ExactACcounts, ExactACset> indexesToACset) {
        ExactACcounts index = new ExactACcounts(newSetCounts);
        if (!indexesToACset.containsKey(index)) {
            ExactACset newSet = new ExactACset(1, index);
            indexesToACset.put(index, newSet);
            ACqueue.add(newSet);
        }
    }

    private void fillCache() {
        this.logMismatchProbabilityArray = new double[1 + this.numChromosomes][94];
        for (int i = 0; i <= this.numChromosomes; ++i) {
            for (int j = 0; j <= 93; ++j) {
                double phi = (double)i / (double)this.numChromosomes;
                this.logMismatchProbabilityArray[i][j] = Math.log10(phi * (1.0 - qualVec[j]) + qualVec[j] / 3.0 * (1.0 - phi));
            }
        }
    }

    static {
        for (int j = 0; j <= 93; ++j) {
            GeneralPloidyGenotypeLikelihoods.qualVec[j] = Math.pow(10.0, -((double)j) / 10.0);
        }
    }

    public static class SumIterator {
        private int[] currentState;
        private final int[] finalState;
        private final int restrictSumTo;
        private final int dim;
        private boolean hasNext;
        private int linearIndex;
        private int currentSum;

        public SumIterator(int[] finalState, int restrictSumTo) {
            this.finalState = finalState;
            this.dim = finalState.length;
            this.restrictSumTo = restrictSumTo;
            this.currentState = new int[this.dim];
            this.reset();
        }

        public SumIterator(int numAlleles, int numChromosomes) {
            this(SumIterator.getInitialStateVector(numAlleles, numChromosomes), numChromosomes);
        }

        private static int[] getInitialStateVector(int nAlleles, int numChromosomes) {
            int[] initialState = new int[nAlleles];
            Arrays.fill(initialState, numChromosomes);
            return initialState;
        }

        public void setInitialStateVector(int[] stateVector) {
            if (this.restrictSumTo > 0) {
                if (MathUtils.sum(stateVector) != (long)this.restrictSumTo) {
                    throw new ReviewedStingException("BUG: initial state vector nor compatible with sum iterator");
                }
            } else {
                throw new ReviewedStingException("BUG: Not supported");
            }
            int numAlleles = this.currentState.length;
            int ploidy = this.restrictSumTo;
            this.linearIndex = GeneralPloidyGenotypeLikelihoods.getLinearIndex(stateVector, numAlleles, ploidy);
        }

        public void next() {
            int initialDim = this.restrictSumTo > 0 ? 1 : 0;
            this.hasNext = this.next(this.finalState, initialDim);
            if (this.hasNext) {
                ++this.linearIndex;
            }
        }

        private boolean next(int[] finalState, int initialDim) {
            boolean hasNextState = false;
            for (int currentDim = initialDim; currentDim < finalState.length; ++currentDim) {
                int x = this.currentState[currentDim] + 1;
                if (x > finalState[currentDim] || this.currentSum >= this.restrictSumTo && initialDim > 0) {
                    this.currentSum -= this.currentState[currentDim];
                    this.currentState[currentDim] = 0;
                    if (currentDim < this.dim - 1) continue;
                    hasNextState = false;
                    break;
                }
                this.currentState[currentDim] = x;
                hasNextState = true;
                ++this.currentSum;
                break;
            }
            if (initialDim > 0) {
                this.currentState[0] = this.restrictSumTo - this.currentSum;
            }
            return hasNextState;
        }

        public void reset() {
            Arrays.fill(this.currentState, 0);
            if (this.restrictSumTo > 0) {
                this.currentState[0] = this.restrictSumTo;
            }
            this.hasNext = true;
            this.linearIndex = 0;
            this.currentSum = 0;
        }

        public int[] getCurrentVector() {
            return this.currentState;
        }

        public int[] getCurrentAltVector() {
            return Arrays.copyOfRange(this.currentState, 1, this.currentState.length);
        }

        public int getLinearIndex() {
            return this.linearIndex;
        }

        public boolean hasNext() {
            return this.hasNext;
        }
    }
}

