/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.walkers.genotyper.ErrorModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GeneralPloidyGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.IndelGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactACset;
import org.broadinstitute.sting.gatk.walkers.indels.PairHMMIndelErrorModel;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.variant.variantcontext.Allele;

public class GeneralPloidyIndelGenotypeLikelihoods
extends GeneralPloidyGenotypeLikelihoods {
    final PairHMMIndelErrorModel pairModel;
    final LinkedHashMap<Allele, Haplotype> haplotypeMap;
    final ReferenceContext refContext;
    final int eventLength;
    double[][] readHaplotypeLikelihoods;
    final byte refBase;
    final PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap;

    public GeneralPloidyIndelGenotypeLikelihoods(List<Allele> alleles, double[] logLikelihoods, int ploidy, HashMap<String, ErrorModel> perLaneErrorModels, boolean ignoreLaneInformation, PairHMMIndelErrorModel pairModel, LinkedHashMap<Allele, Haplotype> haplotypeMap, ReferenceContext referenceContext, PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap) {
        super(alleles, logLikelihoods, ploidy, perLaneErrorModels, ignoreLaneInformation);
        this.pairModel = pairModel;
        this.haplotypeMap = haplotypeMap;
        this.refContext = referenceContext;
        this.eventLength = IndelGenotypeLikelihoodsCalculationModel.getEventLength(alleles);
        this.refBase = referenceContext.getBase();
        this.perReadAlleleLikelihoodMap = perReadAlleleLikelihoodMap;
    }

    @Override
    public int add(ReadBackedPileup pileup, UnifiedArgumentCollection UAC) {
        int n = 0;
        if (!this.hasReferenceSampleData) {
            return this.add(pileup, (ErrorModel)null);
        }
        for (String laneID : this.perLaneErrorModels.keySet()) {
            ReadBackedPileup perLanePileup = this.ignoreLaneInformation ? pileup : pileup.getPileupForLane(laneID);
            if (perLanePileup == null || perLanePileup.isEmpty()) continue;
            ErrorModel errorModel = (ErrorModel)this.perLaneErrorModels.get(laneID);
            n += this.add(perLanePileup, errorModel);
            if (!this.ignoreLaneInformation) continue;
            break;
        }
        return n;
    }

    private int add(ReadBackedPileup pileup, ErrorModel errorModel) {
        int n = 0;
        ArrayList<Integer> numSeenBases = new ArrayList<Integer>(this.alleles.size());
        if (!this.hasReferenceSampleData) {
            int[] readCounts = new int[pileup.getNumberOfElements()];
            this.readHaplotypeLikelihoods = this.pairModel.computeGeneralReadHaplotypeLikelihoods(pileup, this.haplotypeMap, this.refContext, this.eventLength, this.perReadAlleleLikelihoodMap, readCounts);
            n = this.readHaplotypeLikelihoods.length;
        } else {
            Allele refAllele = null;
            for (Allele a : this.alleles) {
                numSeenBases.add(0);
                if (!a.isReference()) continue;
                refAllele = a;
            }
            if (refAllele == null) {
                throw new ReviewedStingException("BUG: no ref alleles in passed in allele list!");
            }
            for (PileupElement elt : pileup) {
                int idx = 0;
                for (Allele allele : this.alleles) {
                    int cnt = (Integer)numSeenBases.get(idx);
                    numSeenBases.set(idx++, cnt + (ErrorModel.pileupElementMatches(elt, allele, refAllele, this.refBase) ? 1 : 0));
                }
                ++n;
            }
        }
        this.computeLikelihoods(errorModel, this.alleles, numSeenBases, pileup);
        return n;
    }

    @Override
    public void getLikelihoodOfConformation(ExactACset ACset, ErrorModel errorModel, List<Allele> alleleList, List<Integer> numObservations, ReadBackedPileup pileup) {
        int[] currentCnt = Arrays.copyOf(ACset.getACcounts().getCounts(), alleleList.size());
        double p1 = 0.0;
        if (!this.hasReferenceSampleData) {
            for (int i = 0; i < this.readHaplotypeLikelihoods.length; ++i) {
                double[] acc = new double[alleleList.size()];
                for (int k = 0; k < acc.length; ++k) {
                    acc[k] = this.readHaplotypeLikelihoods[i][k] + MathUtils.log10Cache[currentCnt[k]] - this.LOG10_PLOIDY;
                }
                p1 += MathUtils.log10sumLog10(acc);
            }
        } else {
            int minQ = errorModel.getMinSignificantQualityScore();
            int maxQ = errorModel.getMaxSignificantQualityScore();
            double[] acVec = new double[maxQ - minQ + 1];
            for (int k = minQ; k <= maxQ; ++k) {
                int idx = 0;
                for (int n : numObservations) {
                    int n2 = k - minQ;
                    acVec[n2] = acVec[n2] + (double)n * this.logMismatchProbabilityArray[currentCnt[idx++]][k];
                }
            }
            p1 = MathUtils.logDotProduct(errorModel.getErrorModelVector().getProbabilityVector(minQ, maxQ), acVec);
        }
        ACset.getLog10Likelihoods()[0] = p1;
    }
}

