/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.broadinstitute.sting.gatk.walkers.genotyper.ErrorModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GeneralPloidyGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.SNPGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactACset;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.variant.variantcontext.Allele;

public class GeneralPloidySNPGenotypeLikelihoods
extends GeneralPloidyGenotypeLikelihoods {
    final List<Allele> myAlleles;
    final int[] alleleIndices;
    final boolean useBAQedPileup;
    final byte refByte;
    int mbq;
    protected static final double[][][] qualLikelihoodCache = new double[BaseUtils.BASES.length][BaseUtils.BASES.length][94];

    public GeneralPloidySNPGenotypeLikelihoods(List<Allele> alleles, double[] logLikelihoods, int ploidy, HashMap<String, ErrorModel> perLaneErrorModels, boolean useBQAedPileup, boolean ignoreLaneInformation) {
        super(alleles, logLikelihoods, ploidy, perLaneErrorModels, ignoreLaneInformation);
        this.useBAQedPileup = useBQAedPileup;
        this.myAlleles = new ArrayList<Allele>(alleles);
        Allele refAllele = alleles.get(0);
        if (!refAllele.isReference()) {
            throw new ReviewedStingException("BUG: First allele in list passed to GeneralPloidySNPGenotypeLikelihoods should be reference!");
        }
        this.refByte = refAllele.getBases()[0];
        if (this.myAlleles.size() < BaseUtils.BASES.length) {
            for (byte b : BaseUtils.BASES) {
                boolean isRef;
                boolean bl = isRef = b == this.refByte;
                if (this.myAlleles.contains(Allele.create(b, isRef))) continue;
                this.myAlleles.add(Allele.create(b, isRef));
            }
        }
        int idx = 0;
        this.alleleIndices = new int[this.myAlleles.size()];
        for (byte b : BaseUtils.BASES) {
            boolean isRef = b == this.refByte;
            this.alleleIndices[idx++] = this.myAlleles.indexOf(Allele.create(b, isRef));
        }
    }

    @Override
    public int add(ReadBackedPileup pileup, UnifiedArgumentCollection UAC) {
        this.mbq = UAC.MIN_BASE_QUALTY_SCORE;
        return this.add(pileup, true, true, this.mbq);
    }

    public int add(ReadBackedPileup pileup, boolean ignoreBadBases, boolean capBaseQualsAtMappingQual, int minBaseQual) {
        int n = 0;
        if (this.useBAQedPileup) {
            pileup = this.createBAQedPileup(pileup);
        }
        if (!this.hasReferenceSampleData) {
            return this.add(pileup, ignoreBadBases, capBaseQualsAtMappingQual, minBaseQual, null);
        }
        for (String laneID : this.perLaneErrorModels.keySet()) {
            ReadBackedPileup perLanePileup = this.ignoreLaneInformation ? pileup : pileup.getPileupForLane(laneID);
            if (perLanePileup == null || perLanePileup.isEmpty()) continue;
            ErrorModel errorModel = (ErrorModel)this.perLaneErrorModels.get(laneID);
            n += this.add(perLanePileup, ignoreBadBases, capBaseQualsAtMappingQual, minBaseQual, errorModel);
            if (!this.ignoreLaneInformation) continue;
            break;
        }
        return n;
    }

    private int add(ReadBackedPileup pileup, boolean ignoreBadBases, boolean capBaseQualsAtMappingQual, int minBaseQual, ErrorModel errorModel) {
        ArrayList<Integer> numSeenBases = new ArrayList<Integer>(BaseUtils.BASES.length);
        for (byte b : BaseUtils.BASES) {
            numSeenBases.add(0);
        }
        if (this.hasReferenceSampleData) {
            for (PileupElement elt : pileup) {
                byte obsBase = elt.getBase();
                byte qual = GeneralPloidySNPGenotypeLikelihoods.qualToUse(elt, ignoreBadBases, capBaseQualsAtMappingQual, minBaseQual);
                if (qual == 0) continue;
                int idx = 0;
                for (byte base : BaseUtils.BASES) {
                    int cnt = (Integer)numSeenBases.get(idx);
                    numSeenBases.set(idx++, cnt + (base == obsBase ? 1 : 0));
                }
            }
        }
        this.computeLikelihoods(errorModel, this.myAlleles, numSeenBases, pileup);
        return pileup.getNumberOfElements();
    }

    @Override
    public void getLikelihoodOfConformation(ExactACset ACset, ErrorModel errorModel, List<Allele> alleleList, List<Integer> numObservations, ReadBackedPileup pileup) {
        int[] currentCnt = Arrays.copyOf(ACset.getACcounts().getCounts(), BaseUtils.BASES.length);
        int[] ac = new int[BaseUtils.BASES.length];
        for (int k = 0; k < BaseUtils.BASES.length; ++k) {
            ac[k] = currentCnt[this.alleleIndices[k]];
        }
        double p1 = 0.0;
        if (!this.hasReferenceSampleData) {
            for (PileupElement elt : pileup) {
                byte obsBase = elt.getBase();
                byte qual = GeneralPloidySNPGenotypeLikelihoods.qualToUse(elt, true, true, this.mbq);
                if (qual == 0) continue;
                double[] acc = new double[ACset.getACcounts().getCounts().length];
                for (int k = 0; k < acc.length; ++k) {
                    acc[k] = qualLikelihoodCache[BaseUtils.simpleBaseToBaseIndex(alleleList.get(k).getBases()[0])][BaseUtils.simpleBaseToBaseIndex(obsBase)][qual] + MathUtils.log10Cache[ACset.getACcounts().getCounts()[k]] - this.LOG10_PLOIDY;
                }
                p1 += MathUtils.log10sumLog10(acc);
            }
        } else {
            int minQ = errorModel.getMinSignificantQualityScore();
            int maxQ = errorModel.getMaxSignificantQualityScore();
            double[] acVec = new double[maxQ - minQ + 1];
            int nA = numObservations.get(0);
            int nC = numObservations.get(1);
            int nG = numObservations.get(2);
            int nT = numObservations.get(3);
            for (int k = minQ; k <= maxQ; ++k) {
                acVec[k - minQ] = (double)nA * this.logMismatchProbabilityArray[ac[0]][k] + (double)nC * this.logMismatchProbabilityArray[ac[1]][k] + (double)nG * this.logMismatchProbabilityArray[ac[2]][k] + (double)nT * this.logMismatchProbabilityArray[ac[3]][k];
            }
            p1 = MathUtils.logDotProduct(errorModel.getErrorModelVector().getProbabilityVector(minQ, maxQ), acVec);
        }
        ACset.getLog10Likelihoods()[0] = p1;
    }

    public ReadBackedPileup createBAQedPileup(ReadBackedPileup pileup) {
        ArrayList<PileupElement> BAQedElements = new ArrayList<PileupElement>();
        for (PileupElement PE : pileup) {
            SNPGenotypeLikelihoodsCalculationModel.BAQedPileupElement newPE = new SNPGenotypeLikelihoodsCalculationModel.BAQedPileupElement(PE);
            BAQedElements.add(newPE);
        }
        return new ReadBackedPileupImpl(pileup.getLocation(), BAQedElements);
    }

    private static byte qualToUse(PileupElement p, boolean ignoreBadBases, boolean capBaseQualsAtMappingQual, int minBaseQual) {
        if (ignoreBadBases && !BaseUtils.isRegularBase(p.getBase())) {
            return 0;
        }
        byte qual = p.getQual();
        if (qual > 93) {
            throw new UserException.MalformedBAM(p.getRead(), String.format("the maximum allowed quality score is %d, but a quality of %d was observed in read %s.  Perhaps your BAM incorrectly encodes the quality scores in Sanger format; see http://en.wikipedia.org/wiki/FASTQ_format for more details", 93, qual, p.getRead().getReadName()));
        }
        if (capBaseQualsAtMappingQual) {
            qual = (byte)Math.min(qual, p.getMappingQual());
        }
        if (qual < minBaseQual) {
            qual = 0;
        }
        return qual;
    }

    private static double log10PofObservingBaseGivenChromosome(byte observedBase, byte chromBase, byte qual) {
        double logP;
        double log10_3 = Math.log10(3.0);
        if (observedBase == chromBase) {
            double e = Math.pow(10.0, (double)qual / -10.0);
            logP = Math.log10(1.0 - e);
        } else {
            logP = (double)qual / -10.0 + -log10_3;
        }
        return logP;
    }

    static {
        for (byte j = 0; j <= 93; j = (byte)((byte)(j + 1))) {
            for (byte b1 : BaseUtils.BASES) {
                for (byte b2 : BaseUtils.BASES) {
                    GeneralPloidySNPGenotypeLikelihoods.qualLikelihoodCache[BaseUtils.simpleBaseToBaseIndex((byte)b1)][BaseUtils.simpleBaseToBaseIndex((byte)b2)][j] = GeneralPloidySNPGenotypeLikelihoods.log10PofObservingBaseGivenChromosome(b1, b2, j);
                }
            }
        }
    }
}

