/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypePriors;
import org.broadinstitute.sting.utils.MathUtils;

public class PoolGenotypePriors
implements GenotypePriors {
    private final double[] flatPriors;
    private final double heterozygosity;
    private final int samplesPerPool;
    private double[] priors = null;

    public PoolGenotypePriors(double heterozygosity, int samplesPerPool) {
        this.flatPriors = new double[2 * samplesPerPool + 1];
        for (int k = 0; k < this.flatPriors.length; ++k) {
            this.flatPriors[k] = Math.log10(heterozygosity);
        }
        this.priors = (double[])this.flatPriors.clone();
        this.samplesPerPool = samplesPerPool;
        this.heterozygosity = heterozygosity;
    }

    @Override
    public double[] getPriors() {
        return this.priors;
    }

    @Override
    public double getHeterozygosity() {
        return this.heterozygosity;
    }

    public int getNSamplesPerPool() {
        return this.samplesPerPool;
    }

    @Override
    public boolean validate(boolean throwException) {
        try {
            for (int i = 0; i < this.priors.length; ++i) {
                if (MathUtils.wellFormedDouble(this.priors[i]) && MathUtils.isNegativeOrZero(this.priors[i])) continue;
                String bad = String.format("Prior %f is badly formed %b", this.priors[i], MathUtils.isNegativeOrZero(this.priors[i]));
                throw new IllegalStateException(String.format("At %d: %s", i, bad));
            }
        }
        catch (IllegalStateException e) {
            if (throwException) {
                throw new RuntimeException(e);
            }
            return false;
        }
        return true;
    }
}

