/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.Arrays;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ProbabilityVector {
    private final double[] probabilityArray;
    private final int minVal;
    private final int maxVal;
    static final double LOG_DYNAMIC_RANGE = 10.0;

    public ProbabilityVector(double[] vec, boolean compressRange) {
        int maxValIdx = MathUtils.maxElementIndex(vec);
        double maxv = vec[maxValIdx];
        if (maxv > 0.0) {
            throw new ReviewedStingException("BUG: Attempting to create a log-probability vector with positive elements");
        }
        if (compressRange) {
            this.minVal = ProbabilityVector.getMinIdx(vec, maxValIdx);
            this.maxVal = ProbabilityVector.getMaxIdx(vec, maxValIdx);
            this.probabilityArray = Arrays.copyOfRange(vec, this.minVal, this.maxVal + 1);
        } else {
            this.probabilityArray = vec;
            this.minVal = 0;
            this.maxVal = vec.length - 1;
        }
    }

    public ProbabilityVector(double[] vec) {
        this(vec, true);
    }

    public ProbabilityVector(ProbabilityVector other, boolean compressRange) {
        this(other.getUncompressedProbabilityVector(), compressRange);
    }

    public int getMinVal() {
        return this.minVal;
    }

    public int getMaxVal() {
        return this.maxVal;
    }

    public double[] getProbabilityVector() {
        return this.probabilityArray;
    }

    public double[] getProbabilityVector(int minVal, int maxVal) {
        double[] x = new double[maxVal - minVal + 1];
        for (int k = minVal; k <= maxVal; ++k) {
            x[k - minVal] = this.getLogProbabilityForIndex(k);
        }
        return x;
    }

    public double[] getUncompressedProbabilityVector() {
        int i;
        double[] x = new double[this.maxVal + 1];
        for (i = 0; i < this.minVal; ++i) {
            x[i] = Double.NEGATIVE_INFINITY;
        }
        for (i = this.minVal; i <= this.maxVal; ++i) {
            x[i] = this.probabilityArray[i - this.minVal];
        }
        return x;
    }

    public double getLogProbabilityForIndex(int idx) {
        if (idx < this.minVal || idx > this.maxVal) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.probabilityArray[idx - this.minVal];
    }

    public static ProbabilityVector compressVector(double[] vec) {
        return new ProbabilityVector(vec, true);
    }

    private static int getMinIdx(double[] vec, int maxValIdx) {
        int edgeIdx;
        for (edgeIdx = 0; edgeIdx <= maxValIdx && !(vec[edgeIdx] > vec[maxValIdx] - 10.0); ++edgeIdx) {
        }
        return edgeIdx;
    }

    private static int getMaxIdx(double[] vec, int maxValIdx) {
        int edgeIdx;
        for (edgeIdx = vec.length - 1; edgeIdx >= maxValIdx && !(vec[edgeIdx] > vec[maxValIdx] - 10.0); --edgeIdx) {
        }
        return edgeIdx;
    }

    public double logDotProduct(ProbabilityVector other) {
        int maxRange;
        int minRange = Math.max(this.minVal, other.getMinVal());
        if (minRange > (maxRange = Math.min(this.maxVal, other.getMaxVal()))) {
            return Double.NEGATIVE_INFINITY;
        }
        double[] result = new double[maxRange - minRange + 1];
        for (int k = 0; k <= maxRange - minRange; ++k) {
            int startI = minRange - this.minVal;
            int startJ = minRange - other.getMinVal();
            result[k] = this.probabilityArray[k + startI] + other.probabilityArray[k + startJ];
        }
        return MathUtils.approximateLog10SumLog10(result);
    }
}

