/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidSNPGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.genotyper.DiploidGenotype;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public class SNPGenotypeLikelihoodsCalculationModel
extends GenotypeLikelihoodsCalculationModel {
    private final boolean useAlleleFromVCF;
    private final double[] likelihoodSums = new double[4];
    private final PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap;

    protected SNPGenotypeLikelihoodsCalculationModel(UnifiedArgumentCollection UAC, Logger logger) {
        super(UAC, logger);
        this.useAlleleFromVCF = UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES;
        this.perReadAlleleLikelihoodMap = new PerReadAlleleLikelihoodMap();
    }

    @Override
    public VariantContext getLikelihoods(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, List<Allele> allAllelesToUse, boolean useBAQedPileup, GenomeLocParser locParser, Map<String, PerReadAlleleLikelihoodMap> sampleLikelihoodMap) {
        sampleLikelihoodMap.clear();
        byte refBase = ref.getBase();
        int indexOfRefBase = BaseUtils.simpleBaseToBaseIndex(refBase);
        if (indexOfRefBase == -1) {
            return null;
        }
        Allele refAllele = Allele.create(refBase, true);
        ArrayList<SampleGenotypeData> GLs = new ArrayList<SampleGenotypeData>(contexts.size());
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            DiploidSNPGenotypeLikelihoods GL;
            int nGoodBases;
            ReadBackedPileup pileup = AlignmentContextUtils.stratify(sample.getValue(), contextType).getBasePileup();
            Double contamination = this.UAC.getSampleContamination().get(sample.getKey());
            if (contamination > 0.0) {
                pileup = this.perReadAlleleLikelihoodMap.createPerAlleleDownsampledBasePileup(pileup, contamination, this.UAC.contaminationLog);
            }
            if (useBAQedPileup) {
                pileup = this.createBAQedPileup(pileup);
            }
            if ((nGoodBases = (GL = new DiploidSNPGenotypeLikelihoods(this.UAC.PCR_error)).add(pileup, true, true, this.UAC.MIN_BASE_QUALTY_SCORE)) <= 0) continue;
            GLs.add(new SampleGenotypeData(sample.getKey(), GL, this.getFilteredDepth(pileup)));
        }
        GenomeLoc loc = ref.getLocus();
        ArrayList<Allele> alleles = new ArrayList<Allele>();
        alleles.add(refAllele);
        VariantContextBuilder builder = new VariantContextBuilder("UG_call", loc.getContig(), loc.getStart(), loc.getStop(), alleles);
        if (allAllelesToUse != null) {
            alleles.addAll(allAllelesToUse.subList(1, allAllelesToUse.size()));
        } else if (this.useAlleleFromVCF) {
            VariantContext vc = UnifiedGenotyperEngine.getVCFromAllelesRod(tracker, ref, ref.getLocus(), true, this.logger, this.UAC.alleles);
            if (vc == null || !vc.isSNP()) {
                return null;
            }
            if (vc.hasAlternateAllele(refAllele, true)) {
                throw new UserException.BadInput("Alternate allele '" + (char)refBase + "' passed in is the same as the reference at location " + vc.getChr() + ":" + vc.getStart());
            }
            alleles.addAll(vc.getAlternateAlleles());
        } else {
            alleles.addAll(this.determineAlternateAlleles(refBase, GLs));
            if (alleles.size() == 1) {
                if (this.UAC.OutputMode == UnifiedGenotyperEngine.OUTPUT_MODE.EMIT_VARIANTS_ONLY) {
                    return builder.make();
                }
                alleles.add(Allele.create(BaseUtils.baseIndexToSimpleBase(indexOfRefBase == 0 ? 1 : 0)));
            }
        }
        int numAlleles = alleles.size();
        int numAltAlleles = numAlleles - 1;
        int[] alleleOrdering = new int[numAlleles];
        int alleleOrderingIndex = 0;
        int numLikelihoods = 0;
        for (Allele allele : alleles) {
            alleleOrdering[alleleOrderingIndex++] = BaseUtils.simpleBaseToBaseIndex(allele.getBases()[0]);
            numLikelihoods += alleleOrderingIndex;
        }
        builder.alleles((Collection<Allele>)alleles);
        int[] PLordering = new int[numLikelihoods];
        for (int i = 0; i <= numAltAlleles; ++i) {
            for (int j = i; j <= numAltAlleles; ++j) {
                PLordering[j * (j + 1) / 2 + i] = DiploidGenotype.createDiploidGenotype(alleleOrdering[i], alleleOrdering[j]).ordinal();
            }
        }
        GenotypesContext genotypes = GenotypesContext.create();
        for (SampleGenotypeData sampleData : GLs) {
            double[] allLikelihoods = sampleData.GL.getLikelihoods();
            double[] myLikelihoods = new double[numLikelihoods];
            for (int i = 0; i < numLikelihoods; ++i) {
                myLikelihoods[i] = allLikelihoods[PLordering[i]];
            }
            GenotypeBuilder gb = new GenotypeBuilder(sampleData.name);
            double[] genotypeLikelihoods = MathUtils.normalizeFromLog10(myLikelihoods, false, true);
            gb.PL(genotypeLikelihoods);
            gb.DP(sampleData.depth);
            genotypes.add(gb.make());
        }
        return builder.genotypes(genotypes).make();
    }

    protected List<Allele> determineAlternateAlleles(byte ref, List<SampleGenotypeData> sampleDataList) {
        int baseIndexOfRef = BaseUtils.simpleBaseToBaseIndex(ref);
        int PLindexOfRef = DiploidGenotype.createDiploidGenotype(ref, ref).ordinal();
        for (int i = 0; i < 4; ++i) {
            this.likelihoodSums[i] = 0.0;
        }
        for (SampleGenotypeData sampleData : sampleDataList) {
            double[] likelihoods = sampleData.GL.getLikelihoods();
            int PLindexOfBestGL = MathUtils.maxElementIndex(likelihoods);
            if (PLindexOfBestGL == PLindexOfRef) continue;
            GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair(PLindexOfBestGL);
            if (alleles.alleleIndex1 != baseIndexOfRef) {
                int n = alleles.alleleIndex1;
                this.likelihoodSums[n] = this.likelihoodSums[n] + (likelihoods[PLindexOfBestGL] - likelihoods[PLindexOfRef]);
            }
            if (alleles.alleleIndex2 == baseIndexOfRef || alleles.alleleIndex2 == alleles.alleleIndex1) continue;
            int n = alleles.alleleIndex2;
            this.likelihoodSums[n] = this.likelihoodSums[n] + (likelihoods[PLindexOfBestGL] - likelihoods[PLindexOfRef]);
        }
        ArrayList<Allele> allelesToUse = new ArrayList<Allele>(3);
        for (int i = 0; i < 4; ++i) {
            if (!(this.likelihoodSums[i] > 0.0)) continue;
            allelesToUse.add(Allele.create(BaseUtils.baseIndexToSimpleBase(i), false));
        }
        return allelesToUse;
    }

    public ReadBackedPileup createBAQedPileup(ReadBackedPileup pileup) {
        ArrayList<PileupElement> BAQedElements = new ArrayList<PileupElement>();
        for (PileupElement PE : pileup) {
            BAQedPileupElement newPE = new BAQedPileupElement(PE);
            BAQedElements.add(newPE);
        }
        return new ReadBackedPileupImpl(pileup.getLocation(), BAQedElements);
    }

    private static class SampleGenotypeData {
        public final String name;
        public final DiploidSNPGenotypeLikelihoods GL;
        public final int depth;

        public SampleGenotypeData(String name, DiploidSNPGenotypeLikelihoods GL, int depth) {
            this.name = name;
            this.GL = GL;
            this.depth = depth;
        }
    }

    public static class BAQedPileupElement
    extends PileupElement {
        public BAQedPileupElement(PileupElement PE) {
            super(PE);
        }

        @Override
        public byte getQual() {
            if (this.isDeletion()) {
                return super.getQual();
            }
            return BAQ.calcBAQFromTag((SAMRecord)this.getRead(), this.offset, true);
        }
    }
}

