/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.VariantCallContext;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalc;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcFactory;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcResult;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public class UnifiedGenotyperEngine {
    public static final String LOW_QUAL_FILTER_NAME = "LowQual";
    private static final String GPSTRING = "GENERALPLOIDY";
    public static final String NUMBER_OF_DISCOVERED_ALLELES_KEY = "NDA";
    public static final double HUMAN_SNP_HETEROZYGOSITY = 0.001;
    public static final double HUMAN_INDEL_HETEROZYGOSITY = 1.0E-4;
    private final UnifiedArgumentCollection UAC;
    private final VariantAnnotatorEngine annotationEngine;
    private ThreadLocal<Map<String, GenotypeLikelihoodsCalculationModel>> glcm = new ThreadLocal();
    private final List<GenotypeLikelihoodsCalculationModel.Model> modelsToUse = new ArrayList<GenotypeLikelihoodsCalculationModel.Model>(2);
    private ThreadLocal<AFCalc> afcm = new ThreadLocal();
    private final double[] log10AlleleFrequencyPriorsSNPs;
    private final double[] log10AlleleFrequencyPriorsIndels;
    private final Set<String> samples;
    private final Logger logger;
    private final PrintStream verboseWriter;
    private final int ploidy;
    private final int N;
    private static final Set<String> filter = new HashSet<String>(1);
    private final GenomeLocParser genomeLocParser;
    private final boolean BAQEnabledOnCMDLine;
    private static final double[] binomialProbabilityDepthCache = new double[10000];
    private static final double REF_BINOMIAL_PROB_LOG10_0_5 = Math.log10(0.5);

    public UnifiedArgumentCollection getUAC() {
        return this.UAC;
    }

    @Requires(value={"toolkit != null", "UAC != null"})
    public UnifiedGenotyperEngine(GenomeAnalysisEngine toolkit, UnifiedArgumentCollection UAC) {
        this(toolkit, UAC, Logger.getLogger(UnifiedGenotyperEngine.class), null, null, SampleUtils.getSAMFileSamples(toolkit.getSAMFileHeader()), 2);
    }

    protected UnifiedGenotyperEngine(GenomeAnalysisEngine toolkit, Set<String> samples, UnifiedArgumentCollection UAC) {
        this(toolkit, UAC, Logger.getLogger(UnifiedGenotyperEngine.class), null, null, samples, 2);
    }

    @Requires(value={"toolkit != null", "UAC != null", "logger != null", "samples != null && samples.size() > 0", "ploidy>0"})
    public UnifiedGenotyperEngine(GenomeAnalysisEngine toolkit, UnifiedArgumentCollection UAC, Logger logger, PrintStream verboseWriter, VariantAnnotatorEngine engine, Set<String> samples, int ploidy) {
        this.BAQEnabledOnCMDLine = toolkit.getArguments().BAQMode != BAQ.CalculationMode.OFF;
        this.genomeLocParser = toolkit.getGenomeLocParser();
        this.samples = new TreeSet<String>(samples);
        this.UAC = UAC;
        this.logger = logger;
        this.verboseWriter = verboseWriter;
        this.annotationEngine = engine;
        this.ploidy = ploidy;
        this.N = samples.size() * ploidy;
        this.log10AlleleFrequencyPriorsSNPs = new double[this.N + 1];
        this.log10AlleleFrequencyPriorsIndels = new double[this.N + 1];
        UnifiedGenotyperEngine.computeAlleleFrequencyPriors(this.N, this.log10AlleleFrequencyPriorsSNPs, UAC.heterozygosity);
        UnifiedGenotyperEngine.computeAlleleFrequencyPriors(this.N, this.log10AlleleFrequencyPriorsIndels, UAC.INDEL_HETEROZYGOSITY);
        filter.add(LOW_QUAL_FILTER_NAME);
        this.determineGLModelsToUse();
    }

    public List<VariantCallContext> calculateLikelihoodsAndGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        return this.calculateLikelihoodsAndGenotypes(tracker, refContext, rawContext, null);
    }

    public List<VariantCallContext> calculateLikelihoodsAndGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext, Set<String> allSamples) {
        ArrayList<VariantCallContext> results = new ArrayList<VariantCallContext>(2);
        List<GenotypeLikelihoodsCalculationModel.Model> models = this.getGLModelsToUse(tracker, refContext, rawContext);
        HashMap<String, PerReadAlleleLikelihoodMap> perReadAlleleLikelihoodMap = new HashMap<String, PerReadAlleleLikelihoodMap>();
        if (models.isEmpty()) {
            results.add(this.UAC.OutputMode == OUTPUT_MODE.EMIT_ALL_SITES && this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES ? this.generateEmptyContext(tracker, refContext, null, rawContext) : null);
        } else {
            for (GenotypeLikelihoodsCalculationModel.Model model : models) {
                perReadAlleleLikelihoodMap.clear();
                Map<String, AlignmentContext> stratifiedContexts = this.getFilteredAndStratifiedContexts(this.UAC, refContext, rawContext, model);
                if (stratifiedContexts == null) {
                    results.add(this.UAC.OutputMode == OUTPUT_MODE.EMIT_ALL_SITES && this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES ? this.generateEmptyContext(tracker, refContext, null, rawContext) : null);
                    continue;
                }
                VariantContext vc = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.COMPLETE, null, true, model, perReadAlleleLikelihoodMap);
                if (vc == null) continue;
                results.add(this.calculateGenotypes(tracker, refContext, rawContext, stratifiedContexts, vc, model, true, perReadAlleleLikelihoodMap));
            }
        }
        return results;
    }

    public VariantContext calculateLikelihoods(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext, Map<String, PerReadAlleleLikelihoodMap> perReadAlleleLikelihoodMap) {
        List<GenotypeLikelihoodsCalculationModel.Model> models = this.getGLModelsToUse(tracker, refContext, rawContext);
        if (models.isEmpty()) {
            return null;
        }
        for (GenotypeLikelihoodsCalculationModel.Model model : models) {
            Map<String, AlignmentContext> stratifiedContexts = this.getFilteredAndStratifiedContexts(this.UAC, refContext, rawContext, model);
            if (stratifiedContexts == null) continue;
            return this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.COMPLETE, null, true, model, perReadAlleleLikelihoodMap);
        }
        return null;
    }

    public VariantCallContext calculateGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext, VariantContext vc) {
        List<GenotypeLikelihoodsCalculationModel.Model> models = this.getGLModelsToUse(tracker, refContext, rawContext);
        if (models.isEmpty()) {
            return null;
        }
        GenotypeLikelihoodsCalculationModel.Model model = models.get(0);
        Map<String, AlignmentContext> stratifiedContexts = this.getFilteredAndStratifiedContexts(this.UAC, refContext, rawContext, model);
        return this.calculateGenotypes(tracker, refContext, rawContext, stratifiedContexts, vc, model, null);
    }

    public VariantCallContext calculateGenotypes(VariantContext vc) {
        return this.calculateGenotypes(null, null, null, null, vc, GenotypeLikelihoodsCalculationModel.Model.valueOf("SNP"), null);
    }

    private VariantContext calculateLikelihoods(RefMetaDataTracker tracker, ReferenceContext refContext, Map<String, AlignmentContext> stratifiedContexts, AlignmentContextUtils.ReadOrientation type, List<Allele> alternateAllelesToUse, boolean useBAQedPileup, GenotypeLikelihoodsCalculationModel.Model model, Map<String, PerReadAlleleLikelihoodMap> perReadAlleleLikelihoodMap) {
        if (this.glcm.get() == null) {
            this.glcm.set(UnifiedGenotyperEngine.getGenotypeLikelihoodsCalculationObject(this.logger, this.UAC));
        }
        return this.glcm.get().get(model.name()).getLikelihoods(tracker, refContext, stratifiedContexts, type, alternateAllelesToUse, useBAQedPileup && this.BAQEnabledOnCMDLine, this.genomeLocParser, perReadAlleleLikelihoodMap);
    }

    private VariantCallContext generateEmptyContext(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, AlignmentContext rawContext) {
        VariantContext vc;
        if (this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            VariantContext vcInput = UnifiedGenotyperEngine.getVCFromAllelesRod(tracker, ref, rawContext.getLocation(), false, this.logger, this.UAC.alleles);
            if (vcInput == null) {
                return null;
            }
            vc = new VariantContextBuilder("UG_call", ref.getLocus().getContig(), vcInput.getStart(), vcInput.getEnd(), vcInput.getAlleles()).make();
        } else {
            if (!Allele.acceptableAlleleBases(new byte[]{ref.getBase()})) {
                return null;
            }
            HashSet<Allele> alleles = new HashSet<Allele>();
            alleles.add(Allele.create(ref.getBase(), true));
            vc = new VariantContextBuilder("UG_call", ref.getLocus().getContig(), ref.getLocus().getStart(), ref.getLocus().getStart(), alleles).make();
        }
        if (this.annotationEngine != null) {
            ReadBackedPileup pileup = rawContext.getBasePileup();
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup);
            vc = this.annotationEngine.annotateContext(tracker, ref, stratifiedContexts, vc);
        }
        return new VariantCallContext(vc, false);
    }

    public VariantCallContext calculateGenotypes(VariantContext vc, GenotypeLikelihoodsCalculationModel.Model model, Map<String, PerReadAlleleLikelihoodMap> perReadAlleleLikelihoodMap) {
        return this.calculateGenotypes(null, null, null, null, vc, model, perReadAlleleLikelihoodMap);
    }

    public VariantCallContext calculateGenotypes(VariantContext vc, GenotypeLikelihoodsCalculationModel.Model model) {
        return this.calculateGenotypes(null, null, null, null, vc, model, null);
    }

    public VariantCallContext calculateGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, GenotypeLikelihoodsCalculationModel.Model model, Map<String, PerReadAlleleLikelihoodMap> perReadAlleleLikelihoodMap) {
        return this.calculateGenotypes(tracker, refContext, rawContext, stratifiedContexts, vc, model, false, perReadAlleleLikelihoodMap);
    }

    public VariantCallContext calculateGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, GenotypeLikelihoodsCalculationModel.Model model, boolean inheritAttributesFromInputVC, Map<String, PerReadAlleleLikelihoodMap> perReadAlleleLikelihoodMap) {
        boolean limitedContext;
        boolean bl = limitedContext = tracker == null || refContext == null || rawContext == null || stratifiedContexts == null;
        if (this.afcm.get() == null) {
            this.afcm.set(AFCalcFactory.createAFCalc(this.UAC, this.N, this.logger));
        }
        if (vc.getNSamples() == 0) {
            if (limitedContext) {
                return null;
            }
            return this.UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES ? this.estimateReferenceConfidence(vc, stratifiedContexts, this.getTheta(model), false, 1.0) : this.generateEmptyContext(tracker, refContext, stratifiedContexts, rawContext);
        }
        AFCalcResult AFresult = this.afcm.get().getLog10PNonRef(vc, this.getAlleleFrequencyPriors(model));
        boolean bestGuessIsRef = true;
        ArrayList<Allele> myAlleles = new ArrayList<Allele>(vc.getAlleles().size());
        ArrayList<Integer> alleleCountsofMLE = new ArrayList<Integer>(vc.getAlleles().size());
        myAlleles.add(vc.getReference());
        for (int i = 0; i < AFresult.getAllelesUsedInGenotyping().size(); ++i) {
            Allele alternateAllele = AFresult.getAllelesUsedInGenotyping().get(i);
            if (alternateAllele.isReference()) continue;
            boolean isNonRef = AFresult.isPolymorphicPhredScaledQual(alternateAllele, this.UAC.STANDARD_CONFIDENCE_FOR_EMITTING);
            if (isNonRef) {
                myAlleles.add(alternateAllele);
                alleleCountsofMLE.add(AFresult.getAlleleCountAtMLE(alternateAllele));
                bestGuessIsRef = false;
                continue;
            }
            if (this.UAC.GenotypingMode != GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) continue;
            myAlleles.add(alternateAllele);
            alleleCountsofMLE.add(AFresult.getAlleleCountAtMLE(alternateAllele));
        }
        double PoFGT0 = Math.pow(10.0, AFresult.getLog10PosteriorOfAFGT0());
        double phredScaledConfidence = Math.abs(!bestGuessIsRef || this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES ? -10.0 * AFresult.getLog10PosteriorOfAFEq0() : -10.0 * AFresult.getLog10PosteriorOfAFGT0());
        if (this.UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES && !this.passesEmitThreshold(phredScaledConfidence, bestGuessIsRef)) {
            return limitedContext ? null : this.estimateReferenceConfidence(vc, stratifiedContexts, this.getTheta(model), true, PoFGT0);
        }
        GenomeLoc loc = this.genomeLocParser.createGenomeLoc(vc);
        VariantContextBuilder builder = new VariantContextBuilder("UG_call", loc.getContig(), loc.getStart(), loc.getStop(), myAlleles);
        builder.log10PError(phredScaledConfidence / -10.0);
        if (!this.passesCallThreshold(phredScaledConfidence)) {
            builder.filters(filter);
        }
        GenotypesContext genotypes = this.afcm.get().subsetAlleles(vc, myAlleles, true, this.ploidy);
        builder.genotypes(genotypes);
        if (this.verboseWriter != null && !limitedContext) {
            this.printVerboseData(refContext.getLocus().toString(), vc, PoFGT0, phredScaledConfidence, model);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (inheritAttributesFromInputVC) {
            attributes.putAll(vc.getAttributes());
        }
        if (!limitedContext && rawContext.hasPileupBeenDownsampled()) {
            attributes.put("DS", true);
        }
        if (this.UAC.ANNOTATE_NUMBER_OF_ALLELES_DISCOVERED) {
            attributes.put(NUMBER_OF_DISCOVERED_ALLELES_KEY, vc.getAlternateAlleles().size());
        }
        if (alleleCountsofMLE.size() > 0) {
            attributes.put("MLEAC", alleleCountsofMLE);
            int AN = builder.make().getCalledChrCount();
            ArrayList<Double> MLEfrequencies = new ArrayList<Double>(alleleCountsofMLE.size());
            Iterator i$ = alleleCountsofMLE.iterator();
            while (i$.hasNext()) {
                int AC = (Integer)i$.next();
                MLEfrequencies.add(Math.min(1.0, (double)AC / (double)AN));
            }
            attributes.put("MLEAF", MLEfrequencies);
        }
        if (this.UAC.COMPUTE_SLOD && !limitedContext && !bestGuessIsRef) {
            double overallLog10PofF = AFresult.getLog10LikelihoodOfAFGT0();
            List<Allele> allAllelesToUse = builder.make().getAlleles();
            VariantContext vcForward = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.FORWARD, allAllelesToUse, false, model, perReadAlleleLikelihoodMap);
            AFresult = this.afcm.get().getLog10PNonRef(vcForward, this.getAlleleFrequencyPriors(model));
            double forwardLog10PofNull = AFresult.getLog10LikelihoodOfAFEq0();
            double forwardLog10PofF = AFresult.getLog10LikelihoodOfAFGT0();
            VariantContext vcReverse = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.REVERSE, allAllelesToUse, false, model, perReadAlleleLikelihoodMap);
            AFresult = this.afcm.get().getLog10PNonRef(vcReverse, this.getAlleleFrequencyPriors(model));
            double reverseLog10PofNull = AFresult.getLog10LikelihoodOfAFEq0();
            double reverseLog10PofF = AFresult.getLog10LikelihoodOfAFGT0();
            double forwardLod = forwardLog10PofF + reverseLog10PofNull - overallLog10PofF;
            double reverseLod = reverseLog10PofF + forwardLog10PofNull - overallLog10PofF;
            double strandScore = Math.max(forwardLod, reverseLod);
            if (!Double.isNaN(strandScore *= 10.0)) {
                attributes.put("SB", strandScore);
            }
        }
        builder.attributes(attributes);
        VariantContext vcCall = builder.make();
        if (myAlleles.size() != vc.getAlleles().size() && !limitedContext) {
            vcCall = GATKVariantContextUtils.reverseTrimAlleles(vcCall);
        }
        if (this.annotationEngine != null && !limitedContext) {
            ReadBackedPileup pileup = rawContext.getBasePileup();
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup);
            vcCall = this.annotationEngine.annotateContext(tracker, refContext, stratifiedContexts, vcCall, perReadAlleleLikelihoodMap);
        }
        return new VariantCallContext(vcCall, this.confidentlyCalled(phredScaledConfidence, PoFGT0));
    }

    private Map<String, AlignmentContext> getFilteredAndStratifiedContexts(UnifiedArgumentCollection UAC, ReferenceContext refContext, AlignmentContext rawContext, GenotypeLikelihoodsCalculationModel.Model model) {
        if (!BaseUtils.isRegularBase(refContext.getBase())) {
            return null;
        }
        Map<String, AlignmentContext> stratifiedContexts = null;
        if (model.name().contains("INDEL")) {
            ReadBackedPileup pileup = rawContext.getBasePileup().getMappingFilteredPileup(UAC.MIN_BASE_QUALTY_SCORE);
            if (pileup.getNumberOfElements() == 0 && UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES) {
                return null;
            }
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup);
        } else if (model.name().contains("SNP")) {
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(rawContext.getBasePileup());
            if (UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES || UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
                int numDeletions = 0;
                for (PileupElement p : rawContext.getBasePileup()) {
                    if (!p.isDeletion()) continue;
                    ++numDeletions;
                }
                if ((double)numDeletions / (double)rawContext.getBasePileup().getNumberOfElements() > UAC.MAX_DELETION_FRACTION) {
                    return null;
                }
            }
        }
        return stratifiedContexts;
    }

    private final double getRefBinomialProbLog10(int depth) {
        if (depth < binomialProbabilityDepthCache.length) {
            return binomialProbabilityDepthCache[depth];
        }
        return MathUtils.log10BinomialProbability(depth, 0, REF_BINOMIAL_PROB_LOG10_0_5);
    }

    private VariantCallContext estimateReferenceConfidence(VariantContext vc, Map<String, AlignmentContext> contexts, double theta, boolean ignoreCoveredSamples, double initialPofRef) {
        if (contexts == null) {
            return null;
        }
        double log10POfRef = Math.log10(initialPofRef);
        for (String sample : this.samples) {
            AlignmentContext context = contexts.get(sample);
            if (ignoreCoveredSamples && context != null) continue;
            int depth = context == null ? 0 : context.getBasePileup().depthOfCoverage();
            log10POfRef += this.estimateLog10ReferenceConfidenceForOneSample(depth, theta);
        }
        return new VariantCallContext(vc, QualityUtils.phredScaleLog10CorrectRate(log10POfRef) >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING, false);
    }

    @Requires(value={"depth >= 0", "theta >= 0.0 && theta <= 1.0"})
    @Ensures(value={"MathUtils.goodLog10Probability(result)"})
    protected double estimateLog10ReferenceConfidenceForOneSample(int depth, double theta) {
        double log10PofNonRef = Math.log10(theta / 2.0) + this.getRefBinomialProbLog10(depth);
        return MathUtils.log10OneMinusX(Math.pow(10.0, log10PofNonRef));
    }

    protected void printVerboseData(String pos, VariantContext vc, double PofF, double phredScaledConfidence, GenotypeLikelihoodsCalculationModel.Model model) {
        Allele refAllele = null;
        Allele altAllele = null;
        for (Allele allele : vc.getAlleles()) {
            if (allele.isReference()) {
                refAllele = allele;
                continue;
            }
            altAllele = allele;
        }
        for (int i = 0; i <= this.N; ++i) {
            StringBuilder AFline = new StringBuilder("AFINFO\t");
            AFline.append(pos);
            AFline.append("\t");
            AFline.append(refAllele);
            AFline.append("\t");
            if (altAllele != null) {
                AFline.append(altAllele);
            } else {
                AFline.append("N/A");
            }
            AFline.append("\t");
            AFline.append(i + "/" + this.N + "\t");
            AFline.append(String.format("%.2f\t", Float.valueOf((float)i / (float)this.N)));
            AFline.append(String.format("%.8f\t", this.getAlleleFrequencyPriors(model)[i]));
            this.verboseWriter.println(AFline.toString());
        }
        this.verboseWriter.println("P(f>0) = " + PofF);
        this.verboseWriter.println("Qscore = " + phredScaledConfidence);
        this.verboseWriter.println();
    }

    protected boolean passesEmitThreshold(double conf, boolean bestGuessIsRef) {
        return (this.UAC.OutputMode == OUTPUT_MODE.EMIT_ALL_CONFIDENT_SITES || !bestGuessIsRef) && conf >= Math.min(this.UAC.STANDARD_CONFIDENCE_FOR_CALLING, this.UAC.STANDARD_CONFIDENCE_FOR_EMITTING);
    }

    protected boolean passesCallThreshold(double conf) {
        return conf >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING;
    }

    protected boolean confidentlyCalled(double conf, double PofF) {
        return conf >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING || this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES && QualityUtils.phredScaleErrorRate(PofF) >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING;
    }

    private void determineGLModelsToUse() {
        String modelPrefix = "";
        if (!this.UAC.GLmodel.name().contains(GPSTRING) && this.UAC.samplePloidy != 2) {
            modelPrefix = GPSTRING;
        }
        if (this.UAC.GLmodel.name().toUpperCase().contains("BOTH")) {
            modelPrefix = modelPrefix + this.UAC.GLmodel.name().toUpperCase().replaceAll("BOTH", "");
            this.modelsToUse.add(GenotypeLikelihoodsCalculationModel.Model.valueOf(modelPrefix + "SNP"));
            this.modelsToUse.add(GenotypeLikelihoodsCalculationModel.Model.valueOf(modelPrefix + "INDEL"));
        } else {
            this.modelsToUse.add(GenotypeLikelihoodsCalculationModel.Model.valueOf(modelPrefix + this.UAC.GLmodel.name().toUpperCase()));
        }
    }

    private List<GenotypeLikelihoodsCalculationModel.Model> getGLModelsToUse(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        if (this.UAC.GenotypingMode != GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            return this.modelsToUse;
        }
        ArrayList<GenotypeLikelihoodsCalculationModel.Model> GGAmodel = new ArrayList<GenotypeLikelihoodsCalculationModel.Model>(1);
        VariantContext vcInput = UnifiedGenotyperEngine.getVCFromAllelesRod(tracker, refContext, rawContext.getLocation(), false, this.logger, this.UAC.alleles);
        if (vcInput == null) {
            return GGAmodel;
        }
        if (vcInput.isSNP()) {
            if (this.modelsToUse.size() == 2 || this.modelsToUse.get(0).name().endsWith("SNP")) {
                GGAmodel.add(this.modelsToUse.get(0));
            }
        } else if (vcInput.isIndel() || vcInput.isMixed()) {
            if (this.modelsToUse.size() == 2) {
                GGAmodel.add(this.modelsToUse.get(1));
            } else if (this.modelsToUse.get(0).name().endsWith("INDEL")) {
                GGAmodel.add(this.modelsToUse.get(0));
            }
        }
        return GGAmodel;
    }

    public static void computeAlleleFrequencyPriors(int N, double[] priors, double theta) {
        double sum = 0.0;
        for (int i = 1; i <= N; ++i) {
            double value = theta / (double)i;
            priors[i] = Math.log10(value);
            sum += value;
        }
        priors[0] = Math.log10(1.0 - sum);
    }

    protected double[] getAlleleFrequencyPriors(GenotypeLikelihoodsCalculationModel.Model model) {
        if (model.name().toUpperCase().contains("SNP")) {
            return this.log10AlleleFrequencyPriorsSNPs;
        }
        if (model.name().toUpperCase().contains("INDEL")) {
            return this.log10AlleleFrequencyPriorsIndels;
        }
        throw new IllegalArgumentException("Unexpected GenotypeCalculationModel " + (Object)((Object)model));
    }

    protected double getTheta(GenotypeLikelihoodsCalculationModel.Model model) {
        if (model.name().contains("SNP")) {
            return 0.001;
        }
        if (model.name().contains("INDEL")) {
            return 1.0E-4;
        }
        throw new IllegalArgumentException("Unexpected GenotypeCalculationModel " + (Object)((Object)model));
    }

    private static Map<String, GenotypeLikelihoodsCalculationModel> getGenotypeLikelihoodsCalculationObject(Logger logger, UnifiedArgumentCollection UAC) {
        HashMap<String, GenotypeLikelihoodsCalculationModel> glcm = new HashMap<String, GenotypeLikelihoodsCalculationModel>();
        List glmClasses = new PluginManager(GenotypeLikelihoodsCalculationModel.class).getPlugins();
        for (int i = 0; i < glmClasses.size(); ++i) {
            Class glmClass = glmClasses.get(i);
            String key = glmClass.getSimpleName().replaceAll("GenotypeLikelihoodsCalculationModel", "").toUpperCase();
            try {
                Object[] args = new Object[]{UAC, logger};
                Constructor c = glmClass.getDeclaredConstructor(UnifiedArgumentCollection.class, Logger.class);
                glcm.put(key, (GenotypeLikelihoodsCalculationModel)c.newInstance(args));
                continue;
            }
            catch (Exception e) {
                throw new UserException("The likelihoods model provided for the -glm argument (" + (Object)((Object)UAC.GLmodel) + ") is not a valid option: " + e.getMessage());
            }
        }
        return glcm;
    }

    public static VariantContext getVCFromAllelesRod(RefMetaDataTracker tracker, ReferenceContext ref, GenomeLoc loc, boolean requireSNP, Logger logger, RodBinding<VariantContext> allelesBinding) {
        if (tracker == null || ref == null || logger == null) {
            return null;
        }
        VariantContext vc = null;
        for (VariantContext vc_input : tracker.getValues(allelesBinding, loc)) {
            if (vc_input == null || vc_input.isFiltered() || requireSNP && !vc_input.isSNP()) continue;
            if (vc == null) {
                vc = vc_input;
                continue;
            }
            logger.warn("Multiple valid VCF records detected in the alleles input file at site " + ref.getLocus() + ", only considering the first record");
        }
        return vc;
    }

    static {
        for (int i = 1; i < binomialProbabilityDepthCache.length; ++i) {
            UnifiedGenotyperEngine.binomialProbabilityDepthCache[i] = MathUtils.log10BinomialProbability(i, 0, REF_BINOMIAL_PROB_LOG10_0_5);
        }
    }

    public static enum OUTPUT_MODE {
        EMIT_VARIANTS_ONLY,
        EMIT_ALL_CONFIDENT_SITES,
        EMIT_ALL_SITES;

    }
}

