/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactCallLogger;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.StateTracker;
import org.broadinstitute.sting.utils.SimpleTimer;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;

public abstract class AFCalc
implements Cloneable {
    private static final Logger defaultLogger = Logger.getLogger(AFCalc.class);
    protected final int nSamples;
    protected final int maxAlternateAllelesToGenotype;
    protected Logger logger = defaultLogger;
    private SimpleTimer callTimer = new SimpleTimer();
    private final StateTracker stateTracker;
    private ExactCallLogger exactCallLogger = null;

    protected AFCalc(int nSamples, int maxAltAlleles, int ploidy) {
        if (nSamples < 0) {
            throw new IllegalArgumentException("nSamples must be greater than zero " + nSamples);
        }
        if (maxAltAlleles < 1) {
            throw new IllegalArgumentException("maxAltAlleles must be greater than zero " + maxAltAlleles);
        }
        if (ploidy < 1) {
            throw new IllegalArgumentException("ploidy must be > 0 but got " + ploidy);
        }
        this.nSamples = nSamples;
        this.maxAlternateAllelesToGenotype = maxAltAlleles;
        this.stateTracker = new StateTracker(maxAltAlleles);
    }

    public void enableProcessLog(File exactCallsLog) {
        this.exactCallLogger = new ExactCallLogger(exactCallsLog);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public AFCalcResult getLog10PNonRef(VariantContext vc, double[] log10AlleleFrequencyPriors) {
        if (vc == null) {
            throw new IllegalArgumentException("VariantContext cannot be null");
        }
        if (vc.getNAlleles() == 1) {
            throw new IllegalArgumentException("VariantContext has only a single reference allele, but getLog10PNonRef requires at least one at all " + vc);
        }
        if (log10AlleleFrequencyPriors == null) {
            throw new IllegalArgumentException("priors vector cannot be null");
        }
        if (this.stateTracker == null) {
            throw new IllegalArgumentException("Results object cannot be null");
        }
        this.stateTracker.reset();
        VariantContext vcWorking = this.reduceScope(vc);
        this.callTimer.start();
        AFCalcResult result = this.computeLog10PNonRef(vcWorking, log10AlleleFrequencyPriors);
        long nanoTime = this.callTimer.getElapsedTimeNano();
        if (this.exactCallLogger != null) {
            this.exactCallLogger.printCallInfo(vcWorking, log10AlleleFrequencyPriors, nanoTime, result);
        }
        return result;
    }

    @Requires(value={"stateTracker.getnEvaluations() >= 0"})
    @Ensures(value={"result != null"})
    protected AFCalcResult getResultFromFinalState(VariantContext vcWorking, double[] log10AlleleFrequencyPriors) {
        this.stateTracker.setAllelesUsedInGenotyping(vcWorking.getAlleles());
        return this.stateTracker.toAFCalcResult(log10AlleleFrequencyPriors);
    }

    @Requires(value={"vc != null", "vc.getNAlleles() > 1"})
    @Ensures(value={"result != null"})
    protected abstract VariantContext reduceScope(VariantContext var1);

    @Requires(value={"vc != null", "log10AlleleFrequencyPriors != null", "vc.getNAlleles() > 1"})
    protected abstract AFCalcResult computeLog10PNonRef(VariantContext var1, double[] var2);

    public abstract GenotypesContext subsetAlleles(VariantContext var1, List<Allele> var2, boolean var3, int var4);

    public int getMaxAltAlleles() {
        return this.maxAlternateAllelesToGenotype;
    }

    protected StateTracker getStateTracker() {
        return this.stateTracker;
    }
}

