/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalc;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.IndependentAllelesDiploidExactAFCalc;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.OriginalDiploidExactAFCalc;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ReferenceDiploidExactAFCalc;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class AFCalcFactory {
    private static final Map<String, Class<? extends AFCalc>> afClasses = new PluginManager(AFCalc.class).getPluginsByName();

    private AFCalcFactory() {
    }

    private static Class<? extends AFCalc> getClassByName(String name) {
        for (Class<? extends AFCalc> clazz : afClasses.values()) {
            if (!clazz.getSimpleName().contains(name)) continue;
            return clazz;
        }
        return null;
    }

    public static AFCalc createAFCalc(UnifiedArgumentCollection UAC, int nSamples, Logger logger) {
        int maxAltAlleles = UAC.MAX_ALTERNATE_ALLELES;
        if (!UAC.AFmodel.usableForParams(UAC.samplePloidy, maxAltAlleles)) {
            logger.info("Requested ploidy " + UAC.samplePloidy + " maxAltAlleles " + maxAltAlleles + " not supported by requested model " + (Object)((Object)UAC.AFmodel) + " looking for an option");
            LinkedList<Calculation> supportingCalculations = new LinkedList<Calculation>();
            for (Calculation calc : Calculation.values()) {
                if (!calc.usableForParams(UAC.samplePloidy, maxAltAlleles)) continue;
                supportingCalculations.add(calc);
            }
            if (supportingCalculations.isEmpty()) {
                throw new UserException("no AFCalculation model found that supports ploidy of " + UAC.samplePloidy + " and max alt alleles " + maxAltAlleles);
            }
            if (supportingCalculations.size() > 1) {
                logger.debug("Warning, multiple supporting AFCalcs found " + Utils.join(",", supportingCalculations) + " choosing first arbitrarily");
            } else {
                UAC.AFmodel = (Calculation)((Object)supportingCalculations.get(0));
            }
            logger.info("Selecting model " + (Object)((Object)UAC.AFmodel));
        }
        AFCalc calc = AFCalcFactory.createAFCalc(UAC.AFmodel, nSamples, UAC.MAX_ALTERNATE_ALLELES, UAC.samplePloidy);
        if (logger != null) {
            calc.setLogger(logger);
        }
        if (UAC.exactCallsLog != null) {
            calc.enableProcessLog(UAC.exactCallsLog);
        }
        return calc;
    }

    public static AFCalc createAFCalc(int nSamples) {
        return AFCalcFactory.createAFCalc(AFCalcFactory.chooseBestCalculation(nSamples, 2, 1), nSamples, 2, 2);
    }

    public static AFCalc createAFCalc(Calculation calc, int nSamples, int maxAltAlleles) {
        return AFCalcFactory.createAFCalc(calc, nSamples, maxAltAlleles, 2);
    }

    public static AFCalc createAFCalc(int nSamples, int maxAltAlleles, int ploidy) {
        return AFCalcFactory.createAFCalc(AFCalcFactory.chooseBestCalculation(nSamples, ploidy, maxAltAlleles), nSamples, maxAltAlleles, ploidy);
    }

    private static Calculation chooseBestCalculation(int nSamples, int ploidy, int maxAltAlleles) {
        for (Calculation calc : Calculation.values()) {
            if (!calc.usableForParams(ploidy, maxAltAlleles)) continue;
            return calc;
        }
        throw new IllegalStateException("no calculation found that supports nSamples " + nSamples + " ploidy " + ploidy + " and maxAltAlleles " + maxAltAlleles);
    }

    public static AFCalc createAFCalc(Calculation calc, int nSamples, int maxAltAlleles, int ploidy) {
        if (calc == null) {
            throw new IllegalArgumentException("Calculation cannot be null");
        }
        if (nSamples < 0) {
            throw new IllegalArgumentException("nSamples must be greater than zero " + nSamples);
        }
        if (maxAltAlleles < 1) {
            throw new IllegalArgumentException("maxAltAlleles must be greater than zero " + maxAltAlleles);
        }
        if (ploidy < 1) {
            throw new IllegalArgumentException("sample ploidy must be greater than zero " + ploidy);
        }
        if (!calc.usableForParams(ploidy, maxAltAlleles)) {
            throw new IllegalArgumentException("AFCalc " + (Object)((Object)calc) + " does not support requested ploidy " + ploidy);
        }
        Class<? extends AFCalc> afClass = AFCalcFactory.getClassByName(calc.className);
        if (afClass == null) {
            throw new IllegalArgumentException("Unexpected AFCalc " + (Object)((Object)calc));
        }
        try {
            Object[] args = new Object[]{nSamples, maxAltAlleles, ploidy};
            Constructor<? extends AFCalc> c = afClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
            return c.newInstance(args);
        }
        catch (Exception e) {
            throw new ReviewedStingException("Could not instantiate AFCalc " + (Object)((Object)calc), e);
        }
    }

    protected static List<AFCalc> createAFCalcs(List<Calculation> calcs, int nSamples, int maxAltAlleles, int ploidy) {
        LinkedList<AFCalc> AFCalcs = new LinkedList<AFCalc>();
        for (Calculation calc : calcs) {
            AFCalcs.add(AFCalcFactory.createAFCalc(calc, nSamples, maxAltAlleles, ploidy));
        }
        return AFCalcs;
    }

    public static enum Calculation {
        EXACT_INDEPENDENT(IndependentAllelesDiploidExactAFCalc.class, 2, -1),
        EXACT_REFERENCE(ReferenceDiploidExactAFCalc.class, 2, -1),
        EXACT_ORIGINAL(OriginalDiploidExactAFCalc.class, 2, 2),
        EXACT_GENERAL_PLOIDY("GeneralPloidyExactAFCalc", -1, -1);

        public final String className;
        public final int maxAltAlleles;
        public final int requiredPloidy;

        private Calculation(String className, int requiredPloidy, int maxAltAlleles) {
            this.className = className;
            this.requiredPloidy = requiredPloidy;
            this.maxAltAlleles = maxAltAlleles;
        }

        private Calculation(Class clazz, int requiredPloidy, int maxAltAlleles) {
            this(clazz.getSimpleName(), requiredPloidy, maxAltAlleles);
        }

        public boolean usableForParams(int requestedPloidy, int requestedMaxAltAlleles) {
            return !(this.requiredPloidy != -1 && this.requiredPloidy != requestedPloidy || this.maxAltAlleles != -1 && this.maxAltAlleles < requestedMaxAltAlleles);
        }

        public static Calculation getDefaultModel() {
            return EXACT_INDEPENDENT;
        }
    }
}

