/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactACcounts;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactACset;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactAFCalc;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public abstract class DiploidExactAFCalc
extends ExactAFCalc {
    private static final int PL_INDEX_OF_HOM_REF = 0;

    public DiploidExactAFCalc(int nSamples, int maxAltAlleles, int ploidy) {
        super(nSamples, maxAltAlleles, ploidy);
        if (ploidy != 2) {
            throw new IllegalArgumentException("ploidy must be two for DiploidExactAFCalc and subclasses but saw " + ploidy);
        }
    }

    @Override
    protected AFCalcResult computeLog10PNonRef(VariantContext vc, double[] log10AlleleFrequencyPriors) {
        int numAlternateAlleles = vc.getNAlleles() - 1;
        ArrayList<double[]> genotypeLikelihoods = DiploidExactAFCalc.getGLs(vc.getGenotypes(), true);
        int numSamples = genotypeLikelihoods.size() - 1;
        int numChr = 2 * numSamples;
        LinkedList<ExactACset> ACqueue = new LinkedList<ExactACset>();
        HashMap<ExactACcounts, ExactACset> indexesToACset = new HashMap<ExactACcounts, ExactACset>(numChr + 1);
        int[] zeroCounts = new int[numAlternateAlleles];
        ExactACset zeroSet = new ExactACset(numSamples + 1, new ExactACcounts(zeroCounts));
        ACqueue.add(zeroSet);
        indexesToACset.put(zeroSet.getACcounts(), zeroSet);
        while (!ACqueue.isEmpty()) {
            this.getStateTracker().incNEvaluations();
            ExactACset set = (ExactACset)ACqueue.remove();
            double log10LofKs = this.calculateAlleleCountConformation(set, genotypeLikelihoods, numChr, ACqueue, indexesToACset, log10AlleleFrequencyPriors);
            indexesToACset.remove(set.getACcounts());
        }
        return this.getResultFromFinalState(vc, log10AlleleFrequencyPriors);
    }

    @Override
    protected VariantContext reduceScope(VariantContext vc) {
        if (vc.getAlternateAlleles().size() > this.getMaxAltAlleles()) {
            this.logger.warn("this tool is currently set to genotype at most " + this.getMaxAltAlleles() + " alternate alleles in a given context, but the context at " + vc.getChr() + ":" + vc.getStart() + " has " + vc.getAlternateAlleles().size() + " alternate alleles so only the top alleles will be used; see the --max_alternate_alleles argument");
            VariantContextBuilder builder = new VariantContextBuilder(vc);
            ArrayList<Allele> alleles = new ArrayList<Allele>(this.getMaxAltAlleles() + 1);
            alleles.add(vc.getReference());
            alleles.addAll(DiploidExactAFCalc.chooseMostLikelyAlternateAlleles(vc, this.getMaxAltAlleles()));
            builder.alleles((Collection<Allele>)alleles);
            builder.genotypes(GATKVariantContextUtils.subsetDiploidAlleles(vc, alleles, false));
            return builder.make();
        }
        return vc;
    }

    private static List<Allele> chooseMostLikelyAlternateAlleles(VariantContext vc, int numAllelesToChoose) {
        int numOriginalAltAlleles = vc.getAlternateAlleles().size();
        ExactAFCalc.LikelihoodSum[] likelihoodSums = new ExactAFCalc.LikelihoodSum[numOriginalAltAlleles];
        for (int i = 0; i < numOriginalAltAlleles; ++i) {
            likelihoodSums[i] = new ExactAFCalc.LikelihoodSum(vc.getAlternateAllele(i));
        }
        ArrayList<double[]> GLs = DiploidExactAFCalc.getGLs(vc.getGenotypes(), true);
        for (double[] likelihoods : GLs) {
            int PLindexOfBestGL = MathUtils.maxElementIndex(likelihoods);
            if (PLindexOfBestGL == 0) continue;
            GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair(PLindexOfBestGL);
            if (alleles.alleleIndex1 != 0) {
                likelihoodSums[alleles.alleleIndex1 - 1].sum += likelihoods[PLindexOfBestGL] - likelihoods[0];
            }
            if (alleles.alleleIndex2 == 0 || alleles.alleleIndex2 == alleles.alleleIndex1) continue;
            likelihoodSums[alleles.alleleIndex2 - 1].sum += likelihoods[PLindexOfBestGL] - likelihoods[0];
        }
        Collections.sort(Arrays.asList(likelihoodSums));
        ArrayList<Allele> bestAlleles = new ArrayList<Allele>(numAllelesToChoose);
        for (int i = 0; i < numAllelesToChoose; ++i) {
            bestAlleles.add(likelihoodSums[i].allele);
        }
        ArrayList<Allele> orderedBestAlleles = new ArrayList<Allele>(numAllelesToChoose);
        for (Allele allele : vc.getAlternateAlleles()) {
            if (!bestAlleles.contains(allele)) continue;
            orderedBestAlleles.add(allele);
        }
        return orderedBestAlleles;
    }

    private double calculateAlleleCountConformation(ExactACset set, ArrayList<double[]> genotypeLikelihoods, int numChr, LinkedList<ExactACset> ACqueue, HashMap<ExactACcounts, ExactACset> indexesToACset, double[] log10AlleleFrequencyPriors) {
        this.computeLofK(set, genotypeLikelihoods, log10AlleleFrequencyPriors);
        double log10LofK = set.getLog10Likelihoods()[set.getLog10Likelihoods().length - 1];
        if (this.getStateTracker().abort(log10LofK, set.getACcounts(), true)) {
            return log10LofK;
        }
        int ACwiggle = numChr - set.getACsum();
        if (ACwiggle == 0) {
            return log10LofK;
        }
        int numAltAlleles = set.getACcounts().getCounts().length;
        for (int allele = 0; allele < numAltAlleles; ++allele) {
            int[] ACcountsClone = (int[])set.getACcounts().getCounts().clone();
            int n = allele;
            ACcountsClone[n] = ACcountsClone[n] + 1;
            int PLindex = GenotypeLikelihoods.calculatePLindex(0, allele + 1);
            this.updateACset(ACcountsClone, numChr, set, PLindex, ACqueue, indexesToACset, genotypeLikelihoods);
        }
        if (ACwiggle > 1) {
            ArrayList<DependentSet> differentAlleles = new ArrayList<DependentSet>(numAltAlleles * numAltAlleles);
            ArrayList<DependentSet> sameAlleles = new ArrayList<DependentSet>(numAltAlleles);
            for (int allele_i = 0; allele_i < numAltAlleles; ++allele_i) {
                for (int allele_j = allele_i; allele_j < numAltAlleles; ++allele_j) {
                    int[] ACcountsClone = (int[])set.getACcounts().getCounts().clone();
                    int n = allele_i;
                    ACcountsClone[n] = ACcountsClone[n] + 1;
                    int n2 = allele_j;
                    ACcountsClone[n2] = ACcountsClone[n2] + 1;
                    int PLindex = GenotypeLikelihoods.calculatePLindex(allele_i + 1, allele_j + 1);
                    if (allele_i == allele_j) {
                        sameAlleles.add(new DependentSet(ACcountsClone, PLindex));
                        continue;
                    }
                    differentAlleles.add(new DependentSet(ACcountsClone, PLindex));
                }
            }
            for (DependentSet dependent : differentAlleles) {
                this.updateACset(dependent.ACcounts, numChr, set, dependent.PLindex, ACqueue, indexesToACset, genotypeLikelihoods);
            }
            for (DependentSet dependent : sameAlleles) {
                this.updateACset(dependent.ACcounts, numChr, set, dependent.PLindex, ACqueue, indexesToACset, genotypeLikelihoods);
            }
        }
        return log10LofK;
    }

    private void updateACset(int[] newSetCounts, int numChr, ExactACset dependentSet, int PLsetIndex, Queue<ExactACset> ACqueue, HashMap<ExactACcounts, ExactACset> indexesToACset, ArrayList<double[]> genotypeLikelihoods) {
        ExactACcounts index = new ExactACcounts(newSetCounts);
        if (!indexesToACset.containsKey(index)) {
            ExactACset set = new ExactACset(numChr / 2 + 1, index);
            indexesToACset.put(index, set);
            ACqueue.add(set);
        }
        this.pushData(indexesToACset.get(index), dependentSet, PLsetIndex, genotypeLikelihoods);
    }

    private void computeLofK(ExactACset set, ArrayList<double[]> genotypeLikelihoods, double[] log10AlleleFrequencyPriors) {
        set.getLog10Likelihoods()[0] = 0.0;
        int totalK = set.getACsum();
        if (totalK == 0) {
            for (int j = 1; j < set.getLog10Likelihoods().length; ++j) {
                set.getLog10Likelihoods()[j] = set.getLog10Likelihoods()[j - 1] + genotypeLikelihoods.get(j)[0];
            }
            double log10Lof0 = set.getLog10Likelihoods()[set.getLog10Likelihoods().length - 1];
            this.getStateTracker().setLog10LikelihoodOfAFzero(log10Lof0);
            this.getStateTracker().setLog10PosteriorOfAFzero(log10Lof0 + log10AlleleFrequencyPriors[0]);
            return;
        }
        for (int j = 1; j < set.getLog10Likelihoods().length; ++j) {
            if (totalK < 2 * j - 1) {
                double[] gl = genotypeLikelihoods.get(j);
                double conformationValue = MathUtils.log10Cache[2 * j - totalK] + MathUtils.log10Cache[2 * j - totalK - 1] + set.getLog10Likelihoods()[j - 1] + gl[0];
                set.getLog10Likelihoods()[j] = MathUtils.approximateLog10SumLog10(set.getLog10Likelihoods()[j], conformationValue);
            }
            double logDenominator = MathUtils.log10Cache[2 * j] + MathUtils.log10Cache[2 * j - 1];
            set.getLog10Likelihoods()[j] = set.getLog10Likelihoods()[j] - logDenominator;
        }
        double log10LofK = set.getLog10Likelihoods()[set.getLog10Likelihoods().length - 1];
        this.getStateTracker().updateMLEifNeeded(log10LofK, set.getACcounts().getCounts());
        for (int ACcount : set.getACcounts().getCounts()) {
            if (ACcount <= 0) continue;
            log10LofK += log10AlleleFrequencyPriors[ACcount];
        }
        this.getStateTracker().updateMAPifNeeded(log10LofK, set.getACcounts().getCounts());
    }

    private void pushData(ExactACset targetSet, ExactACset dependentSet, int PLsetIndex, ArrayList<double[]> genotypeLikelihoods) {
        int totalK = targetSet.getACsum();
        for (int j = 1; j < targetSet.getLog10Likelihoods().length; ++j) {
            if (totalK > 2 * j) continue;
            double[] gl = genotypeLikelihoods.get(j);
            double conformationValue = this.determineCoefficient(PLsetIndex, j, targetSet.getACcounts().getCounts(), totalK) + dependentSet.getLog10Likelihoods()[j - 1] + gl[PLsetIndex];
            targetSet.getLog10Likelihoods()[j] = MathUtils.approximateLog10SumLog10(targetSet.getLog10Likelihoods()[j], conformationValue);
        }
    }

    private double determineCoefficient(int PLindex, int j, int[] ACcounts, int totalK) {
        double coeff;
        GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair(PLindex);
        if (alleles.alleleIndex1 == 0) {
            return MathUtils.log10Cache[2 * ACcounts[alleles.alleleIndex2 - 1]] + MathUtils.log10Cache[2 * j - totalK];
        }
        int k_i = ACcounts[alleles.alleleIndex1 - 1];
        if (alleles.alleleIndex1 == alleles.alleleIndex2) {
            coeff = MathUtils.log10Cache[k_i] + MathUtils.log10Cache[k_i - 1];
        } else {
            int k_j = ACcounts[alleles.alleleIndex2 - 1];
            coeff = MathUtils.log10Cache[2] + MathUtils.log10Cache[k_i] + MathUtils.log10Cache[k_j];
        }
        return coeff;
    }

    @Override
    public GenotypesContext subsetAlleles(VariantContext vc, List<Allele> allelesToUse, boolean assignGenotypes, int ploidy) {
        return GATKVariantContextUtils.subsetDiploidAlleles(vc, allelesToUse, assignGenotypes);
    }

    private static final class DependentSet {
        public final int[] ACcounts;
        public final int PLindex;

        public DependentSet(int[] ACcounts, int PLindex) {
            this.ACcounts = ACcounts;
            this.PLindex = PLindex;
        }
    }
}

