/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import java.util.ArrayList;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalc;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypesContext;

abstract class ExactAFCalc
extends AFCalc {
    protected static final int HOM_REF_INDEX = 0;

    protected ExactAFCalc(int nSamples, int maxAltAlleles, int ploidy) {
        super(nSamples, maxAltAlleles, ploidy);
    }

    protected static ArrayList<double[]> getGLs(GenotypesContext GLs, boolean includeDummy) {
        ArrayList<double[]> genotypeLikelihoods = new ArrayList<double[]>(GLs.size() + 1);
        if (includeDummy) {
            genotypeLikelihoods.add(new double[]{0.0, 0.0, 0.0});
        }
        for (Genotype sample : GLs.iterateInSampleNameOrder()) {
            double[] gls;
            if (!sample.hasLikelihoods() || !(MathUtils.sum(gls = sample.getLikelihoods().getAsVector()) < -0.1)) continue;
            genotypeLikelihoods.add(gls);
        }
        return genotypeLikelihoods;
    }

    protected static final class LikelihoodSum
    implements Comparable<LikelihoodSum> {
        public double sum = 0.0;
        public Allele allele;

        public LikelihoodSum(Allele allele) {
            this.allele = allele;
        }

        @Override
        public int compareTo(LikelihoodSum other) {
            double diff = this.sum - other.sum;
            return diff < 0.0 ? 1 : (diff > 0.0 ? -1 : 0);
        }
    }
}

