/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalc;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.DiploidExactAFCalc;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ReferenceDiploidExactAFCalc;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public class IndependentAllelesDiploidExactAFCalc
extends DiploidExactAFCalc {
    private static final double MIN_LOG10_CONFIDENCE_TO_INCLUDE_ALLELE_IN_POSTERIOR = Math.log10(1.0E-10);
    private static final int[] BIALLELIC_NON_INFORMATIVE_PLS = new int[]{0, 0, 0};
    private static final List<Allele> BIALLELIC_NOCALL = Arrays.asList(Allele.NO_CALL, Allele.NO_CALL);
    private static final CompareAFCalcResultsByPNonRef compareAFCalcResultsByPNonRef = new CompareAFCalcResultsByPNonRef();
    final AFCalc biAlleleExactModel;

    protected IndependentAllelesDiploidExactAFCalc(int nSamples, int maxAltAlleles, int ploidy) {
        super(nSamples, maxAltAlleles, ploidy);
        this.biAlleleExactModel = new ReferenceDiploidExactAFCalc(nSamples, 1, ploidy);
    }

    @Override
    public AFCalcResult computeLog10PNonRef(VariantContext vc, double[] log10AlleleFrequencyPriors) {
        List<AFCalcResult> independentResultTrackers = this.computeAlleleIndependentExact(vc, log10AlleleFrequencyPriors);
        if (independentResultTrackers.size() == 0) {
            throw new IllegalStateException("Independent alleles model returned an empty list of results at VC " + vc);
        }
        if (independentResultTrackers.size() == 1) {
            return independentResultTrackers.get(0);
        }
        List<AFCalcResult> withMultiAllelicPriors = this.applyMultiAllelicPriors(independentResultTrackers);
        return this.combineIndependentPNonRefs(vc, withMultiAllelicPriors);
    }

    @Requires(value={"vc != null", "log10AlleleFrequencyPriors != null"})
    @Ensures(value={"goodIndependentResult(vc, result)"})
    protected final List<AFCalcResult> computeAlleleIndependentExact(VariantContext vc, double[] log10AlleleFrequencyPriors) {
        LinkedList<AFCalcResult> results = new LinkedList<AFCalcResult>();
        for (VariantContext subvc : this.makeAlleleConditionalContexts(vc)) {
            AFCalcResult resultTracker = this.biAlleleExactModel.getLog10PNonRef(subvc, log10AlleleFrequencyPriors);
            results.add(resultTracker);
        }
        return results;
    }

    private static boolean goodIndependentResult(VariantContext vc, List<AFCalcResult> results) {
        if (results.size() != vc.getNAlleles() - 1) {
            return false;
        }
        for (int i = 0; i < results.size(); ++i) {
            if (results.get(i).getAllelesUsedInGenotyping().size() != 2) {
                return false;
            }
            if (results.get(i).getAllelesUsedInGenotyping().contains(vc.getAlternateAllele(i))) continue;
            return false;
        }
        return true;
    }

    @Requires(value={"vc != null", "vc.getNAlleles() > 1"})
    @Ensures(value={"result.size() == vc.getNAlleles() - 1"})
    protected final List<VariantContext> makeAlleleConditionalContexts(VariantContext vc) {
        int nAltAlleles = vc.getNAlleles() - 1;
        if (nAltAlleles == 1) {
            return Collections.singletonList(vc);
        }
        LinkedList<VariantContext> vcs = new LinkedList<VariantContext>();
        for (int altI = 0; altI < nAltAlleles; ++altI) {
            vcs.add(this.biallelicCombinedGLs(vc, altI + 1));
        }
        return vcs;
    }

    @Requires(value={"rootVC.getNAlleles() > 1", "altAlleleIndex < rootVC.getNAlleles()"})
    @Ensures(value={"result.isBiallelic()"})
    protected final VariantContext biallelicCombinedGLs(VariantContext rootVC, int altAlleleIndex) {
        if (rootVC.isBiallelic()) {
            return rootVC;
        }
        int nAlts = rootVC.getNAlleles() - 1;
        ArrayList<Genotype> biallelicGenotypes = new ArrayList<Genotype>(rootVC.getNSamples());
        for (Genotype g : rootVC.getGenotypes()) {
            biallelicGenotypes.add(this.combineGLs(g, altAlleleIndex, nAlts));
        }
        VariantContextBuilder vcb = new VariantContextBuilder(rootVC);
        Allele altAllele = rootVC.getAlternateAllele(altAlleleIndex - 1);
        vcb.alleles((Collection<Allele>)Arrays.asList(rootVC.getReference(), altAllele));
        vcb.genotypes(biallelicGenotypes);
        return vcb.make();
    }

    @Requires(value={"original.hasLikelihoods()"})
    @Ensures(value={"result.hasLikelihoods()", "result.getPL().length == 3"})
    protected Genotype combineGLs(Genotype original, int altIndex, int nAlts) {
        if (original.isNonInformative()) {
            return new GenotypeBuilder(original).PL(BIALLELIC_NON_INFORMATIVE_PLS).alleles(BIALLELIC_NOCALL).make();
        }
        if (altIndex < 1 || altIndex > nAlts) {
            throw new IllegalStateException("altIndex must be between 1 and nAlts " + nAlts);
        }
        double[] normalizedPr = MathUtils.normalizeFromLog10(GenotypeLikelihoods.fromPLs(original.getPL()).getAsVector());
        double[] biAllelicPr = new double[3];
        for (int index = 0; index < normalizedPr.length; ++index) {
            GenotypeLikelihoods.GenotypeLikelihoodsAllelePair pair = GenotypeLikelihoods.getAllelePair(index);
            if (pair.alleleIndex1 == altIndex) {
                if (pair.alleleIndex2 == altIndex) {
                    biAllelicPr[2] = normalizedPr[index];
                    continue;
                }
                biAllelicPr[1] = biAllelicPr[1] + normalizedPr[index];
                continue;
            }
            if (pair.alleleIndex2 == altIndex) {
                biAllelicPr[1] = biAllelicPr[1] + normalizedPr[index];
                continue;
            }
            biAllelicPr[0] = biAllelicPr[0] + normalizedPr[index];
        }
        double[] GLs = new double[3];
        for (int i = 0; i < GLs.length; ++i) {
            GLs[i] = Math.log10(biAllelicPr[i]);
        }
        return new GenotypeBuilder(original).PL(GLs).alleles(BIALLELIC_NOCALL).make();
    }

    protected final List<AFCalcResult> applyMultiAllelicPriors(List<AFCalcResult> conditionalPNonRefResults) {
        ArrayList<AFCalcResult> sorted = new ArrayList<AFCalcResult>(conditionalPNonRefResults);
        Collections.sort(sorted, compareAFCalcResultsByPNonRef);
        double lastPosteriorGt0 = sorted.get(0).getLog10PosteriorOfAFGT0();
        double log10SingleAllelePriorOfAFGt0 = conditionalPNonRefResults.get(0).getLog10PriorOfAFGT0();
        for (int i = 0; i < sorted.size(); ++i) {
            if (sorted.get(i).getLog10PosteriorOfAFGT0() > lastPosteriorGt0) {
                throw new IllegalStateException("pNonRefResults not sorted: lastPosteriorGt0 " + lastPosteriorGt0 + " but current is " + sorted.get(i).getLog10PosteriorOfAFGT0());
            }
            double log10PriorAFGt0 = (double)(i + 1) * log10SingleAllelePriorOfAFGt0;
            double log10PriorAFEq0 = Math.log10(1.0 - Math.pow(10.0, log10PriorAFGt0));
            double[] thetaTONPriors = new double[]{log10PriorAFEq0, log10PriorAFGt0};
            sorted.set(i, sorted.get(i).withNewPriors(MathUtils.normalizeFromLog10(thetaTONPriors, true)));
        }
        return sorted;
    }

    protected AFCalcResult combineIndependentPNonRefs(VariantContext vc, List<AFCalcResult> sortedResultsWithThetaNPriors) {
        int nEvaluations = 0;
        int nAltAlleles = sortedResultsWithThetaNPriors.size();
        int[] alleleCountsOfMLE = new int[nAltAlleles];
        double[] log10PriorsOfAC = new double[2];
        HashMap<Allele, Double> log10pRefByAllele = new HashMap<Allele, Double>(nAltAlleles);
        double log10PosteriorOfACEq0Sum = 0.0;
        double log10PosteriorOfACGt0Sum = 0.0;
        boolean anyPoly = false;
        for (AFCalcResult sortedResultWithThetaNPriors : sortedResultsWithThetaNPriors) {
            Allele altAllele = sortedResultWithThetaNPriors.getAllelesUsedInGenotyping().get(1);
            int altI = vc.getAlleles().indexOf(altAllele) - 1;
            alleleCountsOfMLE[altI] = sortedResultWithThetaNPriors.getAlleleCountAtMLE(altAllele);
            if (sortedResultWithThetaNPriors.getLog10PosteriorOfAFGT0() > MIN_LOG10_CONFIDENCE_TO_INCLUDE_ALLELE_IN_POSTERIOR) {
                anyPoly = true;
                log10PosteriorOfACEq0Sum += sortedResultWithThetaNPriors.getLog10PosteriorOfAFEq0();
                log10PriorsOfAC[0] = log10PriorsOfAC[0] + sortedResultWithThetaNPriors.getLog10PriorOfAFEq0();
                log10PriorsOfAC[1] = log10PriorsOfAC[1] + sortedResultWithThetaNPriors.getLog10PriorOfAFGT0();
            }
            log10PosteriorOfACGt0Sum += sortedResultWithThetaNPriors.getLog10PosteriorOfAFGT0();
            log10pRefByAllele.put(altAllele, sortedResultWithThetaNPriors.getLog10PosteriorOfAFEq0());
            nEvaluations += sortedResultWithThetaNPriors.nEvaluations;
        }
        if (!anyPoly) {
            log10PriorsOfAC[0] = sortedResultsWithThetaNPriors.get(0).getLog10PriorOfAFEq0();
            log10PriorsOfAC[1] = sortedResultsWithThetaNPriors.get(0).getLog10PriorOfAFGT0();
        }
        double log10PosteriorOfACGt0 = log10PosteriorOfACEq0Sum == 0.0 ? log10PosteriorOfACGt0Sum : Math.max(Math.log10(1.0 - Math.pow(10.0, log10PosteriorOfACEq0Sum)), -1000000.0);
        double[] log10LikelihoodsOfAC = new double[]{log10PosteriorOfACEq0Sum - log10PriorsOfAC[0], log10PosteriorOfACGt0 - log10PriorsOfAC[1]};
        return new MyAFCalcResult(alleleCountsOfMLE, nEvaluations, vc.getAlleles(), MathUtils.normalizeFromLog10(log10LikelihoodsOfAC, true), MathUtils.normalizeFromLog10(log10PriorsOfAC, true), log10pRefByAllele, sortedResultsWithThetaNPriors);
    }

    private static class MyAFCalcResult
    extends AFCalcResult {
        final List<AFCalcResult> supporting;

        private MyAFCalcResult(int[] alleleCountsOfMLE, int nEvaluations, List<Allele> allelesUsedInGenotyping, double[] log10LikelihoodsOfAC, double[] log10PriorsOfAC, Map<Allele, Double> log10pRefByAllele, List<AFCalcResult> supporting) {
            super(alleleCountsOfMLE, nEvaluations, allelesUsedInGenotyping, log10LikelihoodsOfAC, log10PriorsOfAC, log10pRefByAllele);
            this.supporting = supporting;
        }
    }

    private static final class CompareAFCalcResultsByPNonRef
    implements Comparator<AFCalcResult> {
        private CompareAFCalcResultsByPNonRef() {
        }

        @Override
        public int compare(AFCalcResult o1, AFCalcResult o2) {
            return -1 * Double.compare(o1.getLog10PosteriorOfAFGT0(), o2.getLog10PosteriorOfAFGT0());
        }
    }
}

