/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.DiploidExactAFCalc;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.VariantContext;

class OriginalDiploidExactAFCalc
extends DiploidExactAFCalc {
    protected OriginalDiploidExactAFCalc(int nSamples, int maxAltAlleles, int ploidy) {
        super(nSamples, maxAltAlleles, ploidy);
    }

    @Override
    protected AFCalcResult computeLog10PNonRef(VariantContext vc, double[] log10AlleleFrequencyPriors) {
        double[] log10AlleleFrequencyLikelihoods = new double[log10AlleleFrequencyPriors.length];
        double[] log10AlleleFrequencyPosteriors = new double[log10AlleleFrequencyPriors.length];
        Pair<Integer, Integer> result = this.linearExact(vc, log10AlleleFrequencyPriors, log10AlleleFrequencyLikelihoods, log10AlleleFrequencyPosteriors);
        int lastK = result.getFirst();
        int mleK = result.getSecond();
        double log10LikelihoodAFGt0 = lastK == 0 ? -1000000.0 : MathUtils.log10sumLog10(log10AlleleFrequencyLikelihoods, 1, lastK + 1);
        double[] log10Likelihoods = new double[]{log10AlleleFrequencyLikelihoods[0], log10LikelihoodAFGt0};
        double[] log10Priors = new double[]{log10AlleleFrequencyPriors[0], MathUtils.log10sumLog10(log10AlleleFrequencyPriors, 1)};
        double[] log10Posteriors = MathUtils.vectorSum(log10Likelihoods, log10Priors);
        double log10PRef = log10Posteriors[1] > log10Posteriors[0] ? -1000000.0 : 0.0;
        Map<Allele, Double> log10pRefByAllele = Collections.singletonMap(vc.getAlternateAllele(0), log10PRef);
        return new AFCalcResult(new int[]{mleK}, 0, vc.getAlleles(), MathUtils.normalizeFromLog10(log10Likelihoods, true), MathUtils.normalizeFromLog10(log10Priors, true), log10pRefByAllele);
    }

    public Pair<Integer, Integer> linearExact(VariantContext vc, double[] log10AlleleFrequencyPriors, double[] log10AlleleFrequencyLikelihoods, double[] log10AlleleFrequencyPosteriors) {
        ArrayList<double[]> genotypeLikelihoods = OriginalDiploidExactAFCalc.getGLs(vc.getGenotypes(), true);
        int numSamples = genotypeLikelihoods.size() - 1;
        int numChr = 2 * numSamples;
        ExactACCache logY = new ExactACCache(numSamples + 1);
        logY.getkMinus0()[0] = 0.0;
        double maxLog10L = Double.NEGATIVE_INFINITY;
        boolean done = false;
        int lastK = -1;
        int mleK = -1;
        for (int k = 0; k <= numChr && !done; ++k) {
            double log10LofK;
            double[] kMinus0 = logY.getkMinus0();
            if (k == 0) {
                for (int j = 1; j <= numSamples; ++j) {
                    kMinus0[j] = kMinus0[j - 1] + genotypeLikelihoods.get(j)[0];
                }
            } else {
                double[] kMinus1 = logY.getkMinus1();
                double[] kMinus2 = logY.getkMinus2();
                for (int j = 1; j <= numSamples; ++j) {
                    double log10Max;
                    double[] gl = genotypeLikelihoods.get(j);
                    double logDenominator = MathUtils.log10Cache[2 * j] + MathUtils.log10Cache[2 * j - 1];
                    double aa = Double.NEGATIVE_INFINITY;
                    double ab = Double.NEGATIVE_INFINITY;
                    if (k < 2 * j - 1) {
                        aa = MathUtils.log10Cache[2 * j - k] + MathUtils.log10Cache[2 * j - k - 1] + kMinus0[j - 1] + gl[0];
                    }
                    if (k < 2 * j) {
                        ab = MathUtils.log10Cache[2 * k] + MathUtils.log10Cache[2 * j - k] + kMinus1[j - 1] + gl[1];
                    }
                    if (k > 1) {
                        double bb = MathUtils.log10Cache[k] + MathUtils.log10Cache[k - 1] + kMinus2[j - 1] + gl[2];
                        log10Max = MathUtils.approximateLog10SumLog10(aa, ab, bb);
                    } else {
                        log10Max = MathUtils.approximateLog10SumLog10(aa, ab);
                    }
                    kMinus0[j] = log10Max - logDenominator;
                }
            }
            log10AlleleFrequencyLikelihoods[k] = log10LofK = kMinus0[numSamples];
            log10AlleleFrequencyPosteriors[k] = log10LofK + log10AlleleFrequencyPriors[k];
            lastK = k;
            if (log10LofK > maxLog10L) {
                maxLog10L = log10LofK;
                mleK = k;
            }
            if (log10LofK < maxLog10L - 6.0) {
                done = true;
            }
            logY.rotate();
        }
        return new Pair<Integer, Integer>(lastK, mleK);
    }

    private static final class ExactACCache {
        double[] kMinus2;
        double[] kMinus1;
        double[] kMinus0;

        private static double[] create(int n) {
            return new double[n];
        }

        public ExactACCache(int n) {
            this.kMinus2 = ExactACCache.create(n);
            this.kMinus1 = ExactACCache.create(n);
            this.kMinus0 = ExactACCache.create(n);
        }

        public final void rotate() {
            double[] tmp = this.kMinus2;
            this.kMinus2 = this.kMinus1;
            this.kMinus1 = this.kMinus0;
            this.kMinus0 = tmp;
        }

        public final double[] getkMinus2() {
            return this.kMinus2;
        }

        public final double[] getkMinus1() {
            return this.kMinus1;
        }

        public final double[] getkMinus0() {
            return this.kMinus0;
        }
    }
}

