/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.haplotypecaller;

import com.google.java.contract.Ensures;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.DeBruijnEdge;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.DeBruijnVertex;
import org.jgrapht.graph.DefaultDirectedGraph;

public class DeBruijnAssemblyGraph
extends DefaultDirectedGraph<DeBruijnVertex, DeBruijnEdge> {
    public DeBruijnAssemblyGraph() {
        super(DeBruijnEdge.class);
    }

    public boolean isReferenceNode(DeBruijnVertex v) {
        if (v == null) {
            throw new IllegalArgumentException("Attempting to test a null vertex.");
        }
        for (DeBruijnEdge e : this.edgesOf(v)) {
            if (!e.isRef()) continue;
            return true;
        }
        return false;
    }

    public boolean isSource(DeBruijnVertex v) {
        if (v == null) {
            throw new IllegalArgumentException("Attempting to test a null vertex.");
        }
        return this.inDegreeOf(v) == 0;
    }

    @Ensures(value={"result != null"})
    public byte[] getAdditionalSequence(DeBruijnVertex v) {
        if (v == null) {
            throw new IllegalArgumentException("Attempting to pull sequence from a null vertex.");
        }
        return this.isSource(v) ? v.getSequence() : v.getSuffix();
    }

    public boolean isRefSource(DeBruijnEdge e) {
        if (e == null) {
            throw new IllegalArgumentException("Attempting to test a null edge.");
        }
        for (DeBruijnEdge edgeToTest : this.incomingEdgesOf(this.getEdgeSource(e))) {
            if (!edgeToTest.isRef()) continue;
            return false;
        }
        return true;
    }

    public boolean isRefSource(DeBruijnVertex v) {
        if (v == null) {
            throw new IllegalArgumentException("Attempting to test a null vertex.");
        }
        for (DeBruijnEdge edgeToTest : this.incomingEdgesOf(v)) {
            if (!edgeToTest.isRef()) continue;
            return false;
        }
        return true;
    }

    public boolean isRefSink(DeBruijnEdge e) {
        if (e == null) {
            throw new IllegalArgumentException("Attempting to test a null edge.");
        }
        for (DeBruijnEdge edgeToTest : this.outgoingEdgesOf(this.getEdgeTarget(e))) {
            if (!edgeToTest.isRef()) continue;
            return false;
        }
        return true;
    }

    public boolean isRefSink(DeBruijnVertex v) {
        if (v == null) {
            throw new IllegalArgumentException("Attempting to test a null vertex.");
        }
        for (DeBruijnEdge edgeToTest : this.outgoingEdgesOf(v)) {
            if (!edgeToTest.isRef()) continue;
            return false;
        }
        return true;
    }

    public DeBruijnVertex getReferenceSourceVertex() {
        for (DeBruijnVertex v : this.vertexSet()) {
            if (!this.isReferenceNode(v) || !this.isRefSource(v)) continue;
            return v;
        }
        return null;
    }

    public DeBruijnVertex getReferenceSinkVertex() {
        for (DeBruijnVertex v : this.vertexSet()) {
            if (!this.isReferenceNode(v) || !this.isRefSink(v)) continue;
            return v;
        }
        return null;
    }

    public DeBruijnVertex getNextReferenceVertex(DeBruijnVertex v) {
        if (v == null) {
            return null;
        }
        for (DeBruijnEdge edgeToTest : this.outgoingEdgesOf(v)) {
            if (!edgeToTest.isRef()) continue;
            return (DeBruijnVertex)this.getEdgeTarget(edgeToTest);
        }
        return null;
    }

    public DeBruijnVertex getPrevReferenceVertex(DeBruijnVertex v) {
        if (v == null) {
            return null;
        }
        for (DeBruijnEdge edgeToTest : this.incomingEdgesOf(v)) {
            if (!this.isReferenceNode((DeBruijnVertex)this.getEdgeSource(edgeToTest))) continue;
            return (DeBruijnVertex)this.getEdgeSource(edgeToTest);
        }
        return null;
    }

    public boolean referencePathExists(DeBruijnVertex fromVertex, DeBruijnVertex toVertex) {
        DeBruijnVertex v = fromVertex;
        if (v == null) {
            return false;
        }
        if ((v = this.getNextReferenceVertex(v)) == null) {
            return false;
        }
        while (!v.equals(toVertex)) {
            if ((v = this.getNextReferenceVertex(v)) != null) continue;
            return false;
        }
        return true;
    }

    public byte[] getReferenceBytes(DeBruijnVertex fromVertex, DeBruijnVertex toVertex, boolean includeStart, boolean includeStop) {
        if (fromVertex == null) {
            throw new IllegalArgumentException("Starting vertex in requested path cannot be null.");
        }
        if (toVertex == null) {
            throw new IllegalArgumentException("From vertex in requested path cannot be null.");
        }
        byte[] bytes = null;
        DeBruijnVertex v = fromVertex;
        if (includeStart) {
            bytes = ArrayUtils.addAll(bytes, this.getAdditionalSequence(v));
        }
        v = this.getNextReferenceVertex(v);
        while (v != null && !v.equals(toVertex)) {
            bytes = ArrayUtils.addAll(bytes, this.getAdditionalSequence(v));
            v = this.getNextReferenceVertex(v);
        }
        if (includeStop && v != null && v.equals(toVertex)) {
            bytes = ArrayUtils.addAll(bytes, this.getAdditionalSequence(v));
        }
        return bytes;
    }

    public void addSequenceToGraph(byte[] sequence, int KMER_LENGTH, boolean isRef) {
        if (sequence.length < KMER_LENGTH + 1) {
            throw new IllegalArgumentException("Provided sequence is too small for the given kmer length");
        }
        int kmersInSequence = sequence.length - KMER_LENGTH + 1;
        for (int iii = 0; iii < kmersInSequence - 1; ++iii) {
            this.addKmersToGraph(Arrays.copyOfRange(sequence, iii, iii + KMER_LENGTH), Arrays.copyOfRange(sequence, iii + 1, iii + 1 + KMER_LENGTH), isRef);
        }
    }

    public boolean addKmersToGraph(byte[] kmer1, byte[] kmer2, boolean isRef) {
        if (kmer1 == null) {
            throw new IllegalArgumentException("Attempting to add a null kmer to the graph.");
        }
        if (kmer2 == null) {
            throw new IllegalArgumentException("Attempting to add a null kmer to the graph.");
        }
        if (kmer1.length != kmer2.length) {
            throw new IllegalArgumentException("Attempting to add a kmers to the graph with different lengths.");
        }
        int numVertexBefore = this.vertexSet().size();
        DeBruijnVertex v1 = new DeBruijnVertex(kmer1, kmer1.length);
        this.addVertex(v1);
        DeBruijnVertex v2 = new DeBruijnVertex(kmer2, kmer2.length);
        this.addVertex(v2);
        if (isRef && this.vertexSet().size() == numVertexBefore) {
            return false;
        }
        DeBruijnEdge targetEdge = (DeBruijnEdge)this.getEdge(v1, v2);
        if (targetEdge == null) {
            this.addEdge(v1, v2, new DeBruijnEdge(isRef));
        } else {
            if (isRef) {
                targetEdge.setIsRef(true);
            }
            targetEdge.setMultiplicity(targetEdge.getMultiplicity() + 1);
        }
        return true;
    }

    public void printGraph(PrintStream GRAPH_WRITER) {
        if (GRAPH_WRITER == null) {
            throw new IllegalArgumentException("PrintStream cannot be null.");
        }
        GRAPH_WRITER.println("digraph assembly {");
        for (DeBruijnEdge edge : this.edgeSet()) {
            GRAPH_WRITER.println("\t" + ((DeBruijnVertex)this.getEdgeSource(edge)).toString() + " -> " + ((DeBruijnVertex)this.getEdgeTarget(edge)).toString() + " [" + "label=\"" + edge.getMultiplicity() + "\"" + "];");
            if (!edge.isRef()) continue;
            GRAPH_WRITER.println("\t" + ((DeBruijnVertex)this.getEdgeSource(edge)).toString() + " -> " + ((DeBruijnVertex)this.getEdgeTarget(edge)).toString() + " [color=red];");
        }
        for (DeBruijnVertex v : this.vertexSet()) {
            String label = this.inDegreeOf(v) == 0 ? v.toString() : v.getSuffixString();
            GRAPH_WRITER.println("\t" + v.toString() + " [label=\"" + label + "\"]");
        }
        GRAPH_WRITER.println("}");
    }
}

